/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pq.util;

import java.util.Arrays;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.service.CPOS;
import org.adempiere.pos.util.POSTicketHandler;
import org.compiere.model.MOrder;
import org.compiere.print.ReportEngine;
import org.compiere.util.Env;
import org.spin.model.MADAppRegistration;
import org.spin.pq.support.IPrintQueue;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class PrintTicketHandler
extends POSTicketHandler {
    public PrintTicketHandler(CPOS pos) {
        super(pos);
    }

    public void printTicket() {
        int printQueueId = this.getPOS().getM_POS().get_ValueAsInt("PrintQueue_ID");
        MOrder order = this.getPOS().getOrder();
        if (printQueueId > 0) {
            try {
                MADAppRegistration registeredApplication = MADAppRegistration.getById((Properties)Env.getCtx(), (int)printQueueId, (String)order.get_TrxName());
                IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
                if (supportedApplication != null && IPrintQueue.class.isAssignableFrom(supportedApplication.getClass())) {
                    IPrintQueue printQueue = (IPrintQueue)supportedApplication;
                    if (!this.getPOS().isInvoiced()) {
                        ReportEngine reportEngine = ReportEngine.get((Properties)this.getPOS().getCtx(), (int)0, (int)order.getC_Order_ID(), (String)order.get_TrxName());
                        printQueue.printDocument(reportEngine.getName(), reportEngine.createPDFData());
                    } else {
                        Arrays.asList(order.getInvoices()).forEach(invoice -> {
                            ReportEngine reportEngine = ReportEngine.get((Properties)invoice.getCtx(), (int)2, (int)invoice.getC_Invoice_ID(), (String)invoice.get_TrxName());
                            printQueue.printDocument(reportEngine.getName(), reportEngine.createPDFData());
                        });
                    }
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
    }

    public void openDrawer() {
    }

    public void showMessage(String message) {
    }
}

