/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pq.util;

import java.io.File;
import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.model.MADAppRegistration;
import org.spin.pq.support.IPrintQueue;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class PrintQueueUtil {
    public static final String COLUMNNAME_PrintQueue_ID = "PrintQueue_ID";
    public static final String COLUMNNAME_IsPrintedOnPrintQueue = "IsPrintedOnPrintQueue";
    public static final String COLUMNNAME_IsPrintedAfterComplete = "IsPrintedOnQueueAfterComplete";

    public static void sendDocumentToQueue(PO entity, int printQueueId) {
        int documentTypeId = entity.get_ValueAsInt("C_DocTypeTarget_ID");
        if (documentTypeId <= 0) {
            documentTypeId = entity.get_ValueAsInt("C_DocType_ID");
        }
        if (documentTypeId <= 0) {
            return;
        }
        MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)documentTypeId);
        if (documentType.get_ValueAsInt(COLUMNNAME_PrintQueue_ID) <= 0 && printQueueId <= 0) {
            throw new AdempiereException("@PrintQueue_ID@ @IsMandatory@");
        }
        if (printQueueId <= 0) {
            printQueueId = documentType.get_ValueAsInt(COLUMNNAME_PrintQueue_ID);
        }
        if (documentType.getAD_PrintFormat_ID() <= 0) {
            throw new AdempiereException("@AD_PrintFormat_ID@ @IsMandatory@");
        }
        PrintQueueUtil.sendDocumentToQueue(entity, documentType.getAD_PrintFormat_ID(), printQueueId);
    }

    public static void sendDocumentToQueue(PO entity, int printFormatId, int printQueueId) {
        try {
            MADAppRegistration registeredApplication = MADAppRegistration.getById((Properties)Env.getCtx(), (int)printQueueId, (String)entity.get_TrxName());
            IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
            if (supportedApplication != null && IPrintQueue.class.isAssignableFrom(supportedApplication.getClass())) {
                IPrintQueue printQueue = (IPrintQueue)supportedApplication;
                MPrintFormat printFormat = MPrintFormat.get((Properties)entity.getCtx(), (int)printFormatId, (boolean)false);
                if (printFormat.getJasperProcess_ID() > 0) {
                    ProcessBuilder builder = ProcessBuilder.create((Properties)entity.getCtx()).process(Integer.valueOf(printFormat.getJasperProcess_ID())).withTitle(entity.get_UUID()).withRecordId(Integer.valueOf(entity.get_Table_ID()), Integer.valueOf(entity.get_ID())).withParameter(entity.get_TableName() + "_ID", (Object)new BigDecimal(entity.get_ID())).withoutTransactionClose().withoutPrintPreview();
                    ProcessInfo processInfo = builder.execute(entity.get_TrxName());
                    File document = processInfo.getPDFReport();
                    if (document == null) {
                        document = processInfo.getReportAsFile();
                    }
                    if (document != null) {
                        printQueue.printDocument(document);
                    }
                } else {
                    ReportEngine reportEngine = PrintQueueUtil.getReportEngine(entity, printFormat);
                    printQueue.printDocument(reportEngine.getPDF());
                }
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    private static ReportEngine getReportEngine(PO entity, MPrintFormat printFormat) {
        MQuery query = new MQuery(entity.get_TableName());
        query.addRestriction(entity.get_TableName() + "_ID", "=", entity.get_ID());
        printFormat.setLanguage(Language.getLoginLanguage());
        printFormat.setTranslationLanguage(Language.getLoginLanguage());
        PrintInfo info = new PrintInfo(entity.get_TableName(), entity.get_Table_ID(), printFormat.getAD_PrintFormat_ID());
        ReportEngine reportEngine = new ReportEngine(entity.getCtx(), printFormat, query, info, entity.get_TrxName());
        return reportEngine;
    }
}

