/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pq.util;

import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.adempiere.exceptions.AdempiereException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.compiere.util.CLogger;
import org.spin.tools.kafka.util.MapDeserializer;

public class FileReaderRunner
implements Runnable {
    private String topicName = null;
    private String completeUrl = null;
    private boolean running = false;
    private Thread worker;
    private CLogger log = CLogger.getCLogger(FileReaderRunner.class);
    BigDecimal weight = null;

    public FileReaderRunner(String host, int port, String topicName) {
        this.topicName = topicName;
        this.completeUrl = host + ":" + port;
    }

    @Override
    public void run() {
        this.running = true;
        try {
            Long timeStart = System.currentTimeMillis();
            Properties config = new Properties();
            config.put("client.id", InetAddress.getLocalHost().getHostName());
            config.put("group.id", "foo");
            config.put("bootstrap.servers", this.completeUrl);
            config.put("auto.offset.reset", "latest");
            config.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            config.put("value.deserializer", MapDeserializer.class.getName());
            KafkaConsumer consumer = new KafkaConsumer(config);
            consumer.subscribe(Arrays.asList(this.topicName));
            while (this.running) {
                consumer.poll(Duration.ofSeconds(10L));
                AtomicLong maxTimestamp = new AtomicLong();
                consumer.endOffsets((Collection)consumer.assignment()).forEach((topicPartition, offset) -> {
                    consumer.seek(topicPartition, offset == 0L ? offset : offset - 1L);
                    consumer.poll(Duration.ofSeconds(10L)).forEach(record -> {
                        if (record != null) {
                            try {
                                Map value = (Map)record.value();
                                String fileName = (String)value.get("name");
                                String fileValue = (String)value.get("document");
                                byte[] arrayOfByte = Base64.getDecoder().decode(fileValue);
                                FileOutputStream stream = new FileOutputStream("/tmp/" + fileName);
                                stream.write(arrayOfByte);
                                if (record.timestamp() > maxTimestamp.get()) {
                                    maxTimestamp.set(record.timestamp());
                                }
                            }
                            catch (Exception e) {
                                throw new AdempiereException((Throwable)e);
                            }
                        }
                    });
                });
                consumer.commitSync();
                long timeEnd = System.currentTimeMillis();
                if (timeEnd - timeStart <= 40000L) continue;
                this.stop();
            }
            consumer.unsubscribe();
            consumer.close(Duration.ofSeconds(1L));
            this.worker.interrupt();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
    }

    public void stop() {
        this.log.fine("Service Worker Stoping...");
        this.running = false;
    }

    public void start() {
        this.log.fine("Service Worker Starting...");
        this.worker = new Thread(this);
        this.worker.start();
    }
}

