/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pq.support.kafka;

import java.io.File;
import java.io.FileInputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.adempiere.exceptions.AdempiereException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.pq.support.IPrintQueue;
import org.spin.tools.kafka.util.KafkaLoader;

public class PrintQueue
implements IPrintQueue {
    private int registrationId = 0;
    private CLogger log = CLogger.getCLogger(PrintQueue.class);
    private int port;
    private String printerName = null;
    private String portName = null;
    private String host = null;
    public static final String FILE_NAME_KEY = "name";
    public static final String FILE_KEY = "document";
    public static final String PORT_NAME_KEY = "port_name";
    public static final String PRINTER_NAME_KEY = "printer_name";
    public static final String PORT_NAME = "PORT_NAME";
    public static final String QUEUE_NAME = "QUEUE_NAME";

    public String testConnection() {
        MOrder order = (MOrder)new Query(Env.getCtx(), "C_Order", "IsSOTrx = 'Y' AND DocStatus = 'CO'", null).setClient_ID().setLimit(1).first();
        this.printDocument(order.createPDF());
        return "Ok";
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.port = registration.getPort();
        this.host = registration.getHost();
        MOrg client = MOrg.get((Properties)Env.getCtx(), (int)registration.getAD_Org_ID());
        this.printerName = client.getValue() + "-" + registration.getValue();
        this.portName = registration.getParameterValue(PORT_NAME);
        String queueName = registration.getParameterValue(QUEUE_NAME);
        if (!Util.isEmpty((String)queueName)) {
            this.printerName = queueName;
        }
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public void printDocument(String documentName, byte[] documentAsArray) {
        if (Util.isEmpty((String)documentName)) {
            throw new AdempiereException("@FileName@ @NotFound@");
        }
        if (documentAsArray == null || documentAsArray.length == 0) {
            throw new AdempiereException("@PrintDocument@ @NotFound@");
        }
        this.log.fine("Document to Print: " + documentName);
        String extension = "";
        if (documentName.lastIndexOf(".") > 0) {
            extension = documentName.substring(documentName.lastIndexOf("."));
            documentName = documentName.replaceAll(extension, "");
        }
        documentName = UUID.randomUUID().toString() + "-" + documentName.replaceAll("[^-0-9A-Za-z]", "-") + extension;
        this.log.fine("Document to Print (Changed): " + documentName);
        try {
            String base64File = Base64.getEncoder().encodeToString(documentAsArray);
            KafkaProducer producer = KafkaLoader.getInstance().getProducer(this.host + ":" + this.port, this.getValidPrinterName());
            HashMap<String, String> fileToSend = new HashMap<String, String>();
            fileToSend.put(FILE_NAME_KEY, documentName);
            fileToSend.put(FILE_KEY, base64File);
            fileToSend.put(PRINTER_NAME_KEY, this.printerName);
            fileToSend.put(PORT_NAME_KEY, this.portName);
            ProducerRecord record = new ProducerRecord(this.getValidPrinterName(), (Object)"print_queue_document", fileToSend);
            producer.send(record);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    private String getValidPrinterName() {
        return Optional.ofNullable(this.printerName).orElse("").replaceAll("[^-0-9A-Za-z]", "").toLowerCase();
    }

    @Override
    public void printDocument(File file) {
        this.log.fine("Document to Print: " + file);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] documentAsArray = new byte[(int)file.length()];
            fileInputStream.read(documentAsArray);
            fileInputStream.close();
            this.printDocument(file.getName(), documentAsArray);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }
}

