/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pq.setup;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.spin.model.MADAppRegistration;
import org.spin.pq.support.kafka.PrintQueue;
import org.spin.util.ISetupDefinition;

public class CreateDefaultKafkaQueue
implements ISetupDefinition {
    private static final String DESCRIPTION = "(*Created from Setup Automatically*)";
    private static final String UUID = "(*AutomaticSetup*)";
    private static final String NAME = "Default Print Queue";
    private static final String APPLICATION_TYPE = "PQS";

    public String doIt(Properties context, String transactionName) {
        this.createRegistration(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private MADAppRegistration createRegistration(Properties context, String transactionName) {
        MADAppRegistration registration = (MADAppRegistration)new Query(context, "AD_AppRegistration", "EXISTS(SELECT 1 FROM AD_AppSupport s WHERE s.ApplicationType = ? AND s.AD_AppSupport_ID = AD_AppRegistration.AD_AppSupport_ID AND s.Classname = ?)", transactionName).setParameters(new Object[]{APPLICATION_TYPE, PrintQueue.class.getName()}).setClient_ID().first();
        if (registration != null && registration.getAD_AppRegistration_ID() > 0) {
            return registration;
        }
        int supportId = new Query(context, "AD_AppSupport", "ApplicationType = ?", transactionName).setParameters(new Object[]{APPLICATION_TYPE}).firstId();
        if (supportId <= 0) {
            throw new AdempiereException("@AD_AppSupport_ID@ @NotDound@");
        }
        registration = new MADAppRegistration(context, 0, transactionName);
        registration.setName(NAME);
        registration.setDescription(DESCRIPTION);
        registration.setApplicationType(APPLICATION_TYPE);
        registration.setAD_AppSupport_ID(supportId);
        registration.setValue("Default-Print-Queue");
        registration.setHost("localhost");
        registration.setPort(9092);
        registration.setVersionNo("1.0");
        registration.saveEx();
        registration.setUUID(UUID);
        registration.saveEx();
        return registration;
    }
}

