/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pq.model.validator;

import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.pq.util.PrintQueueUtil;

public class PrintQueueValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(PrintQueueValidator.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        new Query(Env.getCtx(), "AD_Table", "TableName <> ? AND EXISTS(SELECT 1 FROM AD_Column c WHERE c.AD_Table_ID = AD_Table.AD_Table_ID AND c.ColumnName IN(?, ?))", null).setParameters(new Object[]{"C_DocType", "C_DocType_ID", "C_DocTypeTarget_ID"}).getIDsAsList().forEach(tableId -> engine.addDocValidate(MTable.get((Properties)Env.getCtx(), (int)tableId).getTableName(), (ModelValidator)this));
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        return null;
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 9) {
            int documentTypeId = entity.get_ValueAsInt("C_DocTypeTarget_ID");
            if (documentTypeId <= 0) {
                documentTypeId = entity.get_ValueAsInt("C_DocType_ID");
            }
            if (documentTypeId <= 0) {
                return null;
            }
            MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)documentTypeId);
            if (documentType.get_ValueAsBoolean("IsPrintedOnPrintQueue") && documentType.get_ValueAsBoolean("IsPrintedOnQueueAfterComplete") && documentType.getAD_PrintFormat_ID() > 0) {
                int reversalIdIndex = entity.get_ColumnIndex("Reversal_ID");
                if (reversalIdIndex > 0 && entity.get_ValueAsInt(reversalIdIndex) > 0) {
                    return null;
                }
                PrintQueueUtil.sendDocumentToQueue(entity, documentType.getAD_PrintFormat_ID(), documentType.get_ValueAsInt("PrintQueue_ID"));
            }
        }
        return null;
    }
}

