/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support.elasticsearch;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.apache.http.HttpHost;
import org.compiere.model.MStore;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.spin.model.MADAppRegistration;
import org.spin.support.IExternalCache;
import org.spin.util.support.IAppSupport;
import org.spin.util.support.elasticsearch.IPersistenceWrapper;

public class ElasticSearch
implements IExternalCache,
IAppSupport {
    private String host = "localhost";
    private int port = 9200;
    private String schema = "http";
    private RestHighLevelClient client;
    private static CLogger log = CLogger.getCLogger(ElasticSearch.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private int registrationId = 0;
    private final String SCHEMA_KEY = "SCHEMA";
    private MStore webStore;

    public static String convertedDate(long millis) {
        return new SimpleDateFormat(DATE_FORMAT).format(millis);
    }

    private void validate() {
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration registration = MADAppRegistration.getById(Env.getCtx(), this.getAppRegistrationId(), null);
        this.withHost(registration.getHost());
        this.withPort(registration.getPort());
        this.withSchema(registration.getParameterValue("SCHEMA"));
        if (Util.isEmpty(this.getHost())) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        if (Util.isEmpty(this.getSchema())) {
            throw new AdempiereException("@Schema@ @NotFound@");
        }
        if (this.port <= 0) {
            throw new AdempiereException("@Port@ @NotFound@");
        }
    }

    @Override
    public ElasticSearch connect() throws IOException {
        if (this.client != null) {
            return this;
        }
        this.validate();
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.host, this.port, this.schema)}));
        return this;
    }

    @Override
    public ElasticSearch close() throws IOException {
        if (this.client == null) {
            return this;
        }
        this.client.close();
        this.client = null;
        return this;
    }

    public final String getHost() {
        return this.host;
    }

    public final ElasticSearch withHost(String host) {
        this.host = host;
        return this;
    }

    public final int getPort() {
        return this.port;
    }

    public final ElasticSearch withPort(int port) {
        this.port = port;
        return this;
    }

    public final String getSchema() {
        return this.schema;
    }

    public final ElasticSearch withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    @Override
    public ElasticSearch index(IPersistenceWrapper entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid()) {
            if (this.exist(entity)) {
                return this.update(entity);
            }
            try {
                GetIndexRequest getRequest = new GetIndexRequest(new String[]{this.getCatalogName(entity.getCatalogName())});
                if (!this.client.indices().exists(getRequest, RequestOptions.DEFAULT)) {
                    CreateIndexRequest indexDefinition = new CreateIndexRequest(this.getCatalogName(entity.getCatalogName()));
                    Map<String, Object> mapping = entity.getMapping();
                    if (Optional.ofNullable(mapping).isPresent()) {
                        indexDefinition.mapping(mapping);
                        this.client.indices().create(indexDefinition, RequestOptions.DEFAULT);
                    }
                }
            }
            catch (Exception e) {
                throw new AdempiereException(e);
            }
            IndexRequest indexRequest = new IndexRequest(this.getCatalogName(entity.getCatalogName())).id(entity.getKeyValue()).source(entity.getMap());
            indexRequest.opType(DocWriteRequest.OpType.CREATE);
            IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
            if (indexResponse.getResult() == DocWriteResponse.Result.CREATED) {
                log.fine("Entity Created: " + entity.getKeyValue());
            } else if (indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                log.fine("Entity Updated: " + entity.getKeyValue());
            }
            ReplicationResponse.ShardInfo shardInfo = indexResponse.getShardInfo();
            if (shardInfo.getTotal() != shardInfo.getSuccessful()) {
                log.fine("Entity Created: " + entity.getKeyValue());
            }
            if (shardInfo.getFailed() > 0) {
                for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
                    String reason = failure.reason();
                    log.warning("Entity Index Error: " + entity.getKeyValue() + " - Reason: " + reason);
                }
            }
        }
        return this;
    }

    @Override
    public ElasticSearch update(IPersistenceWrapper entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid()) {
            if (!this.exist(entity)) {
                return this.index(entity);
            }
            this.delete(entity);
            return this.index(entity);
        }
        return this;
    }

    @Override
    public ElasticSearch delete(IPersistenceWrapper entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid() && this.exist(entity)) {
            DeleteRequest request = new DeleteRequest(this.getCatalogName(entity.getCatalogName()), entity.getKeyValue());
            DeleteResponse deleteResponse = this.client.delete(request, RequestOptions.DEFAULT);
            ReplicationResponse.ShardInfo shardInfo = deleteResponse.getShardInfo();
            if (shardInfo.getTotal() != shardInfo.getSuccessful()) {
                log.fine("Entity Deleted: " + entity.getKeyValue());
            }
            if (shardInfo.getFailed() > 0) {
                for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
                    String reason = failure.reason();
                    log.warning("Entity Delete Error: " + entity.getKeyValue() + " - Reason: " + reason);
                }
            }
        }
        return this;
    }

    @Override
    public boolean exist(IPersistenceWrapper entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid()) {
            GetRequest getRequest = new GetRequest(this.getCatalogName(entity.getCatalogName()), entity.getKeyValue());
            getRequest.fetchSourceContext(new FetchSourceContext(false));
            getRequest.storedFields(new String[]{"_none_"});
            return this.client.exists(getRequest, RequestOptions.DEFAULT);
        }
        return false;
    }

    @Override
    public String testConnection() {
        this.validate();
        String message = null;
        try {
            this.connect();
            message = "Ok: " + this.exist(new IPersistenceWrapper(){

                @Override
                public Map<String, Object> getMap() {
                    return new HashMap<String, Object>();
                }

                @Override
                public String getKeyValue() {
                    return "1";
                }

                @Override
                public String getCatalogName() {
                    return "product";
                }

                @Override
                public boolean isValid() {
                    return true;
                }

                @Override
                public IPersistenceWrapper withWebStoreId(int webStoreId) {
                    return null;
                }

                @Override
                public Map<String, Object> getMapping() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
        finally {
            try {
                this.close();
            }
            catch (Exception e) {
                throw new AdempiereException(e.getMessage());
            }
        }
        return message;
    }

    private String getCatalogName(String entityCatalog) {
        return (this.webStore.getWebContext() + "_" + entityCatalog).trim().toLowerCase().replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    @Override
    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
    }

    @Override
    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public void withWebStore(MStore webStore) {
        this.webStore = webStore;
    }

    @Override
    public int getCacheId() {
        return this.getAppRegistrationId();
    }
}

