/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.docs;

import java.util.ArrayList;
import java.util.List;
import org.compiere.util.Util;

public class TableTextConverter {
    private List<List<String>> rows = new ArrayList<List<String>>();

    public TableTextConverter() {
    }

    public TableTextConverter(List<String> columnNames) {
        this();
        if (columnNames != null && columnNames.size() > 0) {
            this.addRow(columnNames);
        }
    }

    public void addRow(List<String> row) {
        this.rows.add(row);
    }

    public List<String> getRow(int index) {
        if (index >= this.rows.size()) {
            return null;
        }
        return this.rows.get(index);
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public int getMaxColumnSize(int columnIndex) {
        if (this.rows.size() == 0) {
            return -1;
        }
        int maxSize = 0;
        for (List<String> row : this.rows) {
            String columnText;
            if (columnIndex >= row.size() || Util.isEmpty(columnText = row.get(columnIndex)) || columnText.length() <= maxSize) continue;
            maxSize = columnText.length();
        }
        return maxSize;
    }
}

