/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.docs;

import java.util.ArrayList;
import java.util.List;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.util.docs.AbstractTextConverter;
import org.spin.util.docs.IIndex;
import org.spin.util.docs.TableTextConverter;

public class ReStructuredTextConverter
extends AbstractTextConverter
implements IIndex {
    private StringBuffer formattedText;
    private StringBuffer translatedText;
    private int previouslevel = -1;
    private StringBuffer urlSource;
    private CLogger log = CLogger.getCLogger(this.getClass());

    public ReStructuredTextConverter() {
        this.formattedText = new StringBuffer();
        this.translatedText = new StringBuffer();
        this.urlSource = new StringBuffer();
    }

    @Override
    public AbstractTextConverter addText(String text) {
        this.formattedText.append(this.formatText(text));
        this.log.fine("addText=" + text);
        return this;
    }

    private String formatText(String text) {
        return text.replaceAll("(?i)<p */?>", "").replaceAll("(?i)<br */?>\\n", "\n").replaceAll("(?i)<br */?>", "* ").replaceAll("(?i)<b */?>", "\\\\ **").replaceAll("(?i)</b */?>", "**\\\\ ");
    }

    @Override
    public AbstractTextConverter addBold(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addBold=" + text);
        this.addText(this.formatBold(text));
        return this;
    }

    @Override
    public AbstractTextConverter addItalic(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addItalic=" + text);
        this.addText(this.formatItalic(text));
        return this;
    }

    @Override
    public AbstractTextConverter addCode(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addCode=" + text);
        this.newLine();
        this.newLine();
        this.addText(this.formatCode(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addQuote(String text, int level) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addQuote=" + text);
        this.newLine();
        this.addText(this.formatQuote(text, false, level));
        return this;
    }

    @Override
    public AbstractTextConverter addQuote(String text) {
        return this.addQuote(text, 0);
    }

    @Override
    public AbstractTextConverter addQuoteNumeric(String text, int level) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addQuoteNumeric=" + text);
        this.newLine();
        this.addText(this.formatQuote(text, true, level));
        return this;
    }

    @Override
    public AbstractTextConverter addQuoteNumeric(String text) {
        return this.addQuoteNumeric(text, 0);
    }

    @Override
    public AbstractTextConverter addSection(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addSection=" + text);
        this.newLine();
        this.addText(this.formatSection(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addSubSection(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addSubSection=" + text);
        this.newLine();
        this.addText(this.formatSubSection(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addSubSubSection(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addSubSubSection=" + text);
        this.newLine();
        this.addText(this.formatSubSubSection(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addParagraph(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addParagraph=" + text);
        this.newLine();
        this.addText(this.formatParagraphs(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addPart(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addPart=" + text);
        this.newLine();
        this.addText(this.formatPart(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addChapter(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addChapter=" + text);
        this.newLine();
        this.addText(this.formatChapter(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addExternalLink(String text, String link2) {
        if (Util.isEmpty(text) || Util.isEmpty(link2)) {
            return this;
        }
        this.log.fine("addExternalLink=" + text);
        this.addText(this.formatExternalLinkText(text));
        this.urlSource.append(this.formatExternalLink(text, link2));
        return this;
    }

    @Override
    public AbstractTextConverter addSeeAlso(String internalLink) {
        return this.addSeeAlso(null, internalLink);
    }

    @Override
    public AbstractTextConverter addSeeAlso(String name, String internalLink) {
        if (Util.isEmpty(internalLink)) {
            return this;
        }
        this.log.fine("addSeeAlso=" + internalLink);
        this.formattedText.append(this.formatSeeAlso(internalLink));
        return this;
    }

    @Override
    public AbstractTextConverter addHeaderIndexName(String indexName) {
        if (Util.isEmpty(indexName)) {
            return this;
        }
        this.log.fine("addSeeAlso=" + indexName);
        this.addText(this.formatHeaderIndexName(indexName));
        return this;
    }

    @Override
    public AbstractTextConverter addComment(String comment2) {
        if (Util.isEmpty(comment2)) {
            return this;
        }
        this.log.fine("addComment=" + comment2);
        this.addText(this.formatComment(comment2));
        return this;
    }

    @Override
    public AbstractTextConverter addNote(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.addText(this.formatNote(text));
        return this;
    }

    @Override
    public AbstractTextConverter addTable(TableTextConverter table2) {
        List<String> firstRow;
        this.log.fine("addTable=" + table2);
        if (table2.getRows().size() != 0 && (firstRow = table2.getRow(0)).size() != 0) {
            String columnSeparator = "  ";
            int[] maxSizes = new int[firstRow.size()];
            this.newLine();
            boolean isFirst = true;
            StringBuffer headerLine = new StringBuffer();
            for (List<String> row : table2.getRows()) {
                this.newLine();
                StringBuffer text = new StringBuffer();
                for (int columnIndex = 0; columnIndex < maxSizes.length; ++columnIndex) {
                    int size;
                    String columnText = "";
                    if (columnIndex < row.size()) {
                        maxSizes[columnIndex] = table2.getMaxColumnSize(columnIndex);
                        columnText = row.get(columnIndex);
                        if (Util.isEmpty(columnText)) {
                            columnText = "";
                        }
                    }
                    if ((size = maxSizes[columnIndex]) > 0) {
                        columnText = this.isNumeric(columnText) ? String.format("%1$" + size + "s", columnText) : String.format("%1$-" + size + "s", columnText);
                    }
                    if (text.length() > 0) {
                        text.append(columnSeparator);
                    }
                    text.append(columnText);
                    if (!isFirst) continue;
                    if (headerLine.length() > 0) {
                        headerLine.append(columnSeparator);
                    }
                    headerLine.append(this.getParalelChar(columnText, "="));
                }
                if (isFirst) {
                    this.addText(headerLine.toString());
                    this.newLine();
                    this.addText(text.toString());
                    this.newLine();
                    this.addText(headerLine.toString());
                    isFirst = false;
                    continue;
                }
                this.addText(text.toString());
            }
            this.newLine();
            this.addText(headerLine.toString());
            this.newLine();
        }
        return this;
    }

    private String formatBold(String text) {
        StringBuffer formattedValue = new StringBuffer();
        formattedValue.append("\\ **").append(text.trim()).append("**\\ ");
        return formattedValue.toString();
    }

    private String formatItalic(String text) {
        StringBuffer formattedValue = new StringBuffer();
        formattedValue.append("\\ *").append(text.trim()).append("*\\ ");
        return formattedValue.toString();
    }

    private String formatCode(String text) {
        StringBuffer formattedValue = new StringBuffer();
        formattedValue.append("``").append(text.trim()).append("``");
        return formattedValue.toString();
    }

    private String formatQuote(String text, boolean isNumeric, int level) {
        if (this.previouslevel != level) {
            this.newLine();
        }
        this.previouslevel = level;
        StringBuffer formattedValue = new StringBuffer();
        String leftSpace = "";
        if (level > 0) {
            leftSpace = String.format("%1$" + level + "s", "");
        }
        String type = "*";
        if (isNumeric) {
            type = "#.";
        }
        formattedValue.append(leftSpace).append(type).append(" ").append(text);
        return formattedValue.toString();
    }

    private String formatHeader(String text, String underValue) {
        StringBuffer formattedValue = new StringBuffer(text.trim());
        formattedValue.append(Env.NL);
        formattedValue.append(this.getParalelChar(text.trim(), underValue));
        return formattedValue.toString();
    }

    private String formatDoubleHeader(String text, String underValue) {
        text = text.trim();
        StringBuffer formattedValue = new StringBuffer();
        formattedValue.append(this.getParalelChar(text, underValue));
        formattedValue.append(Env.NL);
        formattedValue.append(text);
        formattedValue.append(Env.NL);
        formattedValue.append(this.getParalelChar(text, underValue));
        return formattedValue.toString();
    }

    private String formatExternalLinkText(String text) {
        StringBuffer formattedValue = new StringBuffer();
        formattedValue.append("`").append(text.trim()).append("`_");
        return formattedValue.toString();
    }

    private String formatExternalLink(String text, String link2) {
        StringBuffer formattedValue = new StringBuffer(Env.NL);
        formattedValue.append(".. _").append(text.trim()).append(": ").append(link2);
        return formattedValue.toString();
    }

    private String formatSection(String text) {
        return this.formatDoubleHeader(text, "=");
    }

    private String formatSubSection(String text) {
        return this.formatHeader(text, "=");
    }

    private String formatSubSubSection(String text) {
        return this.formatHeader(text, "-");
    }

    private String formatParagraphs(String text) {
        return this.formatHeader(text, "\"");
    }

    private String formatPart(String text) {
        return this.formatHeader(text, "#");
    }

    private String formatChapter(String text) {
        return this.formatHeader(text, "*");
    }

    private String getParalelChar(String text, String underValue) {
        return String.format("%1$" + text.length() + "s", "").replace(" ", underValue);
    }

    private String formatNote(String text) {
        StringBuffer formattedValue = new StringBuffer(Env.NL);
        formattedValue.append(".. note::").append(Env.NL).append("    ").append(text.trim()).append(Env.NL);
        return formattedValue.toString();
    }

    private String formatSeeAlso(String internalLink) {
        StringBuffer formattedValue = new StringBuffer(Env.NL);
        formattedValue.append(".. seealso::").append(Env.NL).append("    :ref:`").append(internalLink).append("`").append(Env.NL);
        return formattedValue.toString();
    }

    private String formatHeaderIndexName(String indexName) {
        StringBuffer formattedValue = new StringBuffer(Env.NL);
        formattedValue.append(".. _").append(indexName).append(":").append(Env.NL);
        return formattedValue.toString();
    }

    private String formatComment(String comment2) {
        StringBuffer formattedValue = new StringBuffer(Env.NL);
        formattedValue.append(".. ").append(comment2.replaceAll("\\n", "\n..")).append(Env.NL);
        return formattedValue.toString();
    }

    @Override
    public AbstractTextConverter newLine() {
        this.addText(Env.NL);
        return this;
    }

    public String toString() {
        if (this.urlSource.length() > 0) {
            this.formattedText.append(Env.NL);
            this.formattedText.append(this.urlSource);
            this.urlSource = new StringBuffer();
        }
        this.log.fine("toString=" + this.formattedText.toString());
        return this.formattedText.toString();
    }

    public static void main(String[] args) {
        ReStructuredTextConverter formatter = new ReStructuredTextConverter();
        formatter.addSection("Section");
        formatter.addSubSection("SubSection");
        formatter.addSubSubSection("SubSubSection");
        formatter.addChapter("Chapter");
        formatter.addPart("Part");
        formatter.addBold("Hi everybody");
        formatter.newLine();
        formatter.newLine();
        formatter.addBold("Hi");
        formatter.addItalic("Hello");
        formatter.addText("Hi all");
        formatter.addQuote("Items");
        formatter.addQuote("Item 1", 1);
        formatter.addQuote("Item 2", 1);
        formatter.addQuote("Item 2.1", 2);
        formatter.addQuote("Item 2.2", 2);
        formatter.addQuote("Item 2.3", 2);
        formatter.addQuote("Item 3", 1);
        formatter.addQuoteNumeric("Other");
        formatter.addQuoteNumeric("Description 1", 1);
        formatter.addQuoteNumeric("Description 2", 2);
        formatter.addQuoteNumeric("Description 2.1", 3);
        formatter.addQuoteNumeric("Description 2.2", 3);
        formatter.addQuoteNumeric("Description 2.3", 3);
        formatter.addQuoteNumeric("Description 3", 2);
        formatter.addText("This is a collection of key documentation gathered from the ADempiere wiki and the collective experience of the ADempiere Development Community. The aim of this collection is to provide a searchable and usable source of project documentation that will improve on the data contained in the wiki while enhancing the readers experience. ");
        formatter.addExternalLink("ADempiere Test", "http://demo.erpya.com:8888");
        formatter.addText(" si no le interesa revise tambien ");
        formatter.addExternalLink("ADempiere Test 1 ", "http://demo.erpya.com:8888/webui/");
        formatter.addCode("String a = \"Epale\";");
        TableTextConverter table2 = new TableTextConverter();
        ArrayList<String> row = new ArrayList<String>();
        row.add("Value");
        row.add("Name");
        row.add("Description");
        table2.addRow(row);
        row = new ArrayList();
        row.add("Test");
        row.add("Test Process");
        row.add("A Test Process");
        table2.addRow(row);
        row = new ArrayList();
        row.add("Production");
        row.add("Production Process");
        row.add("A Production Process");
        table2.addRow(row);
        row = new ArrayList();
        row.add("Report");
        row.add("Test Report");
        row.add("A Test Report");
        table2.addRow(row);
        formatter.addTable(table2);
        System.out.println(formatter.toString());
    }

    @Override
    public void clear() {
        this.formattedText = new StringBuffer();
        this.urlSource = new StringBuffer();
        this.previouslevel = -1;
    }

    @Override
    public String getExtension() {
        return "rst";
    }

    @Override
    public String getIndexFileName() {
        return "index.rst";
    }

    @Override
    public AbstractTextConverter addText(String text, int margin) {
        if (Util.isEmpty(text)) {
            return this;
        }
        String leftSpace = "";
        if (margin > 0) {
            leftSpace = String.format("%1$" + margin + "s", "");
        }
        this.addText(leftSpace + text);
        return this;
    }

    @Override
    public void addTreeDefinition(int maxdepth, boolean isnumbered) {
        this.formattedText.append(".. toctree::");
        this.newLine();
        this.addText(":maxdepth: " + maxdepth, 4);
        this.newLine();
        if (isnumbered) {
            this.addText(":numbered:", 4);
        }
        this.newLine();
    }

    @Override
    public AbstractTextConverter addTranslationText(String text) {
        this.translatedText.append(text);
        return this;
    }

    @Override
    public AbstractTextConverter addStrikethrough(String text) {
        return this.addText(text);
    }

    @Override
    public void addIndex(String title2, String name, String folder, int margin) {
        this.addText(name, margin);
    }

    @Override
    public void addGroup(String title2, String name, int margin) {
    }
}

