/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.docs;

import java.io.File;
import java.util.ArrayList;
import org.compiere.model.MField;
import org.compiere.model.MRefList;
import org.compiere.model.MTab;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.util.docs.AbstractDocumentationSource;
import org.spin.util.docs.AbstractTextConverter;
import org.spin.util.docs.IIndex;
import org.spin.util.docs.TableTextConverter;

public class FunctionalDocsForWindow
extends AbstractDocumentationSource {
    private MWindow window;
    public static final String SUB_FOLDER_NAME = "window";
    public static final String FOLDER_NAME = "functional-guide" + File.separator + "window";

    @Override
    public boolean createDocumentation(AbstractTextConverter textConverter, PO source) {
        this.window = (MWindow)source;
        textConverter.addHeaderIndexName((this.getFolderName() + "/" + this.getDocumentName()).toLowerCase());
        textConverter.addSection(this.window.getName());
        textConverter.newLine();
        if (!Util.isEmpty(this.window.getDescription())) {
            textConverter.addText(this.window.getDescription());
            textConverter.newLine();
        }
        if (!Util.isEmpty(this.window.getHelp())) {
            textConverter.addSubSection("Help");
            textConverter.addText(this.window.getHelp());
            textConverter.newLine();
        }
        if (this.window.isBetaFunctionality()) {
            textConverter.addNote(this.getFeature("IsBetaFunctionality"));
        }
        textConverter.addSubSubSection("Window Type");
        textConverter.addBold(MRefList.getListName(source.getCtx(), 108, this.window.getWindowType()));
        textConverter.newLine();
        if (this.window.isSOTrx()) {
            textConverter.addNote(this.getFeature("IsSOTrx"));
        }
        textConverter.newLine();
        MTab[] tabs = this.window.getTabs(false, source.get_TrxName());
        if (tabs != null && tabs.length > 0) {
            textConverter.addSubSection("Tabs");
            for (MTab tab : tabs) {
                MField[] fields;
                TableTextConverter table2 = new TableTextConverter();
                ArrayList<String> row = new ArrayList<String>();
                row.add("Attribute");
                row.add("Value");
                row.add("Description");
                table2.addRow(row);
                textConverter.addSubSubSection(tab.getName());
                if (!Util.isEmpty(tab.getDescription())) {
                    textConverter.addBold("Description");
                    textConverter.newLine();
                    textConverter.addText(" ");
                    textConverter.addItalic(tab.getDescription());
                    textConverter.newLine();
                }
                if (!Util.isEmpty(tab.getHelp())) {
                    textConverter.addBold("Help");
                    textConverter.newLine();
                    textConverter.addText(" ");
                    textConverter.addItalic(tab.getHelp());
                    textConverter.newLine();
                }
                StringBuffer note = new StringBuffer();
                if (tab.isSingleRow()) {
                    note.append(this.getFeature("IsSingleRow"));
                }
                if (tab.isAdvancedTab()) {
                    if (note.length() > 0) {
                        note.append(Env.NL);
                    }
                    note.append(this.getFeature("IsAdvancedTab"));
                }
                if (tab.isHasTree()) {
                    if (note.length() > 0) {
                        note.append(Env.NL);
                    }
                    note.append(this.getFeature("IsHasTree"));
                }
                if (tab.isInfoTab()) {
                    if (note.length() > 0) {
                        note.append(Env.NL);
                    }
                    note.append(this.getFeature("IsInfoTab"));
                }
                if (tab.isSortTab()) {
                    if (note.length() > 0) {
                        note.append(Env.NL);
                    }
                    note.append(this.getFeature("IsSortTab"));
                }
                if (tab.isTranslationTab()) {
                    if (note.length() > 0) {
                        note.append(Env.NL);
                    }
                    note.append(this.getFeature("IsTranslationTab"));
                }
                if (tab.isReadOnly()) {
                    if (note.length() > 0) {
                        note.append(Env.NL);
                    }
                    note.append(this.getFeature("IsReadOnly"));
                }
                if (tab.isInsertRecord()) {
                    if (note.length() > 0) {
                        note.append(Env.NL);
                    }
                    note.append(this.getFeature("IsInsertRecord"));
                }
                if (note.length() > 0) {
                    textConverter.addNote(note.toString());
                }
                if ((fields = tab.getFields(false, source.get_TrxName())) == null || fields.length <= 0) continue;
                textConverter.addSubSection("Fields");
                for (MField field : fields) {
                    if (!field.isDisplayed()) continue;
                    textConverter.addSubSubSection(field.getName());
                    if (!Util.isEmpty(field.getDescription())) {
                        textConverter.addBold("Description");
                        textConverter.newLine();
                        textConverter.addText(" ");
                        textConverter.addItalic(field.getDescription());
                        textConverter.newLine();
                    }
                    if (!Util.isEmpty(field.getHelp())) {
                        textConverter.addBold("Help");
                        textConverter.newLine();
                        textConverter.addText(" ");
                        textConverter.addItalic(field.getHelp());
                        textConverter.newLine();
                    }
                    note = new StringBuffer();
                    if (field.isDisplayedGrid()) {
                        note.append(this.getFeature("IsDisplayedGrid"));
                    }
                    if (field.isReadOnly()) {
                        if (note.length() > 0) {
                            note.append(Env.NL);
                        }
                        note.append(this.getFeature("IsReadOnly"));
                    }
                    if (field.isAllowCopy()) {
                        if (note.length() > 0) {
                            note.append(Env.NL);
                        }
                        note.append(this.getFeature("IsAllowCopy"));
                    }
                    if (!field.isEncrypted()) continue;
                    if (note.length() > 0) {
                        note.append(Env.NL);
                    }
                    note.append(this.getFeature("IsEncrypted"));
                }
            }
        }
        return true;
    }

    @Override
    public boolean addIndex(AbstractTextConverter indexConverter, PO source) {
        this.window = (MWindow)source;
        ((IIndex)((Object)indexConverter)).addIndex(this.window.getName(), this.getDocumentName().toLowerCase(), this.getFolderName(), 0);
        return true;
    }

    @Override
    public boolean createDocumentation(AbstractTextConverter textConverter) {
        return false;
    }

    @Override
    public String getFolderName() {
        return FOLDER_NAME;
    }

    @Override
    public String getDocumentName() {
        if (this.window != null) {
            return this.getValidValue("window-" + this.window.getName());
        }
        return "";
    }
}

