/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MPackage;
import org.compiere.model.MPackageLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MStore;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_W_Basket;
import org.compiere.model.X_W_BasketLine;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class VueStoreFrontUtil {
    public static final String COLUMNNAME_CacheServerProvider_ID = "CacheServerProvider_ID";
    public static final String COLUMNNAME_CustomerRole_ID = "CustomerRole_ID";
    public static final String COLUMNNAME_C_TemplateBPartner_ID = "C_TemplateBPartner_ID";
    public static final String COLUMNNAME_C_Tax_ID = "C_Tax_ID";
    public static final String COLUMNNAME_DeliveryViaRule = "DeliveryViaRule";
    public static final String COLUMNNAME_FreightCostRule = "FreightCostRule";
    public static final String COLUMNNAME_LineDiscount = "LineDiscount";
    public static final String COLUMNNAME_LineDiscountAmt = "LineDiscountAmt";
    public static final String COLUMNNAME_LineListAmt = "LineListAmt";
    public static final String COLUMNNAME_LineNetAmt = "LineNetAmt";
    public static final String COLUMNNAME_LineTotalAmt = "LineTotalAmt";
    public static final String COLUMNNAME_M_FreightCategory_ID = "M_FreightCategory_ID";
    public static final String COLUMNNAME_M_Shipper_ID = "M_Shipper_ID";
    public static final String COLUMNNAME_M_Warehouse_ID = "M_Warehouse_ID";
    public static final String COLUMNNAME_PriceList = "PriceList";
    public static final String COLUMNNAME_TaxAmt = "TaxAmt";
    public static final String COLUMNNAME_LastName = "LastName";
    public static final String COLUMNNAME_IsDefaultShipping = "IsDefaultShipping";
    public static final String COLUMNNAME_IsDefaultBilling = "IsDefaultBilling";

    public static MStore getDefaultStore(int organizationId) {
        List<MStore> stores = Arrays.asList(MStore.getOfClient(MClient.get(Env.getCtx())));
        AtomicInteger organizationForSearchId = new AtomicInteger(organizationId);
        if (organizationId == 0) {
            organizationForSearchId.set(Env.getAD_Org_ID(Env.getCtx()));
        }
        AtomicReference storeReceived = new AtomicReference();
        stores.stream().filter(store -> store.getAD_Org_ID() == organizationForSearchId.get()).findFirst().ifPresent(store -> storeReceived.set(store));
        if (storeReceived.get() == null) {
            stores.stream().findFirst().ifPresent(store -> storeReceived.set(store));
        }
        return (MStore)storeReceived.get();
    }

    public static BigDecimal getPriceStd(MProduct product, int priceListId) {
        MProductPricing productPricing = VueStoreFrontUtil.getProductPricing(product, priceListId);
        if (productPricing == null) {
            return Env.ZERO;
        }
        return productPricing.getPriceStd().setScale(productPricing.getPrecision());
    }

    public static BigDecimal getPriceList(MProduct product, int priceListId) {
        MProductPricing productPricing = VueStoreFrontUtil.getProductPricing(product, priceListId);
        if (productPricing == null) {
            return Env.ZERO;
        }
        return productPricing.getPriceList().setScale(productPricing.getPrecision());
    }

    public static MProductPricing getProductPricing(MProduct product, int priceListId) {
        MPriceList priceList = MPriceList.get(product.getCtx(), priceListId, product.get_TrxName());
        Timestamp validFrom = TimeUtil.getDay(System.currentTimeMillis());
        MProductPricing productPricing = new MProductPricing(product.getM_Product_ID(), 0, Env.ZERO, true, product.get_TrxName());
        productPricing.setM_PriceList_ID(priceList.getM_PriceList_ID());
        productPricing.setPriceDate(validFrom);
        return productPricing;
    }

    public static MTax getTax(int taxCategoryId) {
        Optional<MTax> optionalTax = Arrays.asList(MTax.getAll(Env.getCtx())).stream().filter(tax -> tax.getC_TaxCategory_ID() == taxCategoryId && (tax.isSalesTax() || !Util.isEmpty(tax.getSOPOType()) && (tax.getSOPOType().equals("B") || tax.getSOPOType().equals("S")))).findFirst();
        if (optionalTax.isPresent()) {
            return optionalTax.get();
        }
        return null;
    }

    public static BigDecimal getTaxRate(int taxCategoryId) {
        MTax tax = VueStoreFrontUtil.getTax(taxCategoryId);
        BigDecimal taxRate = Env.ZERO;
        if (tax == null) {
            return taxRate;
        }
        return tax.getRate();
    }

    public static void setBasketLineDefaultValues(X_W_BasketLine basketLine) {
        if (basketLine == null) {
            return;
        }
        MStore store = VueStoreFrontUtil.getDefaultStore(basketLine.getAD_Org_ID());
        MProduct product = MProduct.get(basketLine.getCtx(), basketLine.getM_Product_ID());
        MTax tax = VueStoreFrontUtil.getTax(product.getC_TaxCategory_ID());
        BigDecimal quantity = basketLine.getQty();
        MProductPricing productPricing = VueStoreFrontUtil.getProductPricing(product, store.getM_PriceList_ID());
        BigDecimal priceListAmount = productPricing.getPriceList().setScale(productPricing.getPrecision());
        BigDecimal priceAmount = productPricing.getPriceStd().setScale(productPricing.getPrecision());
        BigDecimal discount = productPricing.getDiscount();
        BigDecimal lineListAmount = priceListAmount.multiply(quantity).setScale(productPricing.getPrecision(), 4);
        BigDecimal lineDiscountAmount = lineListAmount.multiply(discount).divide(Env.ONEHUNDRED, 4).setScale(productPricing.getPrecision(), 4);
        BigDecimal lineNetAmount = priceAmount.multiply(quantity).setScale(productPricing.getPrecision(), 4);
        BigDecimal taxAmount = lineNetAmount.multiply(tax.getRate()).divide(Env.ONEHUNDRED, 4);
        BigDecimal lineTotalAmount = lineNetAmount.add(taxAmount);
        basketLine.set_ValueOfColumn(COLUMNNAME_M_Warehouse_ID, (Object)store.getM_Warehouse_ID());
        basketLine.set_ValueOfColumn(COLUMNNAME_PriceList, (Object)priceListAmount);
        basketLine.set_ValueOfColumn(COLUMNNAME_LineDiscount, (Object)discount);
        basketLine.set_ValueOfColumn(COLUMNNAME_LineDiscountAmt, (Object)lineDiscountAmount);
        basketLine.set_ValueOfColumn(COLUMNNAME_LineListAmt, (Object)lineListAmount);
        basketLine.set_ValueOfColumn(COLUMNNAME_LineNetAmt, (Object)lineNetAmount);
        basketLine.set_ValueOfColumn(COLUMNNAME_TaxAmt, (Object)taxAmount);
        basketLine.set_ValueOfColumn(COLUMNNAME_LineTotalAmt, (Object)lineTotalAmount);
        basketLine.set_ValueOfColumn(COLUMNNAME_C_Tax_ID, (Object)tax.getC_Tax_ID());
    }

    public static List<MPackage> getPackagesFromBasket(Properties context, int basketId, String transactionName) {
        return new Query(context, "M_Package", "W_Basket_ID = ?", transactionName).setParameters(basketId).list();
    }

    public static void deletePackageLineFromBasketLine(Properties context, int basketLineId, String transactionName) {
        List<MPackageLine> packageLines = new Query(Env.getCtx(), "M_PackageLine", "W_BasketLine_ID = ?", transactionName).setParameters(basketLineId).list();
        packageLines.forEach(packageLine -> packageLine.deleteEx(true));
    }

    public static void deletePackageFromBasket(Properties context, int basketId, String transactionName) {
        List<MPackage> packages = new Query(Env.getCtx(), "M_Package", "W_Basket_ID = ?", transactionName).setParameters(basketId).list();
        packages.forEach(packageToDelete -> packageToDelete.deleteEx(true));
    }

    public static List<MPackage> createPackagesFromBasket(Properties context, int basketId, String transactionName) {
        X_W_Basket basket = new X_W_Basket(context, basketId, transactionName);
        List<MPackage> packages = VueStoreFrontUtil.getPackagesFromBasket(context, basketId, transactionName);
        if (basket.getC_BPartner_ID() <= 0) {
            return packages;
        }
        MBPartner customer = MBPartner.get(context, basket.getC_BPartner_ID());
        List<MBPartnerLocation> locations = Arrays.asList(customer.getLocations(true));
        Optional maybeLocation = Optional.of(locations.stream().filter(location -> location.isShipTo()).findFirst()).orElse(locations.stream().findFirst());
        if (packages == null) {
            packages = new ArrayList<MPackage>();
        }
        if (basket.getC_BPartner_ID() <= 0 || !maybeLocation.isPresent()) {
            return packages;
        }
        MStore store = VueStoreFrontUtil.getDefaultStore(basket.getAD_Org_ID());
        if (store == null) {
            throw new AdempiereException("@W_Store_ID@ @NotFound@");
        }
        HashMap groupingPackages = new HashMap();
        packages.forEach(packageToGrouping -> {
            String key = packageToGrouping.getM_Warehouse_ID() + "|" + packageToGrouping.getDeliveryViaRule() + "|" + packageToGrouping.getFreightCostRule() + "|" + packageToGrouping.getM_FreightCategory_ID() + "|" + packageToGrouping.getM_Shipper_ID();
            groupingPackages.put(key, packageToGrouping);
        });
        List<X_W_BasketLine> basketLines = new Query(Env.getCtx(), "W_BasketLine", "W_Basket_ID = ? AND M_Shipper_ID IS NOT NULL", transactionName).setParameters(basketId).list();
        basketLines.forEach(basketLine -> {
            String key = basketLine.get_ValueAsInt(COLUMNNAME_M_Warehouse_ID) + "|" + basketLine.get_ValueAsString(COLUMNNAME_DeliveryViaRule) + "|" + basketLine.get_ValueAsString(COLUMNNAME_FreightCostRule) + "|" + basketLine.get_ValueAsInt(COLUMNNAME_M_FreightCategory_ID) + "|" + basketLine.get_ValueAsInt(COLUMNNAME_M_Shipper_ID);
            MPackage packageToCreate = (MPackage)groupingPackages.get(key);
            if (packageToCreate == null) {
                packageToCreate = new MPackage(context, 0, transactionName);
            }
            if (basketLine.getAD_Org_ID() > 0) {
                packageToCreate.setAD_Org_ID(basketLine.getAD_Org_ID());
            } else {
                packageToCreate.setAD_Org_ID(store.getAD_Org_ID());
            }
            packageToCreate.setM_Warehouse_ID(basketLine.get_ValueAsInt(COLUMNNAME_M_Warehouse_ID));
            packageToCreate.setDateDoc(new Timestamp(System.currentTimeMillis()));
            if (basketLine.get_ValueAsInt(COLUMNNAME_M_Shipper_ID) > 0) {
                packageToCreate.setM_Shipper_ID(basketLine.get_ValueAsInt(COLUMNNAME_M_Shipper_ID));
            }
            packageToCreate.setC_BPartner_ID(basket.getC_BPartner_ID());
            packageToCreate.setC_BPartner_Location_ID(((MBPartnerLocation)maybeLocation.get()).getC_BPartner_Location_ID());
            packageToCreate.setDeliveryViaRule(basketLine.get_ValueAsString(COLUMNNAME_DeliveryViaRule));
            if (!Util.isEmpty(basketLine.get_ValueAsString(COLUMNNAME_FreightCostRule))) {
                packageToCreate.setFreightCostRule(basketLine.get_ValueAsString(COLUMNNAME_FreightCostRule));
            }
            if (basketLine.get_ValueAsInt(COLUMNNAME_M_FreightCategory_ID) > 0) {
                packageToCreate.setM_FreightCategory_ID(basketLine.get_ValueAsInt(COLUMNNAME_M_FreightCategory_ID));
            }
            packageToCreate.set_ValueOfColumn("W_Basket_ID", (Object)basket.getW_Basket_ID());
            Optional<Integer> maybeDocumentType = Optional.of(MDocType.getDocType("MMK", packageToCreate.getAD_Org_ID()));
            if (maybeDocumentType.isPresent()) {
                packageToCreate.setC_DocType_ID(maybeDocumentType.get());
            }
            packageToCreate.setSalesRep_ID(store.getSalesRep_ID());
            packageToCreate.saveEx(transactionName);
            List<MPackageLine> packageLines = packageToCreate.getLines(true);
            Optional<MPackageLine> maybePackage = packageLines.stream().filter(lineOfPackage -> lineOfPackage.get_ValueAsInt("W_BasketLine_ID") == basketLine.getW_BasketLine_ID()).findFirst();
            MPackageLine lineToCreate = maybePackage.orElse(new MPackageLine(packageToCreate));
            MProduct product = MProduct.get(context, basketLine.getM_Product_ID());
            lineToCreate.set_ValueOfColumn("W_BasketLine_ID", (Object)basketLine.getW_BasketLine_ID());
            lineToCreate.setQty(basketLine.getQty());
            lineToCreate.setWeight(Optional.ofNullable(product.getWeight()).orElse(Env.ZERO).multiply(basketLine.getQty()));
            lineToCreate.setVolume(Optional.ofNullable(product.getVolume()).orElse(Env.ZERO).multiply(basketLine.getQty()));
            lineToCreate.setDescription(Msg.parseTranslation(context, "@Created@ @from@ @W_Basket_ID@: (" + basketLine.getW_Basket_ID() + ") - " + basketLine.getLine() + ": " + basketLine.getProduct()));
            lineToCreate.saveEx(transactionName);
            groupingPackages.put(key, packageToCreate);
        });
        return packages;
    }

    public static MBPartner getTemplate(Properties context, int templateId, String transactionaName) {
        MBPartner source = MBPartner.get(context, templateId);
        if (source == null) {
            source = new MBPartner(context, 0, null);
        }
        MBPartner target = new MBPartner(context, 0, transactionaName);
        PO.copyValues(source, target);
        target.setTaxID("");
        target.setValue("");
        target.setName("");
        target.setName2(null);
        target.setDUNS("");
        target.setFirstSale(null);
        target.setSO_CreditLimit(Env.ZERO);
        target.setSO_CreditUsed(Env.ZERO);
        target.setTotalOpenBalance(Env.ZERO);
        target.setActualLifeTimeValue(Env.ZERO);
        target.setPotentialLifeTimeValue(Env.ZERO);
        target.setAcqusitionCost(Env.ZERO);
        target.setShareOfCustomer(0);
        target.setSalesVolume(0);
        return target;
    }
}

