/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.util.Optional;
import org.compiere.model.MEntityType;
import org.compiere.model.MRule;

public class RuleEngineUtil {
    public static String getClassName(MRule rule) {
        if (rule == null || rule.getAD_Rule_ID() <= 0) {
            return null;
        }
        return rule.getValue().replaceAll("[^A-Za-z0-9]", "_");
    }

    public static String getPackageName(MRule rule) {
        if (rule == null || rule.getAD_Rule_ID() <= 0) {
            return null;
        }
        MEntityType entityType = MEntityType.get(rule.getCtx(), rule.getEntityType());
        String packageName = Optional.ofNullable(entityType.getModelPackage()).orElse("org.spin.model");
        int index = packageName.lastIndexOf(".");
        packageName = packageName.substring(0, index);
        return packageName + ".engine";
    }

    public static String getCompleteClassName(MRule rule) {
        String packageName = RuleEngineUtil.getPackageName(rule);
        if (packageName == null) {
            return null;
        }
        String className = RuleEngineUtil.getClassName(rule);
        if (className == null) {
            return null;
        }
        return packageName + "." + className;
    }
}

