/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMBatch;
import org.spin.model.MFMFunctionalSetting;
import org.spin.model.MFMTransaction;
import org.spin.model.MFMTransactionType;
import org.spin.util.AbstractFunctionalSetting;
import org.spin.util.AmortizationValue;
import org.spin.util.LoanUtil;

public class LoanInterestProcess
extends AbstractFunctionalSetting {
    public LoanInterestProcess(MFMFunctionalSetting mFMFunctionalSetting) {
        super(mFMFunctionalSetting);
    }

    @Override
    public String run() {
        MFMAgreement mFMAgreement = (MFMAgreement)this.getParameter("MFMAgreement");
        MFMBatch mFMBatch = (MFMBatch)this.getParameter("MFMBatch");
        String string = (String)this.getParameter("TRX_NAME");
        if (mFMAgreement == null || mFMBatch == null) {
            return null;
        }
        MFMTransactionType mFMTransactionType = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LIN");
        MFMTransactionType mFMTransactionType2 = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LIT");
        if (mFMTransactionType == null) {
            throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ LIN");
        }
        HashMap<String, Object> hashMap = LoanUtil.calculateLoanInterest(this.getCtx(), mFMAgreement.getFM_Agreement_ID(), new Timestamp(System.currentTimeMillis()), string);
        if (hashMap == null || hashMap.isEmpty()) {
            return null;
        }
        List list = (List)hashMap.get("AMORTIZATION_LIST");
        if (list == null) {
            return null;
        }
        for (AmortizationValue amortizationValue : list) {
            MFMTransaction mFMTransaction = mFMBatch.addTransaction(mFMTransactionType.getFM_TransactionType_ID(), amortizationValue.getInterestAmtFee());
            if (mFMTransaction != null) {
                mFMTransaction.set_ValueOfColumn("FM_Amortization_ID", (Object)amortizationValue.getAmortizationId());
                mFMTransaction.saveEx();
            }
            if (mFMTransactionType2 == null || amortizationValue.getTaxAmtFee() == null || (mFMTransaction = mFMBatch.addTransaction(mFMTransactionType2.getFM_TransactionType_ID(), amortizationValue.getTaxAmtFee())) == null) continue;
            mFMTransaction.set_ValueOfColumn("FM_Amortization_ID", (Object)amortizationValue.getAmortizationId());
            mFMTransaction.saveEx();
        }
        return null;
    }
}

