/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.compiere.model.MCurrency;
import org.compiere.util.Env;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMAmortization;
import org.spin.model.MFMFunctionalSetting;
import org.spin.model.MFMProduct;
import org.spin.util.AbstractFunctionalSetting;
import org.spin.util.AmortizationValue;
import org.spin.util.LoanUtil;

public class FrenchLoanAmortization
extends AbstractFunctionalSetting {
    public FrenchLoanAmortization(MFMFunctionalSetting mFMFunctionalSetting) {
        super(mFMFunctionalSetting);
    }

    @Override
    public String run() {
        MFMAgreement mFMAgreement = (MFMAgreement)this.getParameter("PO");
        return this.generateAmortization(mFMAgreement);
    }

    private String generateAmortization(MFMAgreement mFMAgreement) {
        String string = (String)this.getParameter("TRX_NAME");
        List list = new ArrayList();
        MFMProduct mFMProduct = MFMProduct.getById(this.getCtx(), mFMAgreement.getFM_Product_ID(), string);
        mFMAgreement.set_TrxName(string);
        List<MFMAccount> list2 = mFMAgreement.getAccounts();
        for (MFMAccount mFMAccount : list2) {
            mFMAccount.set_TrxName(string);
            if (MFMAmortization.checkAccount(mFMAccount)) continue;
            MFMAmortization.deleteForAccount(mFMAccount);
            MCurrency mCurrency = MCurrency.get(this.getCtx(), mFMAccount.getC_Currency_ID());
            BigDecimal bigDecimal = (BigDecimal)mFMAccount.get_Value("CapitalAmt");
            int n = Optional.ofNullable((BigDecimal)mFMAccount.get_Value("FeesQty")).orElse(Env.ZERO).intValue();
            Timestamp timestamp = (Timestamp)mFMAccount.get_Value("StartDate");
            Timestamp timestamp2 = (Timestamp)mFMAccount.get_Value("EndDate");
            Timestamp timestamp3 = (Timestamp)mFMAccount.get_Value("PayDate");
            String string2 = mFMAccount.get_ValueAsString("PaymentFrequency");
            list = (List)LoanUtil.calculateFrenchAmortization(mFMProduct.getFM_Product_ID(), bigDecimal, n, timestamp, timestamp2, timestamp3, string2, mFMAccount.getCtx(), string).get("AMORTIZATION_LIST");
            for (AmortizationValue amortizationValue : list) {
                MFMAmortization.createAmortization(mFMAccount.getCtx(), amortizationValue.getCapitalAmtFee().setScale(mCurrency.getStdPrecision(), 4), "", amortizationValue.getDueDate(), amortizationValue.getEndDate(), mFMAccount.getFM_Account_ID(), amortizationValue.getInterestAmtFee().setScale(mCurrency.getStdPrecision(), 4), amortizationValue.getPeriodNo(), amortizationValue.getStartDate(), amortizationValue.getTaxAmtFee().setScale(mCurrency.getStdPrecision(), 4), string);
            }
        }
        return null;
    }
}

