/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.awt.Font;
import java.io.BufferedWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.XhtmlDocument;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MTable;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.util.AbstractExportFormat;

public class ExportFormatHTML
extends AbstractExportFormat {
    private static CLogger log = CLogger.getCLogger(ExportFormatHTML.class);

    public ExportFormatHTML(Properties ctx, ReportEngine reportEngine) {
        this.setCtx(ctx);
        this.setReportEngine(reportEngine);
    }

    @Override
    public String getExtension() {
        return "html";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FileHTML");
    }

    @Override
    public boolean exportToFile(File file) {
        if (this.getReportEngine() == null || this.getCtx() == null) {
            return false;
        }
        return this.createHTML(file, false, null);
    }

    public boolean createHTML(File file, boolean onlyTable, IHTMLExtension extension) {
        BufferedWriter buffer = this.convertFile(file);
        if (buffer == null) {
            return false;
        }
        return this.createHTML(buffer, onlyTable, extension);
    }

    private boolean createHTML(Writer writer, boolean onlyTable, IHTMLExtension extension) {
        try {
            MPrintFormat printFormat = this.getPrintFormat();
            PrintData printData = this.getPrintData();
            ProcessInfo processInfo = this.getProcessInfo();
            String cssPrefix = extension != null ? extension.getClassPrefix() : null;
            ArrayList<Integer> hasAction = new ArrayList<Integer>();
            if (cssPrefix != null && cssPrefix.trim().length() == 0) {
                cssPrefix = null;
            }
            table table2 = new table();
            PrintWriter printWriter = new PrintWriter(writer);
            if (printFormat.getAD_PrintFont_ID() != 0) {
                MPrintFont font = (MPrintFont)printFormat.getAD_PrintFont();
                Font ff = font.getFont();
                String generic = ff.getName();
                if (generic.equalsIgnoreCase("sansserif")) {
                    generic = "sans-serif";
                }
                if (generic.equalsIgnoreCase("monospaced")) {
                    generic = "monospace";
                }
                if (generic.equalsIgnoreCase("dialog")) {
                    generic = "cursive";
                }
                if (generic.equalsIgnoreCase("dialoginput")) {
                    generic = "fantasy";
                }
                table2.setStyle("font-family:" + generic);
            }
            if (cssPrefix != null) {
                table2.setClass(cssPrefix + "-table");
            }
            if (!onlyTable) {
                XhtmlDocument doc = new XhtmlDocument();
                doc.appendBody((Element)table2);
                if (extension != null && extension.getStyleURL() != null) {
                    link l = new link(extension.getStyleURL(), "stylesheet", "text/css");
                    doc.appendHead((Element)l);
                }
                if (extension != null && extension.getScriptURL() != null) {
                    script jslink = new script();
                    jslink.setLanguage("javascript");
                    jslink.setSrc(extension.getScriptURL());
                    doc.appendHead((Element)jslink);
                }
                printWriter.write(doc.toString().replaceAll("</table>", "").replaceAll("</body>", "").replaceAll("</html>", ""));
            } else {
                printWriter.write(table2.toString().replaceAll("</table>", ""));
            }
            for (int row = -1; row < printData.getRowCount(); ++row) {
                tr tr2 = new tr();
                String cssclass = "";
                if (cssPrefix != null && row % 2 == 0) {
                    cssclass = cssPrefix + "-odd";
                }
                if (row != -1) {
                    printData.setRowIndex(row);
                    if (extension != null) {
                        extension.extendRowElement((ConcreteElement)tr2, printData);
                    }
                    if (printData.isFunctionRow()) {
                        cssclass = cssclass + " " + cssPrefix + "-functionrow";
                    } else if (row < printData.getRowCount() && printData.isFunctionRow(row + 1)) {
                        cssclass = cssclass + " " + cssPrefix + "-lastgrouprow";
                    }
                }
                tr2.setClass(cssclass);
                for (int col = 0; col < printFormat.getItemCount(); ++col) {
                    MPrintFormatItem item = printFormat.getItem(col);
                    if (!item.isPrinted()) continue;
                    if (row == -1) {
                        th th2 = new th();
                        tr2.addElement((Element)th2);
                        th2.addElement(Util.maskHTML(item.getPrintName(Env.getLanguage(this.getCtx()))));
                        if (item.getExecuteProcess() == null) continue;
                        hasAction.add(item.getAD_PrintFormatItem_ID());
                        continue;
                    }
                    td td2 = new td();
                    tr2.addElement((Element)td2);
                    String style = "";
                    if (item.isFixedWidth() && item.getMaxWidth() > 0) {
                        int pxs = item.getMaxWidth() * 96;
                        style = "min-width:" + (pxs /= 72) + ";max-width:" + pxs + "; overflow: hidden";
                    }
                    if (item.isHeightOneLine()) {
                        if (style.length() > 0) {
                            style = style + ";";
                        }
                        style = style + "white-space: nowrap;";
                    }
                    td2.setStyle(style);
                    Object obj = printData.getNodeFromPrintFormatItem(item.getAD_PrintFormatItem_ID());
                    if (!item.isDisplayed(printData)) {
                        obj = null;
                    }
                    if (obj == null) {
                        td2.addElement("&nbsp;");
                        continue;
                    }
                    if (obj instanceof PrintDataElement) {
                        PrintDataElement pde = (PrintDataElement)obj;
                        String value = pde.getValueDisplay(Env.getLanguage(this.getCtx()));
                        if (pde.getColumnName().endsWith("_ID") && extension != null) {
                            a href = new a("javascript:void(0)");
                            href.setID(pde.getColumnName() + "_" + row + "_a");
                            td2.addElement((Element)href);
                            if (item.getColumnName().equals("Record_ID")) {
                                img image = new img("/webui/images/dark/Find16.png");
                                image.setAlign("middle");
                                href.addElement((Element)image);
                                td2.setStyle("text-align:center");
                            } else {
                                href.addElement(Util.maskHTML(value));
                            }
                            if (cssPrefix != null) {
                                href.setClass(cssPrefix + "-href");
                            }
                            if (item.getColumnName().equals("Record_ID") || item.getColumnName().equals("Line_ID")) {
                                String columnName = item.getColumnName();
                                String columnValue = pde.getValueAsString();
                                boolean isZoom = false;
                                Object objPDE = printData.getNode("AD_Table_ID");
                                if (objPDE != null) {
                                    MTable mTable = null;
                                    int AD_Table_ID = 0;
                                    if (objPDE instanceof PrintDataElement) {
                                        PrintDataElement pdElement = (PrintDataElement)objPDE;
                                        AD_Table_ID = Integer.parseInt(pdElement.getValueAsString());
                                    } else {
                                        AD_Table_ID = Integer.parseInt(objPDE.toString());
                                    }
                                    mTable = MTable.get(this.getCtx(), AD_Table_ID);
                                    if (item.getColumnName().equals("Record_ID")) {
                                        columnName = mTable.getTableName().trim() + "_ID";
                                    } else {
                                        String sql = "SELECT DISTINCT(columnname) FROM ad_column where columnname ilike '" + mTable.getTableName().trim() + "%Line_ID'";
                                        columnName = DB.getSQLValueString(null, sql, new Object[0]);
                                    }
                                    isZoom = true;
                                } else {
                                    objPDE = printData.getNode("Fact_Acct_ID");
                                    if (objPDE != null && objPDE instanceof PrintDataElement) {
                                        PrintDataElement pdElement = (PrintDataElement)objPDE;
                                        columnValue = pdElement.getValueAsString();
                                        isZoom = true;
                                    }
                                }
                                if (isZoom) {
                                    href.addAttribute("onclick", "parent.zoom('" + extension.getComponentId() + "', '" + columnName + "', '" + columnValue + "')");
                                }
                            } else if (hasAction.contains(item.getAD_PrintFormatItem_ID())) {
                                extension.extendIDColumn(row, (ConcreteElement)td2, href, pde, item, processInfo.getAD_PInstance_ID());
                            } else {
                                extension.extendIDColumn(row, (ConcreteElement)td2, href, pde, null, 0);
                            }
                        } else {
                            td2.addElement(Util.maskHTML(value));
                        }
                        if (cssPrefix == null) continue;
                        if (DisplayType.isNumeric(pde.getDisplayType())) {
                            td2.setClass(cssPrefix + "-number");
                            continue;
                        }
                        if (DisplayType.isDate(pde.getDisplayType())) {
                            td2.setClass(cssPrefix + "-date");
                            continue;
                        }
                        td2.setClass(cssPrefix + "-text");
                        continue;
                    }
                    if (obj instanceof PrintData || obj instanceof String) continue;
                    log.log(Level.SEVERE, "Element not PrintData(Element) " + obj.getClass());
                }
                tr2.output(printWriter);
            }
            printWriter.write(10);
            printWriter.write("\t\t</table>");
            printWriter.write(10);
            if (!onlyTable) {
                printWriter.write("\t</body>");
                printWriter.write(10);
                printWriter.write("</html>");
                printWriter.write(10);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
        }
        return false;
    }
}

