/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.model.GridTab;
import org.compiere.model.MMessage;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.model.MADContextInfo;

public class ContextInfo {
    protected static CLogger log = CLogger.getCLogger(ContextInfo.class);

    public static String getInfoForWindow(GridTab gridTab) {
        MADContextInfo contextInfo = MADContextInfo.getFromTabId(Env.getCtx(), gridTab.getAD_Tab_ID());
        if (contextInfo == null) {
            contextInfo = MADContextInfo.getFromWindowId(Env.getCtx(), gridTab.getAD_Window_ID());
        }
        if (contextInfo == null) {
            contextInfo = MADContextInfo.getFromTableId(Env.getCtx(), gridTab.getAD_Table_ID());
        }
        return ContextInfo.getContextInfoMessage(contextInfo, gridTab.getWindowNo());
    }

    public static Map<String, String> getInfoForFiels(GridTab gridTab) {
        Map<String, MADContextInfo> contextInfoHash = MADContextInfo.getFromTabIdForField(Env.getCtx(), gridTab.getAD_Tab_ID());
        HashMap<String, String> values = null;
        if (contextInfoHash != null && contextInfoHash.size() > 0) {
            values = new HashMap<String, String>();
            for (Map.Entry<String, MADContextInfo> entry : contextInfoHash.entrySet()) {
                values.put(entry.getKey(), ContextInfo.getContextInfoMessage(entry.getValue(), gridTab.getWindowNo()));
            }
        }
        return values;
    }

    private static String getContextInfoMessage(MADContextInfo contextInfo, int windowNo) {
        if (contextInfo == null) {
            return " ";
        }
        try {
            MMessage message = MMessage.get(Env.getCtx(), contextInfo.getAD_Message_ID());
            if (message != null) {
                Object[] arguments = contextInfo.getArguments(windowNo);
                if (arguments == null) {
                    return null;
                }
                return Msg.getMsg(Env.getAD_Language(Env.getCtx()), message.getValue(), arguments);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getLocalizedMessage());
        }
        return " ";
    }
}

