/*
 * Decompiled with CFR 0.152.
 */
package org.spin.setup;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ModelValidator;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.model.X_FM_AgreementType;
import org.spin.model.X_FM_FunctionalApplicability;
import org.spin.model.X_FM_FunctionalSetting;
import org.spin.model.X_FM_Product;
import org.spin.model.X_FM_ProductCategory;
import org.spin.model.X_FM_TransactionType;
import org.spin.util.ISetupDefinition;

public class SpinContributionTestSetup
implements ISetupDefinition {
    private static final String SETUP_DESCRIPTION = "(*Created from Setup Automatically*)";
    private final String FRENCH_LOAN_AMORTIZATION = "org.spin.util.FrenchLoanAmortization";
    private final String LOAN_MODEL_VALIDATOR = "org.spin.model.LoanManagementModelValidator";

    @Override
    public String doIt(Properties context, String transactionName) {
        this.createTransactionTypes(context, transactionName);
        this.createAgreementType(context, transactionName);
        X_FM_ProductCategory financialProductCategory = this.createFinancialProductCategory(context, "ILC", "Interest Loan Category", transactionName);
        this.createFinancialProduct(context, financialProductCategory.getFM_ProductCategory_ID(), "AP", "Amortization Product", transactionName);
        X_FM_FunctionalSetting functionalSetting = this.createFunctionalSetting(context, "FLA", "French Loan Amortization", "org.spin.util.FrenchLoanAmortization", transactionName);
        this.createApplicability(context, functionalSetting.getFM_FunctionalSetting_ID(), financialProductCategory.getFM_ProductCategory_ID(), "FM_Agreement", "T", "DAPR", transactionName);
        this.createDocumentType(context, "FMA", "Loan", transactionName);
        this.createModelValidator(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private X_AD_ModelValidator createModelValidator(Properties context, String transactionName) {
        X_AD_ModelValidator modelValidator = (X_AD_ModelValidator)new Query(context, "AD_ModelValidator", "ModelValidationClass = ?", transactionName).setParameters("org.spin.model.LoanManagementModelValidator").setClient_ID().first();
        if (modelValidator != null && modelValidator.getAD_ModelValidator_ID() > 0) {
            return modelValidator;
        }
        modelValidator = new X_AD_ModelValidator(context, 0, transactionName);
        modelValidator.setName("Loan Management Validator");
        modelValidator.setEntityType("FMS");
        modelValidator.setDescription(SETUP_DESCRIPTION);
        modelValidator.setSeqNo(200);
        modelValidator.setModelValidationClass("org.spin.model.LoanManagementModelValidator");
        modelValidator.saveEx();
        return modelValidator;
    }

    private MDocType createDocumentType(Properties context, String documentBaseType, String name, String transactionName) {
        MDocType documentType = (MDocType)new Query(context, "C_DocType", "Name = ?", transactionName).setParameters(name).setClient_ID().first();
        if (documentType != null && documentType.getC_DocType_ID() > 0) {
            return documentType;
        }
        documentType = new MDocType(Env.getCtx(), 0, transactionName);
        documentType.setName(name);
        documentType.setPrintName(name);
        documentType.setDocBaseType(documentBaseType);
        documentType.setGL_Category_ID();
        documentType.setIsSOTrx(true);
        documentType.setDescription(SETUP_DESCRIPTION);
        documentType.saveEx();
        return documentType;
    }

    private X_FM_Product createFinancialProduct(Properties context, int financialProductCategoryId, String value, String name, String transactionName) {
        X_FM_Product financialProduct = (X_FM_Product)new Query(context, "FM_Product", "Value = ?", transactionName).setParameters(value).setClient_ID().first();
        if (financialProduct != null && financialProduct.getFM_Product_ID() > 0) {
            return financialProduct;
        }
        financialProduct = new X_FM_Product(Env.getCtx(), 0, transactionName);
        financialProduct.setValue(value);
        financialProduct.setName(name);
        financialProduct.setFM_ProductCategory_ID(financialProductCategoryId);
        financialProduct.setC_Currency_ID(MCurrency.get(Env.getCtx(), "USD").getC_Currency_ID());
        MProduct product = this.createProduct(context, value, name, transactionName);
        financialProduct.setM_Product_ID(product.getM_Product_ID());
        MCharge charge = this.createCharge(context, name, transactionName);
        financialProduct.setC_Charge_ID(charge.getC_Charge_ID());
        financialProduct.setPaymentFrequency("F");
        financialProduct.setGraceDays(0);
        financialProduct.saveEx();
        return financialProduct;
    }

    private MProduct createProduct(Properties context, String value, String name, String transactionName) {
        MProduct product = (MProduct)new Query(context, "M_Product", "Value = ?", transactionName).setParameters(value).setClient_ID().first();
        if (product != null && product.getM_Product_ID() > 0) {
            return product;
        }
        product = new MProduct(Env.getCtx(), 0, transactionName);
        product.setValue(value);
        product.setName(name);
        product.setDescription(SETUP_DESCRIPTION);
        product.setM_Product_Category_ID(new Query(Env.getCtx(), "M_Product_Category", "Value = ?", transactionName).setParameters("Standard").setClient_ID().firstId());
        product.setC_TaxCategory_ID(new Query(Env.getCtx(), "C_TaxCategory", "Name = ?", transactionName).setParameters("Standard").setClient_ID().firstId());
        product.setC_UOM_ID(new Query(Env.getCtx(), "C_UOM", "X12DE355 = ?", transactionName).setParameters("Kg").setClient_ID().firstId());
        product.setProductType("S");
        product.saveEx();
        this.createPriceList(product.getM_Product_ID(), null, transactionName);
        return product;
    }

    private void createPriceList(int productId, BigDecimal optionalPrice, String transactionName) {
        new Query(Env.getCtx(), "M_PriceList_Version", null, transactionName).setOnlyActiveRecords(true).setClient_ID().list().forEach(priceListVersion -> {
            MProductPrice productPrice = new MProductPrice(Env.getCtx(), priceListVersion.getM_PriceList_Version_ID(), productId, transactionName);
            productPrice.setPriceList(Optional.ofNullable(optionalPrice).orElse(Env.ONEHUNDRED));
            productPrice.setPriceStd(Optional.ofNullable(optionalPrice).orElse(Env.ONEHUNDRED));
            productPrice.setPriceLimit(Optional.ofNullable(optionalPrice).orElse(Env.ONEHUNDRED));
            productPrice.saveEx();
        });
    }

    private MCharge createCharge(Properties context, String name, String transactionName) {
        MCharge charge = (MCharge)new Query(context, "C_Charge", "Name = ?", transactionName).setParameters(name).setClient_ID().first();
        if (charge != null && charge.getC_Charge_ID() > 0) {
            return charge;
        }
        charge = new MCharge(Env.getCtx(), 0, transactionName);
        charge.setName(name);
        charge.setDescription(SETUP_DESCRIPTION);
        charge.setC_TaxCategory_ID(new Query(Env.getCtx(), "C_TaxCategory", "Name = ?", transactionName).setParameters("Standard").setClient_ID().firstId());
        charge.saveEx();
        charge.saveEx();
        return charge;
    }

    private X_FM_ProductCategory createFinancialProductCategory(Properties context, String value, String name, String transactionName) {
        X_FM_ProductCategory financialProductCategory = (X_FM_ProductCategory)new Query(context, "FM_ProductCategory", "Value = ?", transactionName).setParameters(value).setClient_ID().first();
        if (financialProductCategory != null && financialProductCategory.getFM_ProductCategory_ID() > 0) {
            return financialProductCategory;
        }
        financialProductCategory = new X_FM_ProductCategory(Env.getCtx(), 0, transactionName);
        financialProductCategory.setValue(value);
        financialProductCategory.setName(name);
        financialProductCategory.setDescription(SETUP_DESCRIPTION);
        financialProductCategory.setType("L");
        financialProductCategory.saveEx();
        return financialProductCategory;
    }

    private X_FM_FunctionalSetting createFunctionalSetting(Properties context, String value, String name, String className, String transactionName) {
        X_FM_FunctionalSetting functionalSetting = (X_FM_FunctionalSetting)new Query(context, "FM_FunctionalSetting", "Value = ?", transactionName).setParameters(value).setClient_ID().first();
        if (functionalSetting != null && functionalSetting.getFM_FunctionalSetting_ID() > 0) {
            return functionalSetting;
        }
        functionalSetting = new X_FM_FunctionalSetting(context, 0, transactionName);
        functionalSetting.setValue(value);
        functionalSetting.setName(name);
        functionalSetting.setClassname(className);
        functionalSetting.setDescription(SETUP_DESCRIPTION);
        functionalSetting.saveEx();
        return functionalSetting;
    }

    private X_FM_FunctionalApplicability createApplicability(Properties context, int functionaSettingId, int financialProductCategoryId, String tableName, String eventType, String eventModelValidator, String transactionName) {
        int tableId = MTable.getTable_ID(tableName);
        X_FM_FunctionalApplicability functionalSettingApplicability = (X_FM_FunctionalApplicability)new Query(context, "FM_FunctionalApplicability", "AD_Table_ID = ? AND EventType = ? AND EventModelValidator = ?", transactionName).setParameters(tableId, eventType, eventModelValidator).setClient_ID().first();
        if (functionalSettingApplicability != null && functionalSettingApplicability.getFM_FunctionalApplicability_ID() > 0) {
            return functionalSettingApplicability;
        }
        functionalSettingApplicability = new X_FM_FunctionalApplicability(Env.getCtx(), 0, transactionName);
        functionalSettingApplicability.setFM_FunctionalSetting_ID(functionaSettingId);
        functionalSettingApplicability.setFM_ProductCategory_ID(financialProductCategoryId);
        if (!Util.isEmpty(tableName)) {
            functionalSettingApplicability.setAD_Table_ID(MTable.getTable_ID(tableName));
        }
        if (!Util.isEmpty(eventType)) {
            functionalSettingApplicability.setEventType(eventType);
        }
        if (!Util.isEmpty(eventModelValidator)) {
            functionalSettingApplicability.setEventModelValidator(eventModelValidator);
        }
        functionalSettingApplicability.setSeqNo(10);
        functionalSettingApplicability.setValidFrom(TimeUtil.getDay(2020, 5, 1));
        functionalSettingApplicability.setDescription(SETUP_DESCRIPTION);
        functionalSettingApplicability.saveEx();
        return functionalSettingApplicability;
    }

    private X_FM_AgreementType createAgreementType(Properties context, String transactionName) {
        String value = "EAT";
        X_FM_AgreementType agreementType = (X_FM_AgreementType)new Query(context, "FM_AgreementType", "Value = ?", transactionName).setParameters(value).setClient_ID().first();
        if (agreementType != null && agreementType.getFM_AgreementType_ID() > 0) {
            return agreementType;
        }
        agreementType = new X_FM_AgreementType(Env.getCtx(), 0, transactionName);
        agreementType.setValue(value);
        agreementType.setName("Testing Contract");
        agreementType.setDescription(SETUP_DESCRIPTION);
        agreementType.setText("This is a testing contract usinng for financial investment and loan, you can use this or create a new agreement type");
        agreementType.saveEx();
        return agreementType;
    }

    private void createTransactionTypes(Properties context, String transactionName) {
        Arrays.asList(MRefList.getList(context, 54020, false)).forEach(valuesPair -> this.createTransactionType(context, valuesPair.getValue(), valuesPair.getValue(), valuesPair.getName(), transactionName));
    }

    private X_FM_TransactionType createTransactionType(Properties context, String type, String value, String name, String transactionName) {
        X_FM_TransactionType transactionType = (X_FM_TransactionType)new Query(context, "FM_TransactionType", "Type = ?", transactionName).setParameters(type).setClient_ID().first();
        if (transactionType != null && transactionType.getFM_TransactionType_ID() > 0) {
            return transactionType;
        }
        transactionType = new X_FM_TransactionType(Env.getCtx(), 0, transactionName);
        transactionType.setValue(value);
        transactionType.setName(name);
        transactionType.setType(type);
        transactionType.saveEx();
        return transactionType;
    }
}

