/*
 * Decompiled with CFR 0.152.
 */
package org.spin.report;

import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.spin.report.OpenILoanToDateAbstract;

public class OpenILoanToDate
extends OpenILoanToDateAbstract {
    private long m_start = System.currentTimeMillis();
    private StringBuffer sql = null;

    @Override
    protected void prepare() {
        super.prepare();
        StringBuffer stringBuffer = new StringBuffer(" WHERE am.DocStatus = 'CO'");
        stringBuffer.append(" AND am.DateDoc <= ?");
        stringBuffer.append(" AND (am.DateInvoiced > ? OR am.DateInvoiced IS NULL)");
        if (this.getBPartnerId() > 0) {
            stringBuffer.append(" AND am.C_BPartner_ID = ?");
        }
        if (this.getCurrencyId() > 0) {
            stringBuffer.append(" AND am.C_Currency_ID = ?");
        }
        if (this.getDocTypeId() > 0) {
            stringBuffer.append(" AND am.C_DocType_ID = ?");
        }
        if (this.getDateDoc() != null) {
            stringBuffer.append(" AND am.DateDoc >= ?");
        }
        if (this.getDateDocTo() != null) {
            stringBuffer.append(" AND am.DateDoc <= ?");
        }
        stringBuffer.append(" AND am.IsSOTrx = ").append(this.isSOTrx() ? "'Y'" : "'N'");
        if (this.getProductId() > 0) {
            stringBuffer.append(" AND am.FM_Product_ID = ?");
        }
        if (this.getAgreementTypeId() > 0) {
            stringBuffer.append(" AND am.FM_AgreementType_ID = ?");
        }
        if (this.getAgreementId() > 0) {
            stringBuffer.append(" AND am.FM_Agreement_ID = ?");
        }
        this.sql = new StringBuffer("INSERT INTO T_FM_OpenLoanToDate(AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, FM_Agreement_ID, FM_AgreementType_ID, C_DocType_ID, DocumentNo, DateDoc, FM_Product_ID, C_BPartner_ID, IsSOTrx, Status, FM_Account_ID, C_Currency_ID, AccountNo, FeesQty, PaymentFrequency, PayDate, CapitalAmt, InterestAmt, TaxAmt, FeeAmt, CurrentCapitalAmt, CurrentInterestAmt, CurrentTaxAmt, CurrentDunningAmt, CurrentDunningTaxAmt, CurrentFeeAmt, OpenFeesQty, PaidFeesQty, CurrentDueFeeAmt, DueFeesQty, PayAmt, C_Invoice_ID, DateInvoiced, DueDate, NextFeeAmt, DateTo, AD_PInstance_ID) SELECT am.AD_Client_ID, am.AD_Org_ID, am.IsActive, am.Created, am.CreatedBy, am.Updated, am.UpdatedBy, am.FM_Agreement_ID, am.FM_AgreementType_ID, am.C_DocType_ID, am.DocumentNo, am.DateDoc, am.FM_Product_ID, am.C_BPartner_ID, am.IsSOTrx, am.Status, am.FM_Account_ID, am.C_Currency_ID, am.AccountNo, ac.FeesQty, ac.PaymentFrequency, ac.PayDate, ac.CapitalAmt, ac.InterestAmt, ac.TaxAmt, COALESCE(ac.CapitalAmt, 0) + COALESCE(ac.InterestAmt, 0) + COALESCE(ac.TaxAmt, 0) AS FeeAmt, SUM(CASE WHEN (am.DateInvoiced IS NULL OR am.DateInvoiced > ?) THEN COALESCE(am.CapitalAmt, 0) ELSE 0 END) AS CurrentCapitalAmt, SUM(CASE WHEN (am.DateInvoiced IS NULL OR am.DateInvoiced > ?) THEN COALESCE(am.InterestAmt, 0) ELSE 0 END) AS CurrentInterestAmt, SUM(CASE WHEN (am.DateInvoiced IS NULL OR am.DateInvoiced > ?) THEN COALESCE(am.TaxAmt, 0) ELSE 0 END) AS CurrentTaxAmt, SUM(CASE WHEN (am.DateInvoiced IS NULL OR am.DateInvoiced > ?) THEN COALESCE(dt.Amount, 0) ELSE 0 END) AS CurrentDunningAmt, SUM(CASE WHEN (am.DateInvoiced IS NULL OR am.DateInvoiced > ?) THEN COALESCE(dtt.Amount, 0) ELSE 0 END) AS CurrentDunningTaxAmt, SUM(CASE WHEN (am.DateInvoiced IS NULL OR am.DateInvoiced > ?) THEN \t\tCOALESCE(am.CapitalAmt, 0) + COALESCE(am.InterestAmt, 0) + COALESCE(am.TaxAmt, 0) + COALESCE(dt.Amount, 0) + COALESCE(dtt.Amount, 0) ELSE 0 END) AS CurrentFeeAmt, SUM(CASE WHEN (am.DateInvoiced IS NULL OR am.DateInvoiced > ?) THEN 1 ELSE 0 END) OpenFeesQty, SUM(CASE WHEN am.DateInvoiced <= ? THEN 1 ELSE 0 END) PaidFeesQty, SUM(CASE WHEN (am.DateInvoiced IS NULL OR am.DateInvoiced > ?) AND am.DueDate <= ? THEN COALESCE(am.CurrentFeeAmt, 0) ELSE 0 END) AS CurrentDueFeeAmt, SUM(CASE WHEN (am.DateInvoiced IS NULL OR am.DateInvoiced > ?) AND am.DueDate <= ? THEN 1 ELSE 0 END) AS DueFeesQty, SUM(CASE WHEN am.DateInvoiced <= ? THEN COALESCE(am.CurrentFeeAmt, 0) ELSE 0 END) AS PayAmt, i.C_Invoice_ID, i.DateInvoiced, ar.DueDate, ar.CurrentFeeAmt, ?, " + this.getAD_PInstance_ID() + " FROM RV_FM_LoanAmortization am INNER JOIN FM_Account ac ON(ac.FM_Account_ID = am.FM_Account_ID) LEFT JOIN (SELECT t.FM_Amortization_ID, \t\tMAX(CASE WHEN tt.Type = 'LDD' THEN t.FM_Transaction_ID ELSE 0 END) AS DunningTransaction_ID, \t\tMAX(CASE WHEN tt.Type = 'LDT' THEN t.FM_Transaction_ID ELSE 0 END) AS DunningTaxTransaction_ID \tFROM FM_Transaction t \tINNER JOIN FM_TransactionType tt ON(tt.FM_TransactionType_ID = t.FM_TransactionType_ID) \tWHERE tt.Type IN('LDD', 'LDT') \tAND EXISTS(SELECT 1 FROM FM_Batch b WHERE b.FM_Batch_ID = t.FM_Batch_ID AND b.DocStatus NOT IN('DR', 'IP', 'IN') AND b.DateDoc <= ? AND b.TotalAmt >= 0) \tGROUP BY t.FM_Amortization_ID) AS ca ON(ca.FM_Amortization_ID = am.FM_Amortization_ID) LEFT JOIN FM_Transaction dt ON(dt.FM_Transaction_ID = ca.DunningTransaction_ID) LEFT JOIN FM_Transaction dtt ON(dtt.FM_Transaction_ID = ca.DunningTaxTransaction_ID) LEFT JOIN (SELECT am.FM_Account_ID, MAX(i.C_Invoice_ID) AS C_Invoice_ID, MAX(i.DateInvoiced) AS DateInvoiced \tFROM C_Invoice i \tINNER JOIN C_InvoiceLine il ON(il.C_Invoice_ID = i.C_Invoice_ID) \tINNER JOIN FM_Amortization am ON(am.FM_Amortization_ID = il.FM_Amortization_ID) \tWHERE i.DocStatus IN('CO', 'CL') \tAND i.DateInvoiced <= ? GROUP BY am.FM_Account_ID) i ON(i.FM_Account_ID = am.FM_Account_ID) LEFT JOIN (SELECT am.FM_Account_ID, MIN(am.FM_Amortization_ID) AS FM_Amortization_ID \tFROM FM_Amortization am \tWHERE am.StartDate <= ? \tAND NOT EXISTS(SELECT 1 \t\t\t\tFROM C_Invoice i \t\t\t\tINNER JOIN C_InvoiceLine il ON(il.C_Invoice_ID = i.C_Invoice_ID) \t\t\t\tWHERE i.DocStatus IN('CO', 'CL') \t\t\t\tAND il.FM_Amortization_ID = am.FM_Amortization_ID) GROUP BY am.FM_Account_ID) dd ON(dd.FM_Account_ID = am.FM_Account_ID) LEFT JOIN RV_FM_LoanAmortization ar ON(ar.FM_Amortization_ID = dd.FM_Amortization_ID) ");
        this.sql.append(stringBuffer);
        this.sql.append("GROUP BY am.AD_Client_ID, am.AD_Org_ID, am.IsActive, am.Created, am.CreatedBy, am.Updated, am.UpdatedBy, am.FM_Agreement_ID, am.FM_AgreementType_ID, am.C_DocType_ID, am.DocumentNo, am.DateDoc, am.DocStatus, am.FM_Product_ID, am.C_BPartner_ID, am.IsSOTrx, am.Status, am.FM_Account_ID, am.C_Currency_ID, am.AccountNo, ac.FeesQty, ac.PaymentFrequency, ac.PayDate, ac.CapitalAmt, ac.InterestAmt, ac.TaxAmt, i.C_Invoice_ID, i.DateInvoiced, ar.DueDate, ar.CurrentFeeAmt");
    }

    @Override
    protected String doIt() throws Exception {
        this.log.fine("SQL = " + this.sql.toString());
        CPreparedStatement cPreparedStatement = DB.prepareStatement(this.sql.toString(), this.get_TrxName());
        int n = 1;
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        cPreparedStatement.setTimestamp(n++, this.getDateTo());
        if (this.getBPartnerId() > 0) {
            cPreparedStatement.setInt(n++, this.getBPartnerId());
        }
        if (this.getCurrencyId() > 0) {
            cPreparedStatement.setInt(n++, this.getCurrencyId());
        }
        if (this.getDocTypeId() > 0) {
            cPreparedStatement.setInt(n++, this.getDocTypeId());
        }
        if (this.getDateDoc() != null) {
            cPreparedStatement.setTimestamp(n++, this.getDateDoc());
        }
        if (this.getDateDocTo() != null) {
            cPreparedStatement.setTimestamp(n++, this.getDateDocTo());
        }
        if (this.getProductId() > 0) {
            cPreparedStatement.setInt(n++, this.getProductId());
        }
        if (this.getAgreementTypeId() > 0) {
            cPreparedStatement.setInt(n++, this.getAgreementTypeId());
        }
        if (this.getAgreementId() > 0) {
            cPreparedStatement.setInt(n++, this.getAgreementId());
        }
        int n2 = cPreparedStatement.executeUpdate();
        this.log.fine(System.currentTimeMillis() - this.m_start + " ms");
        return "@Created@ = " + n2;
    }
}

