/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.IntStream;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.queue.model.MADQueueType;
import org.spin.queue.process.FlushSystemQueue;
import org.spin.queue.util.QueueManager;

public class QueueLoader {
    private static QueueLoader queueLoader = null;
    private Map<Integer, QueueManager> queueMap = new HashMap<Integer, QueueManager>();
    private static final CLogger logger = CLogger.getCLogger(QueueLoader.class);

    public static QueueLoader getInstance() {
        if (queueLoader == null) {
            queueLoader = new QueueLoader();
        }
        return queueLoader;
    }

    private QueueLoader() {
    }

    public QueueManager getQueueManager(String queueType) {
        MADQueueType type = MADQueueType.getByQueueType(Env.getCtx(), queueType, null);
        if (type == null) {
            throw new AdempiereException("@AD_QueueType_ID@ @NotFound@");
        }
        return this.getQueueManager(type.getAD_QueueType_ID());
    }

    public QueueManager getQueueManager(int queueTypeId) {
        if (!this.queueMap.containsKey(queueTypeId)) {
            this.loadClass(queueTypeId);
        }
        QueueManager manager = this.queueMap.get(queueTypeId);
        manager.clear().withQueueTypeId(queueTypeId);
        return manager;
    }

    private String getClassname(int queueTypeId) {
        MADQueueType definition = MADQueueType.getById(Env.getCtx(), queueTypeId, null);
        if (definition == null) {
            return null;
        }
        return definition.getClassname();
    }

    private Class<?> getHandlerClass(int queueTypeId) {
        String className = this.getClassname(queueTypeId);
        if (Util.isEmpty(className)) {
            className = QueueManager.class.getName();
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (QueueManager.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != QueueManager.class) continue;
                logger.log(Level.SEVERE, "Error loading class, Use: " + className);
                return clazz;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Loading class Error" + e.getMessage());
        }
        logger.log(Level.SEVERE, "Not found Class: " + className);
        return null;
    }

    private void loadClass(int queueTypeId) {
        try {
            Class<?> clazz = this.getHandlerClass(queueTypeId);
            QueueManager generator = null;
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            generator = (QueueManager)constructor.newInstance(new Object[0]);
            generator.withQueueTypeId(queueTypeId);
            this.queueMap.put(queueTypeId, generator);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        Env.setContext(Env.getCtx(), "#AD_Client_ID", 11);
        Trx.run(transactionName -> IntStream.range(0, 300).forEach(queueRecord -> QueueLoader.getInstance().getQueueManager("QTL").withContext(Env.getCtx()).withTransactionName(transactionName).withDescription("Hello: " + queueRecord).addToQueue()));
        Trx.run(transactionName -> {
            ProcessInfo result = ProcessBuilder.create(Env.getCtx()).process(FlushSystemQueue.getProcessId()).withParameter("BatchsToProcess", 10).withParameter("RecordsByBatch", 100).withParameter("IsDeleteAfterProcess", false).execute();
            logger.warning(result.getSummary());
        });
    }
}

