/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.setup;

import java.util.Properties;
import org.compiere.model.MProcess;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.Query;
import org.compiere.util.TimeUtil;
import org.spin.queue.process.FlushSystemQueue;
import org.spin.util.ISetupDefinition;

public class QueueSetup
implements ISetupDefinition {
    private static final String SETUP_DESCRIPTION = "(*Created from Setup Automatically*)";

    @Override
    public String doIt(Properties context, String transactionName) {
        this.createSchedule(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createSchedule(Properties context, String transactionName) {
        new Query(context, "AD_Scheduler", "AD_Process_ID = ?", transactionName).setParameters(FlushSystemQueue.getProcessId()).setClient_ID().list().forEach(scheduler -> scheduler.delete(true));
        MScheduler scheduler2 = new MScheduler(context, 0, transactionName);
        scheduler2.setAD_Org_ID(0);
        scheduler2.setName(FlushSystemQueue.getProcessName());
        scheduler2.setDescription(SETUP_DESCRIPTION);
        scheduler2.setAD_Process_ID(FlushSystemQueue.getProcessId());
        scheduler2.setSupervisor_ID(100);
        scheduler2.setFrequencyType("M");
        scheduler2.setFrequency(5);
        scheduler2.setKeepLogDays(7);
        scheduler2.setDateNextRun(TimeUtil.addMinutess(TimeUtil.getDay(System.currentTimeMillis()), scheduler2.getFrequency()));
        scheduler2.saveEx();
        MProcess process = MProcess.get(context, FlushSystemQueue.getProcessId());
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("BatchsToProcess")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("10");
            schedulerParameter.saveEx();
        });
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("RecordsByBatch")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("100");
            schedulerParameter.saveEx();
        });
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("IsDeleteAfterProcess")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("N");
            schedulerParameter.saveEx();
        });
    }
}

