/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MAttachment;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAppSupport;
import org.spin.model.MADUserSocialMedia;
import org.spin.queue.model.MADQueue;
import org.spin.queue.notification.AttachmentStub;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.model.MADNotificationRecipient;
import org.spin.queue.notification.support.INotification;
import org.spin.queue.notification.util.Recipient;
import org.spin.queue.process.FlushSystemQueue;
import org.spin.queue.util.QueueLoader;
import org.spin.queue.util.QueueManager;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class DefaultNotifier
extends QueueManager {
    private int userId;
    private String text;
    private String applicationType;
    private int applicationSupportId;
    private int applicationRegistrationId;
    private String messageType;
    private String updateHandler;
    private List<Recipient> recipients;
    private List<AttachmentStub> attachments;
    private static CCache<String, MADAppRegistration> notifierCache = new CCache("AD_AppRegistration", 30, 0);
    public static final String QUEUETYPE_DefaultNotifier = "NTF";
    public static final String DefaultNotificationType_Notes = "NTE";
    public static final String DefaultNotificationType_EMail = "EMA";
    public static final String DefaultNotificationType_Twitter = "STW";
    public static final String DefaultNotificationType_Facebook = "SFA";
    public static final String DefaultNotificationType_YouTube = "SYT";
    public static final String DefaultNotificationType_Instagram = "SIG";
    public static final String DefaultNotificationType_Skype = "SSK";
    public static final String DefaultNotificationType_LinkedIn = "SIN";
    public static final String DefaultNotificationType_SnapChat = "SSN";
    public static final String DefaultNotificationType_Telegram = "STG";
    public static final String DefaultNotificationType_WhatsApp = "SWH";
    public static final String DefaultNotificationType_UserDefined = "UDP";

    @Override
    public QueueManager clear() {
        super.clear();
        this.clearMessage();
        return this;
    }

    public DefaultNotifier clearMessage() {
        this.userId = 0;
        this.text = null;
        this.applicationType = null;
        this.applicationSupportId = 0;
        this.applicationRegistrationId = 0;
        this.recipients = new ArrayList<Recipient>();
        this.attachments = new ArrayList<AttachmentStub>();
        return this;
    }

    public final int getUserId() {
        return this.userId;
    }

    public final DefaultNotifier withUserId(int userId) {
        this.userId = userId;
        return this;
    }

    public final String getText() {
        return this.text;
    }

    public final DefaultNotifier withText(String text) {
        this.text = text;
        return this;
    }

    public final String getApplicationType() {
        return this.applicationType;
    }

    public final DefaultNotifier withApplicationType(String applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public final DefaultNotifier withMessageType(String messageType) {
        this.messageType = messageType;
        return this;
    }

    public final String getMessageType() {
        return this.messageType;
    }

    public final DefaultNotifier withUpdateHandler(String updateHandler) {
        this.updateHandler = updateHandler;
        return this;
    }

    public final String getUpdateHandler() {
        return this.updateHandler;
    }

    public final int getApplicationSupportId() {
        return this.applicationSupportId;
    }

    public final DefaultNotifier withApplicationSupportId(int applicationSupportId) {
        this.applicationSupportId = applicationSupportId;
        return this;
    }

    public final DefaultNotifier withApplicationSupportCode(String applicationSupportCode) {
        if (Util.isEmpty(applicationSupportCode)) {
            this.applicationRegistrationId = 0;
            return this;
        }
        this.applicationSupportId = this.getApplicationSupportFromValue(applicationSupportCode);
        return this;
    }

    private int getApplicationSupportFromValue(String applicationTypeCode) {
        Optional<MADAppSupport> maybeApplication;
        List<MADAppSupport> supportedApplications = MADAppSupport.getAll(this.getContext(), false, this.getTransactionName());
        if (supportedApplications != null && supportedApplications.size() > 0 && (maybeApplication = supportedApplications.stream().filter(application -> application.getValue().equals(applicationTypeCode)).findFirst()).isPresent()) {
            return maybeApplication.get().getAD_AppSupport_ID();
        }
        return 0;
    }

    public final int getApplicationRegistrationId() {
        return this.applicationRegistrationId;
    }

    public final DefaultNotifier withApplicationRegistrationId(int applicationRegistrationId) {
        this.applicationRegistrationId = applicationRegistrationId;
        return this;
    }

    public final List<Recipient> getRecipients() {
        return this.recipients;
    }

    public final DefaultNotifier addRecipient(String recipient) {
        this.addRecipient(0, recipient, "STD");
        return this;
    }

    public final DefaultNotifier addRecipient(int userId, String recipient) {
        this.addRecipient(userId, recipient, "STD");
        return this;
    }

    public final DefaultNotifier addRecipient(String recipient, String messageType) {
        this.addRecipient(0, recipient, messageType);
        return this;
    }

    public final DefaultNotifier addRecipient(int userId, String recipient, String messageType) {
        if (!Util.isEmpty(recipient) || userId > 0) {
            this.recipients.add(new Recipient(userId, recipient, messageType));
        }
        return this;
    }

    public final List<AttachmentStub> getAttachments() {
        return this.attachments;
    }

    public final DefaultNotifier addAttachment(File attachment, String comment) {
        Optional.ofNullable(attachment).ifPresent(attachmentToSet -> this.attachments.add(new AttachmentStub(attachment, comment)));
        return this;
    }

    public final DefaultNotifier addAttachment(File attachment) {
        return this.addAttachment(attachment, null);
    }

    @Override
    public void add(int queueId) {
        if (Util.isEmpty(this.getApplicationType())) {
            throw new AdempiereException("@ApplicationType@ @IsMandatory@");
        }
        if (this.getRecipients().size() == 0) {
            throw new AdempiereException("@AD_NotificationRecipient_ID@ @IsMandatory@");
        }
        if (Util.isEmpty(this.text) && Util.isEmpty(this.getDescription())) {
            throw new AdempiereException("@Text@ @IsMandatory@");
        }
        if (this.getApplicationType().equals(DefaultNotificationType_UserDefined) && !this.getRecipients().stream().filter(recipient -> recipient.getUserId() > 0).findFirst().isPresent()) {
            throw new AdempiereException("@AD_User_ID@ @IsMandatory@");
        }
        if (!this.getApplicationType().equals(DefaultNotificationType_UserDefined)) {
            this.addToQueueBasedOnApplicationType(queueId);
        } else {
            this.getRecipients().stream().filter(recipient -> recipient.getUserId() > 0).forEach(recipient -> {
                int applicationSupportId;
                MUser userRecipient = MUser.get(this.getContext(), recipient.getUserId());
                if (userRecipient.isNotificationEMail()) {
                    applicationSupportId = this.getApplicationSupportFromValue(DefaultNotificationType_EMail);
                    this.addToQueueBasedOnUserDefinition(DefaultNotificationType_EMail, applicationSupportId, queueId, userRecipient.getAD_User_ID(), userRecipient.getEMail(), recipient.getMessageType());
                }
                if (userRecipient.isNotificationNote()) {
                    applicationSupportId = this.getApplicationSupportFromValue(DefaultNotificationType_Notes);
                    this.addToQueueBasedOnUserDefinition(DefaultNotificationType_Notes, applicationSupportId, queueId, recipient.getUserId(), recipient.getAccountName(), recipient.getMessageType());
                }
                if (userRecipient.isNotificationSocialMedia()) {
                    MADUserSocialMedia.getSocialMedias(this.getContext(), recipient.getUserId(), this.getTransactionName()).stream().filter(socialMedia -> socialMedia.isReceiveNotifications()).forEach(socialMedia -> {
                        int applicationSupportId = socialMedia.getAD_AppSupport_ID();
                        if (applicationSupportId <= 0) {
                            applicationSupportId = this.getApplicationSupportFromValue(socialMedia.getApplicationType());
                        }
                        this.addToQueueBasedOnUserDefinition(socialMedia.getApplicationType(), applicationSupportId, queueId, userRecipient.getAD_User_ID(), socialMedia.getAccountName(), recipient.getMessageType());
                    });
                }
            });
        }
    }

    private void addToQueueBasedOnUserDefinition(String applicationType, int applicationSupportId, int queueId, int userId, String accountName, String messageType) {
        MADQueue queue = new MADQueue(this.getContext(), queueId, this.getTransactionName());
        MADNotificationQueue notification = new MADNotificationQueue(queue);
        notification.setApplicationType(applicationType);
        if (this.getUserId() > 0) {
            notification.setAD_User_ID(this.getUserId());
        }
        if (this.getApplicationSupportId() > 0) {
            notification.setAD_AppSupport_ID(applicationSupportId);
        }
        if (!Util.isEmpty(this.getText())) {
            notification.setText(this.getText());
        }
        if (!Util.isEmpty(this.getDescription())) {
            notification.setDescription(this.getDescription());
        }
        if (Util.isEmpty(messageType)) {
            messageType = this.getMessageType();
        }
        if (!Util.isEmpty(messageType)) {
            notification.setMessageType(messageType);
        } else {
            notification.setMessageType("STD");
        }
        if (!Util.isEmpty(this.getUpdateHandler())) {
            notification.setResponseHandler(this.getUpdateHandler());
        }
        notification.saveEx();
        MADNotificationRecipient notificationRecipient = new MADNotificationRecipient(notification);
        notificationRecipient.setAccountName(Optional.ofNullable(accountName).orElse("").trim());
        if (userId > 0) {
            notificationRecipient.setAD_User_ID(userId);
        }
        notificationRecipient.saveEx();
        if (this.getAttachments().size() > 0) {
            this.getAttachments().forEach(attachment -> {
                MAttachment attachmentReference = notification.createAttachment();
                attachmentReference.addEntry(attachment.getAttachment());
                Optional.ofNullable(attachment.getComment()).ifPresent(comment -> attachmentReference.addTextMsg((String)comment));
                attachmentReference.saveEx(this.getTransactionName());
            });
        }
        logger.fine("Queue Added: " + notification);
    }

    private void addToQueueBasedOnApplicationType(int queueId) {
        MADQueue queue = new MADQueue(this.getContext(), queueId, this.getTransactionName());
        MADNotificationQueue notification = new MADNotificationQueue(queue);
        notification.setApplicationType(this.getApplicationType());
        if (this.getUserId() > 0) {
            notification.setAD_User_ID(this.getUserId());
        }
        if (this.getApplicationSupportId() > 0) {
            notification.setAD_AppSupport_ID(this.getApplicationSupportId());
        }
        if (this.getApplicationRegistrationId() > 0) {
            notification.setAD_AppRegistration_ID(this.getApplicationRegistrationId());
        }
        if (!Util.isEmpty(this.getText())) {
            notification.setText(this.getText());
        }
        if (!Util.isEmpty(this.getDescription())) {
            notification.setDescription(this.getDescription());
        }
        if (!Util.isEmpty(this.getMessageType())) {
            notification.setMessageType(this.getMessageType());
        } else {
            notification.setMessageType("STD");
        }
        if (!Util.isEmpty(this.getUpdateHandler())) {
            notification.setResponseHandler(this.getUpdateHandler());
        }
        notification.saveEx();
        this.getRecipients().forEach(recipient -> {
            MADNotificationRecipient notificationRecipient = new MADNotificationRecipient(notification);
            notificationRecipient.setAccountName(recipient.getAccountName().trim());
            if (recipient.getUserId() > 0) {
                notificationRecipient.setAD_User_ID(recipient.getUserId());
            }
            if (!Util.isEmpty(recipient.getMessageType())) {
                notificationRecipient.setMessageType(recipient.getMessageType());
            } else {
                notificationRecipient.setMessageType(notification.getMessageType());
            }
            notificationRecipient.saveEx();
        });
        if (this.getAttachments().size() > 0) {
            this.getAttachments().forEach(attachment -> {
                MAttachment attachmentReference = notification.createAttachment();
                attachmentReference.addEntry(attachment.getAttachment());
                Optional.ofNullable(attachment.getComment()).ifPresent(comment -> attachmentReference.addTextMsg((String)comment));
                attachmentReference.saveEx(this.getTransactionName());
            });
        }
        logger.fine("Queue Added: " + notification);
    }

    @Override
    public void process(int queueId) {
        MADNotificationQueue.getNotificationsFromQueue(this.getContext(), queueId, this.getTransactionName()).forEach(notification -> {
            try {
                this.getNotifier((MADNotificationQueue)notification).sendNotification((MADNotificationQueue)notification);
                notification.setProcessed(true);
                notification.saveEx();
            }
            catch (Exception e) {
                notification.setProcessed(false);
                notification.saveEx();
                throw new AdempiereException(e);
            }
        });
    }

    protected INotification getNotifier(MADNotificationQueue queue) {
        try {
            MADAppRegistration registeredApplication = this.getRegistration(queue);
            if (registeredApplication == null) {
                throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
            }
            IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
            if (supportedApplication != null && INotification.class.isAssignableFrom(supportedApplication.getClass())) {
                return (INotification)supportedApplication;
            }
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            throw new AdempiereException(e);
        }
        return null;
    }

    private MADAppRegistration getRegistration(MADNotificationQueue queue) {
        String key = queue.getApplicationType() + "|" + queue.getAD_AppSupport_ID() + "|" + queue.getAD_AppRegistration_ID();
        MADAppRegistration registration = notifierCache.get(key);
        if (registration == null) {
            if (queue.getAD_AppRegistration_ID() > 0) {
                registration = MADAppRegistration.getById(this.getContext(), queue.getAD_AppRegistration_ID(), this.getTransactionName());
            } else if (queue.getAD_AppSupport_ID() > 0) {
                registration = (MADAppRegistration)new Query(this.getContext(), "AD_AppRegistration", "AD_AppSupport_ID = ?", this.getTransactionName()).setParameters(queue.getAD_AppSupport_ID()).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
            } else if (!Util.isEmpty(queue.getApplicationType())) {
                registration = MADAppRegistration.getByApplicationType(this.getContext(), queue.getApplicationType(), this.getTransactionName());
            }
            Optional.ofNullable(registration).ifPresent(registrationToPush -> notifierCache.put(key, (MADAppRegistration)registrationToPush));
        }
        return registration;
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        Env.setContext(Env.getCtx(), "#AD_Client_ID", 11);
        Trx.run(transactionName -> {
            DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager(QUEUETYPE_DefaultNotifier).withContext(Env.getCtx()).withTransactionName(transactionName);
            notifier.clearMessage().withApplicationType(DefaultNotificationType_Notes).withUserId(100).withText("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec fringilla faucibus enim quis aliquam. Integer tincidunt et dui vitae egestas. Suspendisse felis est, commodo at ex eu, pellentesque varius leo. Pellentesque tempor quis felis et rutrum. Curabitur imperdiet euismod leo, in pretium ante convallis eu. Nam non odio vulputate, luctus est sed, semper dolor. Vivamus auctor, odio vitae sodales vestibulum, lacus metus auctor ex, nec accumsan est nibh a erat. Ut suscipit velit a imperdiet vestibulum.\n\nMaecenas vel felis ac nulla eleifend volutpat in ac magna. Duis dui est, facilisis at posuere eu, faucibus at nisl. Duis efficitur porttitor lorem. Curabitur tincidunt lorem massa, in sollicitudin ante fringilla sit amet. Nunc nec neque pharetra, tempor mi ac, pharetra risus. Donec tristique laoreet dolor tincidunt venenatis. Sed et leo eget diam molestie venenatis in a eros. Cras nibh arcu, laoreet et suscipit sed, ornare eu mauris. Nulla egestas lacus efficitur, faucibus odio sed, elementum velit. Proin fringilla bibendum lacinia. Vivamus maximus vulputate hendrerit. Fusce mauris ex, finibus eget augue at, volutpat viverra ipsum. Nullam justo nibh, maximus vel nisl tempus, sollicitudin tempor magna.\n\nSed odio dui, tristique sit amet pretium vitae, vehicula vitae enim. In et interdum quam. Etiam id metus a quam interdum tempor. Sed luctus, tellus et mollis porttitor, dolor lectus dignissim eros, in commodo mauris ligula quis eros. Suspendisse scelerisque ipsum at turpis suscipit interdum at ac velit. Aenean suscipit ipsum ut velit cursus sodales. Nulla viverra mi quis commodo aliquam. Ut auctor condimentum urna sed mollis. Fusce neque neque, interdum eget purus ut, efficitur vestibulum lectus. Praesent sagittis nunc ut tincidunt posuere. In faucibus, elit vel vehicula porta, felis ligula finibus arcu, in suscipit odio risus pellentesque lorem. Etiam viverra lacus a eros placerat, eget tempus mi eleifend. Donec ac arcu vel lacus tristique imperdiet. Quisque venenatis arcu egestas ex viverra accumsan. Aenean vitae massa sed elit hendrerit faucibus.\n\nIn hac habitasse platea dictumst. Sed tellus ante, pretium ut viverra feugiat, consectetur et velit. Nulla quis nibh est. Quisque pharetra sem eget ultrices efficitur. Phasellus maximus posuere metus, facilisis dictum justo bibendum ut. Sed aliquet scelerisque risus vel luctus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Suspendisse eget diam vestibulum risus venenatis pellentesque. Suspendisse tincidunt orci et nisl malesuada, ut porta neque dictum. Quisque at mollis arcu. Nulla sodales diam id lacus efficitur aliquet. In dui leo, pharetra vulputate purus quis, tincidunt ultricies enim. Nulla facilisi. Donec sagittis pharetra ante. Aenean et condimentum ligula, sed volutpat lorem.\n\nNulla laoreet faucibus odio, in rutrum diam semper ut. Praesent at purus id massa hendrerit ultricies. Nam sodales sapien id diam finibus viverra. Duis efficitur hendrerit vulputate. Cras urna enim, vestibulum sit amet ex nec, lobortis viverra massa. Morbi accumsan vel magna in dictum. Cras sed mollis libero. Etiam egestas, orci sed dapibus tempus, ligula ex vulputate lacus, sit amet volutpat urna nulla ac massa. Phasellus ac sollicitudin purus. Ut sit amet ligula eget justo imperdiet rhoncus non nec lectus. Mauris euismod ornare felis et dictum. Maecenas vestibulum dictum dui, ut elementum tellus convallis ac. In congue nunc vel felis elementum, at ultrices velit pharetra.\n").addRecipient("YamelSenih").addAttachment(new File("/home/yamel/Downloads/ADempiereQueue.pdf"), "Hola Holaaaaaaaa YoSoyLeo").withDescription("Hello by Notes").addToQueue();
        });
        Trx.run(transactionName -> {
            ProcessInfo result = ProcessBuilder.create(Env.getCtx()).process(FlushSystemQueue.getProcessId()).withParameter("BatchsToProcess", 1).withParameter("RecordsByBatch", 100).withParameter("IsDeleteAfterProcess", false).execute();
            logger.fine(result.getSummary());
        });
    }
}

