/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MArchive;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MClientInfo;
import org.compiere.model.MImage;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.spin.process.SetupFileStorageSystemAbstract;
import org.spin.util.AttachmentUtil;

public class SetupFileStorageSystem
extends SetupFileStorageSystemAbstract {
    private AtomicInteger processed = new AtomicInteger();
    private AtomicInteger ignored = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();

    @Override
    protected String doIt() throws Exception {
        this.migrateAttachment();
        this.migrateImage();
        this.migrateArchive();
        if (this.errors.get() == 0) {
            MClientInfo clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID());
            clientInfo.setFileHandler_ID(this.getFileHandlerId());
            clientInfo.saveEx();
        }
        return "@Processed@ (" + this.processed.get() + ") @Ignored@ (" + this.ignored.get() + ") @Errors@ (" + this.errors.get() + ")";
    }

    private void migrateAttachment() {
        this.addLog("@AD_Attachment_ID@");
        KeyNamePair[] attachmentArray = DB.getKeyNamePairs("SELECT AD_Attachment_ID, UUID FROM AD_Attachment WHERE AD_Client_ID = ?", false, this.getAD_Client_ID());
        Arrays.asList(attachmentArray).forEach(attachmentPair -> Arrays.asList(new MAttachment(this.getCtx(), attachmentPair.getKey(), this.get_TrxName()).getEntries()).forEach(entry -> Trx.run(new TrxRunnable((KeyNamePair)attachmentPair, (MAttachmentEntry)entry){
            final /* synthetic */ KeyNamePair val$attachmentPair;
            final /* synthetic */ MAttachmentEntry val$entry;
            {
                this.val$attachmentPair = keyNamePair;
                this.val$entry = mAttachmentEntry;
            }

            @Override
            public void run(String trxName) {
                int attachmentReferenceId = DB.getSQLValue(SetupFileStorageSystem.this.get_TrxName(), "SELECT AD_AttachmentReference_ID FROM AD_AttachmentReference WHERE AD_Attachment_ID = ? AND FileName = ? AND FileHandler_ID = ?", this.val$attachmentPair.getKey(), this.val$entry.getName(), SetupFileStorageSystem.this.getAppSupportId());
                if (attachmentReferenceId < 0) {
                    try {
                        AttachmentUtil.getInstance(SetupFileStorageSystem.this.getCtx()).withData(this.val$entry.getData()).withAttachmentId(this.val$attachmentPair.getKey()).withFileName(this.val$entry.getName()).withDescription(Msg.getMsg(SetupFileStorageSystem.this.getCtx(), "CreatedFromSetupExternalStorage")).withFileHandlerId(SetupFileStorageSystem.this.getFileHandlerId()).saveAttachment();
                        SetupFileStorageSystem.this.addLog(this.val$entry.getName() + ": @Ok@");
                        SetupFileStorageSystem.this.processed.incrementAndGet();
                    }
                    catch (Exception e) {
                        SetupFileStorageSystem.this.log.warning("Error: " + e.getLocalizedMessage());
                        SetupFileStorageSystem.this.addLog("@ErrorProcessingFile@ " + this.val$entry.getName() + ": " + e.getLocalizedMessage());
                        SetupFileStorageSystem.this.errors.incrementAndGet();
                    }
                } else {
                    SetupFileStorageSystem.this.addLog(this.val$entry.getName() + ": @Ignored@");
                    SetupFileStorageSystem.this.ignored.incrementAndGet();
                }
            }
        })));
    }

    private void migrateImage() {
        this.addLog("@AD_Image_ID@");
        KeyNamePair[] imageArray = DB.getKeyNamePairs("SELECT AD_Image_ID, Name FROM AD_Image WHERE AD_Client_ID = ? AND NOT EXISTS(SELECT 1 FROM AD_AttachmentReference ar WHERE ar.AD_Image_ID = AD_Image.AD_Image_ID AND ar.FileHandler_ID = ?)", false, this.getAD_Client_ID(), this.getAppSupportId());
        Arrays.asList(imageArray).forEach(imagePair -> Trx.run(new TrxRunnable((KeyNamePair)imagePair){
            final /* synthetic */ KeyNamePair val$imagePair;
            {
                this.val$imagePair = keyNamePair;
            }

            @Override
            public void run(String trxName) {
                MImage image = MImage.get(SetupFileStorageSystem.this.getCtx(), this.val$imagePair.getKey());
                try {
                    AttachmentUtil.getInstance(SetupFileStorageSystem.this.getCtx()).withData(image.getData()).withImageId(image.getAD_Image_ID()).withFileName(image.getName()).withDescription(Msg.getMsg(SetupFileStorageSystem.this.getCtx(), "CreatedFromSetupExternalStorage")).withFileHandlerId(SetupFileStorageSystem.this.getFileHandlerId()).saveAttachment();
                    SetupFileStorageSystem.this.addLog(image.getName() + ": @Ok@");
                    SetupFileStorageSystem.this.processed.incrementAndGet();
                }
                catch (Exception e) {
                    SetupFileStorageSystem.this.log.warning("Error: " + e.getLocalizedMessage());
                    SetupFileStorageSystem.this.addLog("@ErrorProcessingFile@ " + image.getName() + ": " + e.getLocalizedMessage());
                    SetupFileStorageSystem.this.errors.incrementAndGet();
                }
            }
        }));
    }

    private void migrateArchive() {
        this.addLog("@AD_Archive_ID@");
        KeyNamePair[] archiveArray = DB.getKeyNamePairs("SELECT AD_Archive_ID, Name FROM AD_Archive WHERE AD_Client_ID = ? AND NOT EXISTS(SELECT 1 FROM AD_AttachmentReference ar WHERE ar.AD_Archive_ID = AD_Archive.AD_Archive_ID AND ar.FileHandler_ID = ?)", false, this.getAD_Client_ID(), this.getAppSupportId());
        Arrays.asList(archiveArray).forEach(archivePair -> Trx.run(new TrxRunnable((KeyNamePair)archivePair){
            final /* synthetic */ KeyNamePair val$archivePair;
            {
                this.val$archivePair = keyNamePair;
            }

            @Override
            public void run(String trxName) {
                MArchive archive = new MArchive(SetupFileStorageSystem.this.getCtx(), this.val$archivePair.getKey(), trxName);
                try {
                    String fileName = archive.getName() + ".pdf";
                    AttachmentUtil.getInstance(SetupFileStorageSystem.this.getCtx()).withData(archive.getBinaryData()).withArchiveId(archive.getAD_Archive_ID()).withFileName(fileName).withDescription(Msg.getMsg(SetupFileStorageSystem.this.getCtx(), "CreatedFromSetupExternalStorage")).withFileHandlerId(SetupFileStorageSystem.this.getFileHandlerId()).saveAttachment();
                    SetupFileStorageSystem.this.addLog(fileName + ": @Ok@");
                    SetupFileStorageSystem.this.processed.incrementAndGet();
                }
                catch (Exception e) {
                    SetupFileStorageSystem.this.log.warning("Error: " + e.getLocalizedMessage());
                    SetupFileStorageSystem.this.addLog("@ErrorProcessingFile@ " + archive.getName() + ": " + e.getLocalizedMessage());
                    SetupFileStorageSystem.this.errors.incrementAndGet();
                }
            }
        }));
    }
}

