/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.model.X_AD_PrintFormat;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.Env;
import org.compiere.util.ExtensionFileFilter;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.I_HR_Process;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Payroll;
import org.eevolution.model.X_HR_Process;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.model.MHRProcessReport;
import org.spin.model.MHRProcessReportTemplate;
import org.spin.model.X_HR_ProcessReportTemplate;
import org.spin.model.X_RV_HR_ProcessDetail;
import org.spin.process.PayrollProcessReportAbstract;
import org.spin.util.AbstractPayrollReportExport;

public class PayrollProcessReport
extends PayrollProcessReportAbstract {
    private int printFormatId = 0;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getHRProcessId() == 0 && this.getTable_ID() == I_HR_Process.Table_ID && this.getRecord_ID() > 0) {
            this.setHRProcessId(this.getRecord_ID());
        }
    }

    @Override
    protected String doIt() throws Exception {
        Serializable serializable;
        PO pO;
        MHRProcessReport mHRProcessReport = MHRProcessReport.get(this.getCtx(), this.getProcessReportId());
        if (mHRProcessReport.isCanExport()) {
            return this.exportToFile(mHRProcessReport);
        }
        String string = mHRProcessReport.getName();
        String string2 = mHRProcessReport.getPrintName();
        String string3 = mHRProcessReport.getTextMsg();
        String string4 = mHRProcessReport.getReceiptFooterMsg();
        if (this.getProcessReportTemplateId() != 0 && (pO = MHRProcessReportTemplate.get(this.getCtx(), this.getProcessReportTemplateId())) != null) {
            this.printFormatId = ((X_HR_ProcessReportTemplate)pO).getAD_PrintFormat_ID();
            if (!Util.isEmpty(((X_HR_ProcessReportTemplate)pO).getName())) {
                string = ((X_HR_ProcessReportTemplate)pO).getName();
            }
            if (!Util.isEmpty(((X_HR_ProcessReportTemplate)pO).getPrintName())) {
                string2 = ((X_HR_ProcessReportTemplate)pO).getPrintName();
            }
            if (!Util.isEmpty(((X_HR_ProcessReportTemplate)pO).getTextMsg())) {
                string3 = ((X_HR_ProcessReportTemplate)pO).getTextMsg();
            }
            if (!Util.isEmpty(((X_HR_ProcessReportTemplate)pO).getReceiptFooterMsg())) {
                string4 = ((X_HR_ProcessReportTemplate)pO).getReceiptFooterMsg();
            }
        }
        if (this.printFormatId == 0) {
            this.printFormatId = mHRProcessReport.getAD_PrintFormat_ID();
        }
        if (this.printFormatId == 0 && this.getPayrollId() != 0) {
            pO = MHRPayroll.getById(this.getCtx(), this.getPayrollId(), this.get_TrxName());
            this.printFormatId = ((X_HR_Payroll)pO).getAD_PrintFormat_ID();
            this.log.info("Print Format from Payroll");
        }
        if (this.printFormatId == 0 && this.getHRProcessId() != 0) {
            pO = new MHRProcess(this.getCtx(), this.getHRProcessId(), this.get_TrxName());
            serializable = MHRPayroll.getById(this.getCtx(), ((X_HR_Process)pO).getHR_Payroll_ID(), this.get_TrxName());
            this.printFormatId = ((X_HR_Payroll)serializable).getAD_PrintFormat_ID();
            this.log.info("Print Format from Process");
        }
        if (this.printFormatId == 0) {
            throw new AdempiereException("@AD_PrintFormat_ID@ @NotFound@");
        }
        pO = MPrintFormat.get(this.getCtx(), this.printFormatId, false);
        serializable = new MQuery("HR_ProcessReport");
        ((MQuery)serializable).addRestriction("HR_ProcessReport_ID", "=", this.getProcessReportId());
        PrintInfo printInfo = new PrintInfo(Msg.translate(this.getCtx(), "HR_ProcessReport_ID"), this.getTable_ID(), this.getProcessReportId());
        printInfo.setAD_Table_ID(this.getTable_ID());
        if (pO != null && ((X_AD_PrintFormat)pO).getJasperProcess_ID() > 0) {
            ProcessBuilder processBuilder = ProcessBuilder.create(this.getCtx()).process(((X_AD_PrintFormat)pO).getJasperProcess_ID()).withTitle(this.getProcessInfo().getTitle()).withRecordId(I_HR_Process.Table_ID, this.getProcessReportId()).withParameter("ProcessReportName", string).withParameter("ProcessReportPrintName", string2).withParameter("ProcessReportTextMsg", string3).withParameter("ProcessReportReceiptFooterMsg", string4);
            if (this.getRecord_ID() != 0) {
                processBuilder.withParameter("HR_Process_ID", new BigDecimal(this.getHRProcessId()));
            }
            Arrays.asList(this.getParameter()).forEach(processInfoParameter -> processBuilder.withParameter(processInfoParameter.getParameterName(), processInfoParameter.getParameter(), processInfoParameter.getParameter_To()));
            processBuilder.withPrintPreview();
            ProcessInfo processInfo = processBuilder.execute(this.get_TrxName());
            this.getProcessInfo().setPDFReport(processInfo.getPDFReport());
            this.getProcessInfo().setReportAsFile(processInfo.getPDFReport());
        }
        return "Ok";
    }

    public List<X_RV_HR_ProcessDetail> loadDetail(MHRProcessReport mHRProcessReport) throws Exception {
        if (mHRProcessReport.getFileExportClass() == null || mHRProcessReport.getFileExportClass().length() == 0) {
            throw new AdempiereException("@FileExportClass@ @NotFound@");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            if (processInfoParameter.getParameter() == null && processInfoParameter.getParameter_To() == null || processInfoParameter.getParameterName().equals("HR_ProcessReportTemplate_ID")) continue;
            if (processInfoParameter.getParameter_To() == null) {
                if (processInfoParameter.getParameter() == null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(processInfoParameter.getParameterName()).append("=?");
                arrayList.add(processInfoParameter.getParameter());
                continue;
            }
            if (processInfoParameter.getParameter() != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(processInfoParameter.getParameterName()).append(">=?");
                arrayList.add(processInfoParameter.getParameter());
            }
            if (processInfoParameter.getParameter_To() == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(processInfoParameter.getParameterName()).append("<=?");
            arrayList.add(processInfoParameter.getParameter_To());
        }
        return new Query(this.getCtx(), "RV_HR_ProcessDetail", stringBuffer.toString(), this.get_TrxName()).setClient_ID().setParameters(arrayList).setOnlyActiveRecords(true).list();
    }

    public String exportToFile(MHRProcessReport mHRProcessReport) throws Exception {
        List<X_RV_HR_ProcessDetail> list = this.loadDetail(mHRProcessReport);
        if (!Ini.isClient()) {
            return "Ok";
        }
        if (list == null || list.size() == 0) {
            return "Ok";
        }
        AbstractPayrollReportExport abstractPayrollReportExport = mHRProcessReport.getPayrollReportExport();
        if (abstractPayrollReportExport == null) {
            return "Ok";
        }
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle(Msg.getMsg(this.getCtx(), "Export") + ": " + mHRProcessReport.getName());
        if (!Util.isEmpty(abstractPayrollReportExport.getExtension())) {
            jFileChooser.addChoosableFileFilter(new ExtensionFileFilter(abstractPayrollReportExport.getExtension(), mHRProcessReport.getName()));
        }
        if (jFileChooser.showSaveDialog(Env.getWindow(this.getProcessInfo().getWindowNo())) != 0) {
            return "Ok";
        }
        file = ExtensionFileFilter.getFile(jFileChooser.getSelectedFile(), jFileChooser.getFileFilter());
        String string = file.getPath();
        if (string.lastIndexOf(46) == -1) {
            if (Util.isEmpty(abstractPayrollReportExport.getCompleteFileName())) {
                return "@Error@: @FileInvalidExtension@";
            }
            file = new File(file.getParentFile(), abstractPayrollReportExport.getCompleteFileName());
        }
        string = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
        this.log.config("File=" + file.getPath() + "; Type=" + string);
        file.createNewFile();
        boolean bl = mHRProcessReport.exportToFile(file, list);
        if (bl && Ini.isClient()) {
            Env.startBrowser(file.toURI().toString());
        }
        return "@Exported@ : " + file.getPath();
    }
}

