/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MUser;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.process.PaymentCreateFromInvoiceAbstract;

public class PaymentCreateFromInvoice
extends PaymentCreateFromInvoiceAbstract {
    private boolean isNew = false;
    private MPayment payment = null;
    private BigDecimal remaining = Env.ZERO;
    private BigDecimal totalPayAmt = Env.ZERO;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0 && this.getBankAccountId() == 0 && this.getPayDate() == null) {
            throw new AdempiereException("@C_Payment_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        for (int invoiceId : this.getSelectionKeys()) {
            BigDecimal payAmt = this.getSelectionAsBigDecimal(invoiceId, "INV_PayAmt");
            BigDecimal discountAmt = this.getSelectionAsBigDecimal(invoiceId, "INV_DiscountAmt");
            if (discountAmt == null) {
                discountAmt = Env.ZERO;
            }
            this.totalPayAmt = this.totalPayAmt.add(payAmt.subtract(discountAmt));
        }
        if (!this.isOverUnderPayment() && this.getPayAmt() != null && this.getPayAmt().compareTo(Env.ZERO) > 0 && this.totalPayAmt.compareTo(this.getPayAmt()) != 0) {
            throw new AdempiereException("@PaymentAllocateSumInconsistent@");
        }
        if (this.getPayAmt() == null || this.getPayAmt().compareTo(Env.ZERO) <= 0) {
            this.setPayAmt(this.totalPayAmt);
        }
        for (int invoiceId : this.getSelectionKeys()) {
            if (this.payment == null) {
                MInvoice invoice = new MInvoice(this.getCtx(), invoiceId, this.get_TrxName());
                this.createPayment(invoice.getC_BPartner_ID(), invoice.getC_Currency_ID());
            }
            BigDecimal openAmt = this.getSelectionAsBigDecimal(invoiceId, "INV_OpenAmt");
            BigDecimal payAmt = this.getSelectionAsBigDecimal(invoiceId, "INV_PayAmt");
            BigDecimal discountAmt = this.getSelectionAsBigDecimal(invoiceId, "INV_DiscountAmt");
            if (discountAmt == null) {
                discountAmt = Env.ZERO;
            }
            MPaymentAllocate invoicePayAllocate = new MPaymentAllocate(this.getCtx(), 0, this.get_TrxName());
            invoicePayAllocate.setC_Payment_ID(this.payment.getC_Payment_ID());
            invoicePayAllocate.setC_Invoice_ID(invoiceId);
            payAmt = payAmt.subtract(discountAmt);
            BigDecimal overUnderAmt = openAmt.subtract(payAmt);
            if (this.remaining.compareTo(Env.ZERO) > 0) {
                this.remaining = this.remaining.subtract(payAmt);
                if (this.remaining.compareTo(Env.ZERO) < 0) {
                    overUnderAmt = payAmt;
                    payAmt = payAmt.add(this.remaining);
                    overUnderAmt = overUnderAmt.subtract(payAmt);
                }
            }
            invoicePayAllocate.setInvoiceAmt(openAmt);
            invoicePayAllocate.setAmount(payAmt);
            invoicePayAllocate.setDiscountAmt(discountAmt);
            invoicePayAllocate.setOverUnderAmt(overUnderAmt);
            invoicePayAllocate.saveEx();
            if (overUnderAmt.compareTo(Env.ZERO) <= 0) continue;
            break;
        }
        if (this.isNew) {
            this.payment.load(this.get_TrxName());
            if (!this.payment.processIt("CO")) {
                throw new AdempiereException("@Error@ " + this.payment.getProcessMsg());
            }
            this.payment.saveEx();
            return this.payment.getDescription();
        }
        this.addLog(this.payment.getC_Payment_ID(), this.payment.getDateTrx(), null, this.payment.getDocumentNo());
        return "@Created@ @C_Payment_ID@ " + this.payment.getDocumentInfo();
    }

    private void createPayment(int businessPartnerId, int currencyId) {
        if (this.getRecord_ID() > 0) {
            this.payment = new MPayment(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        } else {
            this.payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            this.isNew = true;
        }
        this.payment.setC_BPartner_ID(businessPartnerId);
        this.payment.setC_BankAccount_ID(this.getBankAccountId());
        this.payment.setDateTrx(this.getPayDate());
        this.payment.setDateAcct(this.getDateDoc());
        if (this.getDocTypeTargetId() > 0) {
            this.payment.setC_DocType_ID(this.getDocTypeTargetId());
        }
        this.payment.setPayAmt(this.getPayAmt());
        this.remaining = this.getPayAmt();
        MUser user = MUser.get(this.getCtx(), this.getAD_User_ID());
        String userName = "";
        if (user != null) {
            userName = user.getName();
        }
        this.payment.setDescription(Msg.parseTranslation(Env.getCtx(), "@Created@ @from@") + " - " + userName + " - " + DisplayType.getDateFormat(15).format(this.getPayDate()));
        this.payment.setTenderType(this.getTenderType());
        this.payment.setC_Currency_ID(currencyId);
        if (!Util.isEmpty(this.getAccountNo())) {
            this.payment.setAccountNo(this.getAccountNo());
        }
        if (!Util.isEmpty(this.getRoutingNo())) {
            this.payment.setRoutingNo(this.getRoutingNo());
        }
        if (!Util.isEmpty(this.getCheckNo())) {
            this.payment.setCheckNo(this.getCheckNo());
        }
        if (!Util.isEmpty(this.getMicr())) {
            this.payment.setMicr(this.getMicr());
        }
        if (!Util.isEmpty(this.getCreditCardType())) {
            this.payment.setCreditCardType(this.getCreditCardType());
        }
        if (!Util.isEmpty(this.getTrxType())) {
            this.payment.setTrxType(this.getTrxType());
        }
        if (!Util.isEmpty(this.getCreditCardNumber())) {
            this.payment.setCreditCardNumber(this.getCreditCardNumber());
        }
        if (!Util.isEmpty(this.getCreditCardVV())) {
            this.payment.setCreditCardVV(this.getCreditCardVV());
        }
        if (this.getCreditCardExpMM() != 0) {
            this.payment.setCreditCardExpMM(this.getCreditCardExpMM());
        }
        if (this.getCreditCardExpYY() != 0) {
            this.payment.setCreditCardExpYY(this.getCreditCardExpYY());
        }
        if (!Util.isEmpty(this.getName())) {
            this.payment.setA_Name(this.getName());
        }
        if (!Util.isEmpty(this.getStreet())) {
            this.payment.setA_Street(this.getStreet());
        }
        if (!Util.isEmpty(this.getCity())) {
            this.payment.setA_City(this.getCity());
        }
        if (!Util.isEmpty(this.getZip())) {
            this.payment.setA_Zip(this.getZip());
        }
        if (!Util.isEmpty(this.getState())) {
            this.payment.setA_State(this.getState());
        }
        if (!Util.isEmpty(this.getCountry())) {
            this.payment.setA_Country(this.getCountry());
        }
        if (!Util.isEmpty(this.getIdentDL())) {
            this.payment.setA_Ident_DL(this.getIdentDL());
        }
        if (!Util.isEmpty(this.getIdentSSN())) {
            this.payment.setA_Ident_SSN(this.getIdentSSN());
        }
        if (!Util.isEmpty(this.getEMail())) {
            this.payment.setA_EMail(this.getEMail());
        }
        if (this.getTaxAmt() != null) {
            this.payment.setTaxAmt(this.getTaxAmt());
        }
        if (!Util.isEmpty(this.getPONum())) {
            this.payment.setPONum(this.getPONum());
        }
        if (!Util.isEmpty(this.getVoiceAuthCode())) {
            this.payment.setVoiceAuthCode(this.getVoiceAuthCode());
        }
        if (!Util.isEmpty(this.getTrxID())) {
            this.payment.setOrig_TrxID(this.getTrxID());
        }
        this.payment.saveEx();
    }
}

