/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.spin.process.InOutRMACreateFromAbstract;

public class InOutRMACreateFrom
extends InOutRMACreateFromAbstract {
    private int getValidLocator(int locatorId, MLocator defaultLocator) {
        if (this.getLocatorId() != 0) {
            locatorId = this.getLocatorId();
        }
        if (locatorId != 0) {
            MLocator locator = MLocator.get(this.getCtx(), locatorId);
            if (locator == null) {
                locatorId = 0;
            } else if (defaultLocator != null && locator.getM_Warehouse_ID() != defaultLocator.getM_Warehouse_ID()) {
                locatorId = 0;
            }
        }
        if (locatorId == 0) {
            if (defaultLocator != null) {
                locatorId = defaultLocator.getM_Locator_ID();
            } else {
                throw new AdempiereException("@M_Locator_ID@ @NotFound@");
            }
        }
        return locatorId;
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() == 0) {
            return "@M_InOut_ID@ @NotFound@";
        }
        MInOut inout = new MInOut(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (inout.isProcessed()) {
            return "@M_InOut_ID@ @Processed@";
        }
        AtomicInteger referenceId = new AtomicInteger(0);
        AtomicInteger created = new AtomicInteger(0);
        this.log.config(inout + ", C_Locator_ID=" + this.getLocatorId());
        MLocator defaultLocator = MLocator.getDefault((MWarehouse)inout.getM_Warehouse());
        List<Integer> recordIds = this.getSelectionKeys();
        recordIds.stream().forEach(key -> {
            int productId = this.getSelectionAsInt((int)key, "CF_M_Product_ID");
            int chargeId = this.getSelectionAsInt((int)key, "CF_C_Charge_ID");
            int uomId = this.getSelectionAsInt((int)key, "CF_C_UOM_ID");
            int locatorId = this.getSelectionAsInt((int)key, "CF_M_Locator_ID");
            BigDecimal qtyEntered = this.getSelectionAsBigDecimal((int)key, "CF_QtyEntered");
            locatorId = this.getValidLocator(locatorId, defaultLocator);
            int precision = 2;
            if (productId != 0) {
                MProduct product = MProduct.get(this.getCtx(), productId);
                precision = product.getUOMPrecision();
            }
            qtyEntered = qtyEntered.setScale(precision, 5);
            this.log.fine("Line QtyEntered=" + qtyEntered + ", Product=" + productId + ", Key=" + key);
            MInOutLine inOutLine = new MInOutLine(inout);
            inOutLine.setM_Product_ID(productId, uomId);
            inOutLine.setQty(qtyEntered);
            MOrderLine orderLine = new MOrderLine(this.getCtx(), (int)key, this.get_TrxName());
            referenceId.set(orderLine.getC_Order_ID());
            inOutLine.setC_OrderLine_ID((int)key);
            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                inOutLine.setMovementQty(qtyEntered.multiply(orderLine.getQtyOrdered()).divide(orderLine.getQtyEntered(), 12, 4));
                inOutLine.setC_UOM_ID(orderLine.getC_UOM_ID());
            }
            inOutLine.setM_AttributeSetInstance_ID(orderLine.getM_AttributeSetInstance_ID());
            inOutLine.setDescription(orderLine.getDescription());
            inOutLine.setC_Project_ID(orderLine.getC_Project_ID());
            inOutLine.setC_ProjectPhase_ID(orderLine.getC_ProjectPhase_ID());
            inOutLine.setC_ProjectTask_ID(orderLine.getC_ProjectTask_ID());
            inOutLine.setC_Activity_ID(orderLine.getC_Activity_ID());
            inOutLine.setC_Campaign_ID(orderLine.getC_Campaign_ID());
            inOutLine.setAD_OrgTrx_ID(orderLine.getAD_OrgTrx_ID());
            inOutLine.setUser1_ID(orderLine.getUser1_ID());
            inOutLine.setUser2_ID(orderLine.getUser2_ID());
            inOutLine.setUser3_ID(orderLine.getUser3_ID());
            inOutLine.setUser4_ID(orderLine.getUser4_ID());
            if (chargeId != 0) {
                inOutLine.setC_Charge_ID(chargeId);
            }
            inOutLine.setM_Locator_ID(locatorId);
            inOutLine.saveEx();
            created.updateAndGet(createNo -> createNo + 1);
        });
        this.addReference(inout, referenceId.get());
        return "@Created@ " + created.get();
    }

    private void addReference(MInOut inout, int referenceId) {
        if (referenceId == 0) {
            return;
        }
        MOrder order = new MOrder(this.getCtx(), referenceId, this.get_TrxName());
        inout.setC_Order_ID(order.getC_Order_ID());
        inout.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        inout.setC_Project_ID(order.getC_Project_ID());
        inout.setC_Campaign_ID(order.getC_Campaign_ID());
        inout.setC_Activity_ID(order.getC_Activity_ID());
        inout.setUser1_ID(order.getUser1_ID());
        inout.setUser2_ID(order.getUser2_ID());
        inout.setUser3_ID(order.getUser3_ID());
        inout.setUser4_ID(order.getUser4_ID());
        if (order.isDropShip()) {
            inout.setM_Warehouse_ID(order.getM_Warehouse_ID());
            inout.setIsDropShip(order.isDropShip());
            inout.setDropShip_BPartner_ID(order.getDropShip_BPartner_ID());
            inout.setDropShip_Location_ID(order.getDropShip_Location_ID());
            inout.setDropShip_User_ID(order.getDropShip_User_ID());
        }
        inout.saveEx();
    }
}

