/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MBPartner;
import org.compiere.model.MFreightCategory;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MDDFreightLine;
import org.spin.process.GenerateSalesInvoiceFromFreightOrderAbstract;

public class GenerateSalesInvoiceFromFreightOrder
extends GenerateSalesInvoiceFromFreightOrderAbstract {
    private Hashtable<Integer, MInvoice> invoices;
    private AtomicInteger created = new AtomicInteger();
    private StringBuffer generatedDocuments = new StringBuffer();

    @Override
    protected String doIt() throws Exception {
        this.invoices = new Hashtable();
        List<Object> list = null;
        if (this.getRecord_ID() > 0 && this.getTableName().equals("DD_Freight")) {
            list = new Query(this.getCtx(), "DD_FreightLine", "DD_Freight_ID=?", this.get_TrxName()).setParameters(this.getRecord_ID()).setOrderBy("Line").list();
        } else if (this.isSelection()) {
            this.getProcessInfo().setTableSelectionId(MDDFreightLine.Table_ID);
            list = this.getInstancesForSelection(this.get_TrxName());
        }
        if (list != null) {
            list.stream().filter(mDDFreightLine -> mDDFreightLine.isInvoiced()).filter(mDDFreightLine -> mDDFreightLine.getC_BPartner_ID() != 0).forEach(mDDFreightLine -> this.createInvoice((MDDFreightLine)mDDFreightLine));
        }
        this.processingInvoices();
        this.openResult("C_Invoice");
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createInvoice(MDDFreightLine mDDFreightLine) {
        MFreightCategory mFreightCategory = MFreightCategory.getById(this.getCtx(), mDDFreightLine.getM_FreightCategory_ID(), this.get_TrxName());
        BigDecimal bigDecimal = Env.ZERO;
        bigDecimal = Util.isEmpty(mFreightCategory.getFreightCalculationType()) || mFreightCategory.getFreightCalculationType().equals("W") ? mDDFreightLine.getWeight() : mDDFreightLine.getVolume();
        MInvoice mInvoice = this.getInvoice(mDDFreightLine);
        MInvoiceLine mInvoiceLine = new MInvoiceLine(mInvoice);
        mInvoiceLine.setDD_FreightLine_ID(mDDFreightLine.getDD_FreightLine_ID());
        mInvoiceLine.setC_Invoice_ID(mInvoice.get_ID());
        if (mDDFreightLine.getM_Product_ID() != 0) {
            mInvoiceLine.setM_Product_ID(mDDFreightLine.getM_Product_ID());
            mInvoiceLine.setQty(bigDecimal);
            mInvoiceLine.setPrice();
        } else if (mDDFreightLine.getC_Charge_ID() != 0) {
            mInvoiceLine.setC_Charge_ID(mDDFreightLine.getC_Charge_ID());
            mInvoiceLine.setQty(Env.ONE);
            mInvoiceLine.setPrice(mDDFreightLine.getFreightAmt());
            mInvoiceLine.setTax();
        } else {
            mInvoiceLine.setQty(Env.ONE);
            mInvoiceLine.setPrice(mDDFreightLine.getFreightAmt());
        }
        mInvoiceLine.addDescription(Msg.getMsg(this.getCtx(), "FreightLineDetailForSales", new Object[]{mDDFreightLine.getParent().getDocumentNo(), mDDFreightLine.getLine(), mDDFreightLine.getWeight(), mDDFreightLine.getVolume()}));
        mInvoiceLine.setTax();
        mInvoiceLine.saveEx();
    }

    private MInvoice getInvoice(MDDFreightLine mDDFreightLine) {
        int n = mDDFreightLine.getC_BPartner_ID();
        MInvoice mInvoice = this.invoices.get(n);
        if (mInvoice != null) {
            return mInvoice;
        }
        mInvoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        if (this.getDocTypeTargetId() > 0) {
            mInvoice.setC_DocType_ID(this.getDocTypeTargetId());
        }
        MBPartner mBPartner = MBPartner.get(this.getCtx(), mDDFreightLine.getC_BPartner_ID());
        mInvoice.setBPartner(mBPartner);
        mInvoice.setIsSOTrx(true);
        if (this.getSalesRepId() != 0) {
            mInvoice.setSalesRep_ID(this.getSalesRepId());
        }
        mInvoice.saveEx();
        this.invoices.put(n, mInvoice);
        this.addLog(mInvoice.getC_Invoice_ID(), mInvoice.getDateInvoiced(), null, null);
        return mInvoice;
    }

    private void addToMessage(String string) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(string);
    }

    private void processingInvoices() {
        if (this.invoices == null) {
            return;
        }
        this.invoices.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            MInvoice mInvoice = (MInvoice)entry.getValue();
            mInvoice.setDocAction(this.getDocAction());
            if (!mInvoice.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + mInvoice.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + mInvoice.getDocumentInfo());
            }
            mInvoice.saveEx();
            this.created.addAndGet(1);
            this.addToMessage(mInvoice.getDocumentNo());
        });
        ArrayList<PO> arrayList = new ArrayList<PO>();
        this.invoices.entrySet().stream().filter(entry -> entry != null).forEach(entry -> arrayList.add((PO)entry.getValue()));
        this.printDocument(arrayList, true);
    }
}

