/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MUOMConversion;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.spin.process.GenerateInvoiceInOutBoundAbstract;

public class GenerateInvoiceInOutBound
extends GenerateInvoiceInOutBoundAbstract {
    private Hashtable<Integer, MInvoice> invoices;
    private int created = 0;
    private StringBuffer generatedDocuments = new StringBuffer();

    @Override
    protected String doIt() throws Exception {
        this.invoices = new Hashtable();
        List<Object> outBoundLines = null;
        if (this.getRecord_ID() > 0) {
            outBoundLines = new Query(this.getCtx(), "WM_InOutBoundLine", "WM_InOutBound_ID=?", this.get_TrxName()).setParameters(this.getRecord_ID()).setOrderBy("C_Order_ID, DD_Order_ID").list();
        } else if (this.isSelection()) {
            this.getProcessInfo().setTableSelectionId(MWMInOutBoundLine.Table_ID);
            outBoundLines = this.getInstancesForSelection(this.get_TrxName());
        }
        if (outBoundLines != null) {
            outBoundLines.stream().filter(outBoundLine -> outBoundLine.getC_Invoice_ID() <= 0).forEach(outBoundLine -> this.createInvoice((MWMInOutBoundLine)outBoundLine));
        }
        this.processingInvoices();
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createInvoice(MWMInOutBoundLine outboundLine) {
        if (outboundLine.getC_OrderLine_ID() > 0) {
            MOrderLine orderLine = outboundLine.getOrderLine();
            if (orderLine.getQtyOrdered().subtract(orderLine.getQtyInvoiced()).subtract(outboundLine.getPickedQty()).signum() < 0 && !this.getParameterAsBoolean("IsIncludeNotAvailable")) {
                return;
            }
            BigDecimal qtyInvoiced = outboundLine.getPickedQty();
            MInvoice invoice = this.getInvoice(orderLine, outboundLine.getParent());
            MInvoiceLine invoiceLine = new MInvoiceLine(outboundLine.getCtx(), 0, outboundLine.get_TrxName());
            invoiceLine.setOrderLine(orderLine);
            if (outboundLine.getM_InOutLine_ID() > 0) {
                invoiceLine.setM_InOutLine_ID(outboundLine.getM_InOutLine_ID());
            }
            invoiceLine.setC_Invoice_ID(invoice.get_ID());
            invoiceLine.setC_UOM_ID(outboundLine.getC_UOM_ID());
            invoiceLine.setPrice(MUOMConversion.convertProductTo(this.getCtx(), outboundLine.getM_Product_ID(), outboundLine.getC_UOM_ID(), orderLine.getPriceActual()));
            invoiceLine.setQtyEntered(qtyInvoiced);
            invoiceLine.setQtyInvoiced(qtyInvoiced);
            invoiceLine.setWM_InOutBoundLine_ID(outboundLine.get_ID());
            invoiceLine.saveEx();
        }
    }

    private MInvoice getInvoice(MOrderLine orderLine, MWMInOutBound outbound) {
        MInvoice invoice;
        int key = orderLine.getC_Order_ID();
        if (this.isConsolidateDocument()) {
            key = orderLine.getC_BPartner_ID();
        }
        if ((invoice = this.invoices.get(key)) != null) {
            return invoice;
        }
        MOrder order = orderLine.getParent();
        invoice = new MInvoice(order, 0, this.getDateInvoiced());
        if (this.getDocTypeTargetId() > 0) {
            invoice.setC_DocType_ID(this.getDocTypeTargetId());
        }
        invoice.setIsSOTrx(true);
        invoice.saveEx();
        this.invoices.put(key, invoice);
        return invoice;
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private void processingInvoices() {
        if (this.invoices == null) {
            return;
        }
        this.invoices.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            MInvoice invoice = (MInvoice)entry.getValue();
            invoice.setDocAction(this.getDocAction());
            if (!invoice.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + invoice.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + invoice.getDocumentInfo());
            }
            invoice.saveEx();
            ++this.created;
            this.addToMessage(invoice.getDocumentNo());
        });
        ArrayList<PO> invoicesToPrint = new ArrayList<PO>();
        this.invoices.entrySet().stream().filter(entry -> entry != null).forEach(entry -> invoicesToPrint.add((PO)entry.getValue()));
        this.printDocument(invoicesToPrint, true);
    }
}

