/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_M_RMA;
import org.compiere.model.MInvoice;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.process.GenerateInvoiceFromSalesOrdersAbstract;

public class GenerateInvoiceFromSalesOrders
extends GenerateInvoiceFromSalesOrdersAbstract {
    private StringBuffer generatedDocuments = new StringBuffer();

    @Override
    protected String doIt() throws Exception {
        boolean isOldRMA = this.getSelectionAsBoolean((Integer)this.getSelectionKeys().stream().findFirst().get(), "DT_IsShowRMA");
        int processId = 134;
        int tableId = I_C_Order.Table_ID;
        if (isOldRMA) {
            processId = 52002;
            tableId = I_M_RMA.Table_ID;
        }
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(processId).withParameter("DateInvoiced", this.getDateInvoiced()).withParameter("DocAction", this.getDocAction()).withParameter("ConsolidateDocument", this.isConsolidateDocument()).withParameter("C_DocTypeTarget_ID", this.getDocTypeTargetId()).withSelectedRecordsIds(tableId, this.getSelectionKeys()).withoutTransactionClose().execute(this.get_TrxName());
        ArrayList<PO> documents = new ArrayList<PO>();
        if (processInfo != null) {
            if (processInfo.isError()) {
                throw new AdempiereException(processInfo.getSummary());
            }
            if (processInfo.getIDs() != null) {
                PO.getInstances(I_C_Invoice.Table_ID, Arrays.stream(processInfo.getIDs()).boxed().collect(Collectors.toList()), this.get_TrxName()).forEach(invoice -> {
                    documents.add((PO)invoice);
                    this.addToMessage(((MInvoice)invoice).getDocumentNo());
                });
                this.printDocument(documents, true);
            }
        }
        return "@Created@ " + documents.size() + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }
}

