/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.model.X_M_PriceList;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMAmortization;
import org.spin.model.MFMDunning;
import org.spin.model.MFMProduct;
import org.spin.model.MFMRate;
import org.spin.model.X_FM_Agreement;
import org.spin.model.X_FM_Product;
import org.spin.model.X_FM_Rate;
import org.spin.process.GenerateInvoiceFromLoanAbstract;

public class GenerateInvoiceFromLoan
extends GenerateInvoiceFromLoanAbstract {
    private List<MInvoice> invoiceList = new ArrayList<MInvoice>();
    private MInvoice invoice;
    private int precision;

    @Override
    protected String doIt() throws Exception {
        this.precision = MCurrency.getStdPrecision(this.getCtx(), Env.getContextAsInt(this.getCtx(), "#C_Currency_ID"));
        int n = 0;
        int n2 = 0;
        MFMAccount mFMAccount = null;
        PO pO = null;
        MBPartner mBPartner = null;
        MProduct mProduct = null;
        PO pO2 = null;
        MFMAmortization mFMAmortization = null;
        Object object = this.getSelectionKeys().iterator();
        while (object.hasNext()) {
            PO pO3;
            int n3 = object.next();
            MFMAmortization mFMAmortization2 = new MFMAmortization(this.getCtx(), n3, this.get_TrxName());
            BigDecimal serializable = this.getSelectionAsBigDecimal(n3, "LA_CapitalAmt");
            BigDecimal bigDecimal = this.getSelectionAsBigDecimal(n3, "LA_InterestAmt");
            BigDecimal bigDecimal2 = this.getSelectionAsBigDecimal(n3, "LA_CurrentDunningAmt");
            boolean bl = this.getSelectionAsBoolean(n3, "LA_IsDue");
            if (this.isSplitInvoices() || this.invoice == null) {
                this.invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
                if (mFMAccount == null) {
                    PO pO4;
                    mFMAccount = (MFMAccount)mFMAmortization2.getFM_Account();
                    pO = (MFMAgreement)mFMAccount.getFM_Agreement();
                    if (this.getParameterAsBoolean("IsPrepayment")) {
                        List<MFMAmortization> mCurrency = MFMAmortization.getToInvoiceList(mFMAccount.getFM_Account_ID(), this.get_TrxName());
                        if (mCurrency == null || mCurrency.isEmpty()) {
                            throw new AdempiereException("@LoanManagement.NoToInvoice@");
                        }
                        if (mCurrency.size() > this.getSelectionKeys().size()) {
                            throw new AdempiereException("@LoanManagement.AllFeesNotSelected@");
                        }
                    }
                    mFMAmortization = MFMAmortization.getLastAmortizationFromAccount(mFMAccount.getFM_Account_ID(), this.get_TrxName());
                    pO2 = MFMProduct.getById(this.getCtx(), ((X_FM_Agreement)pO).getFM_Product_ID(), this.get_TrxName());
                    mProduct = MProduct.get(this.getCtx(), ((X_FM_Product)pO2).getM_Product_ID());
                    mBPartner = MBPartner.get(this.getCtx(), ((X_FM_Agreement)pO).getC_BPartner_ID());
                    int string = pO2.get_ValueAsInt("FM_Rate_ID");
                    int n4 = pO2.get_ValueAsInt("DunningInterest_ID");
                    int n5 = pO2.get_ValueAsInt("FM_Dunning_ID");
                    if (n4 == 0 && n5 == 0) {
                        throw new AdempiereException("@FM_Dunning_ID@ @for@ @FM_Product_ID@ @NotFound@");
                    }
                    if (bigDecimal != null && string == 0) {
                        throw new AdempiereException("@FM_Rate_ID@ @for@ @Interest@ @NotFound@");
                    }
                    if (bigDecimal2 != null && n4 == 0 && n5 == 0) {
                        throw new AdempiereException("@DunningInterest_ID@ @NotFound@");
                    }
                    if (string != 0) {
                        pO4 = MFMRate.getById(this.getCtx(), string);
                        n = ((X_FM_Rate)pO4).getC_Charge_ID();
                    }
                    if (n4 != 0) {
                        pO4 = MFMRate.getById(this.getCtx(), n4);
                        n2 = ((X_FM_Rate)pO4).getC_Charge_ID();
                    } else if (n5 != 0) {
                        pO4 = MFMDunning.getById(this.getCtx(), n5);
                        n2 = ((MFMDunning)pO4).getChargeId();
                    }
                }
                this.invoice.setAD_Org_ID(pO.getAD_Org_ID());
                if (this.getDocTypeTargetId() != 0) {
                    this.invoice.setC_DocTypeTarget_ID(this.getDocTypeTargetId());
                } else {
                    this.invoice.setIsSOTrx(true);
                    this.invoice.setC_DocTypeTarget_ID();
                }
                this.invoice.setDateInvoiced(this.getDateInvoiced());
                this.invoice.setDateAcct(this.getDateInvoiced());
                this.invoice.setBPartner(mBPartner);
                if (pO.get_ValueAsInt("AD_User_ID") != 0) {
                    this.invoice.setAD_User_ID(pO.get_ValueAsInt("AD_User_ID"));
                }
                this.invoice.setDescription(Msg.parseTranslation(Env.getCtx(), "@Generate@ @from@ @Loan@") + " - " + ((X_FM_Agreement)pO).getDocumentNo());
                this.invoice.set_ValueOfColumn("FM_Account_ID", (Object)mFMAccount.getFM_Account_ID());
                MCurrency n7 = MCurrency.get(this.getCtx(), mFMAccount.getC_Currency_ID());
                pO3 = MPriceList.getDefault(this.getCtx(), true, n7.getISO_Code());
                if (pO3 == null) {
                    throw new AdempiereException("@M_PriceList_ID@ @NotFound@ @for@ " + n7.getISO_Code());
                }
                this.invoice.setM_PriceList_ID(((X_M_PriceList)pO3).getM_PriceList_ID());
                this.invoice.setC_ConversionType_ID(MConversionType.getDefault(this.getAD_Client_ID()));
                this.invoice.saveEx();
                this.invoiceList.add(this.invoice);
            }
            if (mProduct != null) {
                this.createLine(serializable, mProduct, 0, (MFMAgreement)pO, mFMAmortization2);
                String string = this.invoice.getDescription();
                string = string + Env.NL + Msg.getMsg(this.getCtx(), "Fee") + " " + mFMAmortization2.getPeriodNo() + (mFMAmortization != null ? "/" + mFMAmortization.getPeriodNo() : "");
                this.invoice.setDescription(string);
            }
            if (n != 0) {
                if (!bl && mFMAmortization2.getStartDate().after(this.getDateInvoiced()) && this.getParameterAsBoolean("IsPrepayment")) {
                    int n6 = pO2.get_ValueAsInt("PrepayFeeRate_ID");
                    if (n6 > 0) {
                        BigDecimal bigDecimal3;
                        pO3 = MFMRate.getById(this.getCtx(), n6);
                        if (pO3 != null && (bigDecimal3 = ((MFMRate)pO3).getValidRate(this.getDateInvoiced())) != null) {
                            bigDecimal = bigDecimal.multiply(bigDecimal3);
                            bigDecimal = bigDecimal.divide(Env.ONEHUNDRED);
                        }
                    } else {
                        bigDecimal = Env.ZERO;
                    }
                }
                this.createLine(bigDecimal, null, n, (MFMAgreement)pO, mFMAmortization2);
            }
            if (n2 == 0) continue;
            this.createLine(bigDecimal2, null, n2, (MFMAgreement)pO, mFMAmortization2);
        }
        this.completeInvoice();
        object = new StringBuffer("@Created@ (").append(this.invoiceList.size()).append(")");
        StringBuffer stringBuffer = new StringBuffer();
        for (MInvoice mInvoice : this.invoiceList) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(mInvoice.getDocumentNo());
        }
        if (stringBuffer.length() > 0) {
            ((StringBuffer)object).append("[").append(stringBuffer).append("]");
        }
        return ((StringBuffer)object).toString();
    }

    private void createLine(BigDecimal bigDecimal, MProduct mProduct, int n, MFMAgreement mFMAgreement, MFMAmortization mFMAmortization) {
        if (bigDecimal == null || bigDecimal.equals(Env.ZERO)) {
            return;
        }
        MInvoiceLine mInvoiceLine = new MInvoiceLine(this.invoice);
        if (mProduct != null) {
            mInvoiceLine.setProduct(mProduct);
        } else if (n != 0) {
            mInvoiceLine.setC_Charge_ID(n);
        }
        mInvoiceLine.setQty(Env.ONE);
        if (this.precision > 0) {
            bigDecimal.setScale(this.precision, 4);
        }
        mInvoiceLine.setPrice(bigDecimal);
        mInvoiceLine.setDescription(Msg.parseTranslation(Env.getCtx(), "@Generate@ @from@ @FM_Amortization_ID@ " + mFMAmortization.getPeriodNo() + " @of@ @Loan@ " + mFMAgreement.getDocumentNo()));
        mInvoiceLine.set_ValueOfColumn("FM_Amortization_ID", (Object)mFMAmortization.getFM_Amortization_ID());
        mInvoiceLine.saveEx();
    }

    private void completeInvoice() {
        for (MInvoice mInvoice : this.invoiceList) {
            mInvoice.setDocAction(this.getDocAction());
            if (!mInvoice.processIt(this.getDocAction())) {
                this.log.warning("completeInvoice - failed: " + mInvoice);
                this.addLog(Msg.getMsg(this.getCtx(), "Error") + mInvoice);
            } else {
                this.addLog("@C_Invoice_ID@ @Created@" + mInvoice.getDocumentNo());
            }
            mInvoice.saveEx();
        }
    }
}

