/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MColumn;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MTable;
import org.compiere.model.X_EXP_FormatLine;
import org.compiere.util.DisplayType;
import org.compiere.util.Util;
import org.spin.process.ExportFormatCreateFromTableAbstract;

public class ExportFormatCreateFromTable
extends ExportFormatCreateFromTableAbstract {
    private AtomicInteger created = new AtomicInteger();
    private AtomicInteger sequence = new AtomicInteger(10);
    private Map<Integer, MEXPFormat> exportFormatMap;

    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() != 0) {
            List<MEXPFormatLine> formatLines = MEXPFormat.get(this.getCtx(), this.getRecord_ID(), this.get_TrxName()).getFormatLines();
            if (this.isDeleteOld()) {
                MEXPFormat.get(this.getCtx(), this.getRecord_ID(), this.get_TrxName()).getFormatLines().forEach(formatLine -> formatLine.deleteEx(true));
            } else {
                formatLines.stream().sorted(Comparator.comparing(X_EXP_FormatLine::getPosition).reversed()).findFirst().ifPresent(formatLine -> this.sequence.set(formatLine.getPosition() + 10));
            }
            this.getSelectionKeys().forEach(columnId -> {
                MColumn selectedColumn = MColumn.get(this.getCtx(), columnId);
                if (!(DisplayType.isID(selectedColumn.getAD_Reference_ID()) || !this.isDeleteOld() && formatLines.stream().filter(formatLine -> formatLine.getAD_Column_ID() == selectedColumn.getAD_Column_ID()).findAny().isPresent())) {
                    MEXPFormatLine formatLine2 = new MEXPFormatLine(this.getCtx(), 0, this.get_TrxName());
                    formatLine2.setAD_Org_ID(0);
                    formatLine2.setEXP_Format_ID(this.getRecord_ID());
                    formatLine2.setPosition(this.sequence.getAndAdd(10));
                    formatLine2.setValue(selectedColumn.getColumnName());
                    formatLine2.setName(selectedColumn.getName());
                    formatLine2.setDescription(selectedColumn.getDescription());
                    formatLine2.setHelp(selectedColumn.getHelp());
                    formatLine2.setAD_Column_ID(selectedColumn.getAD_Column_ID());
                    if (selectedColumn.getColumnName().equals("UUID")) {
                        formatLine2.setIsPartUniqueIndex(true);
                        formatLine2.setIsMandatory(true);
                    } else {
                        formatLine2.setIsMandatory(selectedColumn.isMandatory());
                    }
                    formatLine2.saveEx();
                    this.created.getAndIncrement();
                }
            });
        } else {
            this.exportFormatMap = new LinkedHashMap<Integer, MEXPFormat>();
            this.getSelectionKeys().forEach(columnId -> {
                MColumn selectedColumn = MColumn.get(this.getCtx(), columnId);
                MEXPFormat exportFormat = this.exportFormatMap.get(selectedColumn.getAD_Table_ID());
                if (exportFormat == null) {
                    MTable table2 = MTable.get(this.getCtx(), selectedColumn.getAD_Table_ID());
                    exportFormat = new MEXPFormat(this.getCtx(), 0, this.get_TrxName());
                    exportFormat.setAD_Org_ID(0);
                    exportFormat.setAD_Table_ID(table2.getAD_Table_ID());
                    exportFormat.setValue(table2.getTableName() + (Util.isEmpty(this.getSuffix()) ? "" : "_" + this.getSuffix()));
                    exportFormat.setName(table2.getTableName() + (Util.isEmpty(this.getSuffix()) ? "" : "_" + this.getSuffix()));
                    exportFormat.setVersion(this.getVersion());
                    exportFormat.saveEx();
                    this.exportFormatMap.put(table2.getAD_Table_ID(), exportFormat);
                    this.created.getAndIncrement();
                }
                if (!DisplayType.isID(selectedColumn.getAD_Reference_ID())) {
                    MEXPFormatLine formatLine = new MEXPFormatLine(this.getCtx(), 0, this.get_TrxName());
                    formatLine.setAD_Org_ID(0);
                    formatLine.setEXP_Format_ID(exportFormat.getEXP_Format_ID());
                    formatLine.setPosition(this.sequence.getAndAdd(10));
                    formatLine.setValue(selectedColumn.getColumnName());
                    formatLine.setName(selectedColumn.getName());
                    formatLine.setDescription(selectedColumn.getDescription());
                    formatLine.setHelp(selectedColumn.getHelp());
                    formatLine.setAD_Column_ID(selectedColumn.getAD_Column_ID());
                    if (selectedColumn.getColumnName().equals("UUID")) {
                        formatLine.setIsPartUniqueIndex(true);
                        formatLine.setIsMandatory(true);
                    } else {
                        formatLine.setIsMandatory(selectedColumn.isMandatory());
                    }
                    formatLine.saveEx();
                }
            });
        }
        return "@Created@: " + this.created;
    }
}

