/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttribute;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MStore;
import org.compiere.model.MTaxCategory;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;
import org.spin.model.MADAppRegistration;
import org.spin.model.MWCategory;
import org.spin.process.ExportCatalogAbstract;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class ExportCatalog
extends ExportCatalogAbstract {
    private AtomicInteger created = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();
    private MStore store;
    private IECommerce ecommerceApi;

    @Override
    protected void prepare() {
        super.prepare();
        this.store = MStore.get(Env.getCtx(), this.getStoreId());
        if (this.store.get_ValueAsInt("CacheServerProvider_ID") <= 0) {
            throw new AdempiereException("@CacheServerProvider_ID@ @NotFound@");
        }
        try {
            MADAppRegistration registeredApplication = MADAppRegistration.getById(this.getCtx(), this.store.get_ValueAsInt("CacheServerProvider_ID"), this.get_TrxName());
            IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
            if (supportedApplication == null || !IECommerce.class.isAssignableFrom(supportedApplication.getClass())) {
                throw new AdempiereException("@CacheServerProvider_ID@ @Invalid@");
            }
            this.ecommerceApi = (IECommerce)((Object)supportedApplication);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    @Override
    protected String doIt() throws Exception {
        try {
            Timestamp validFrom;
            MPriceList priceList;
            MPriceListVersion priceListVersion;
            this.ecommerceApi.connect();
            if (this.isExportProduct() && this.store.getM_PriceList_ID() > 0 && (priceListVersion = (priceList = MPriceList.get(this.getCtx(), this.store.getM_PriceList_ID(), this.get_TrxName())).getPriceListVersion(validFrom = TimeUtil.getDay(System.currentTimeMillis()))) != null) {
                AtomicInteger productCounter = new AtomicInteger();
                KeyNamePair[] productArray = DB.getKeyNamePairs("SELECT M_Product_ID, Name FROM M_Product WHERE AD_Client_ID = ? AND IsActive = 'Y' AND IsWebStoreFeatured = 'Y' AND EXISTS(SELECT 1 FROM M_ProductPrice pp WHERE pp.M_Product_ID = M_Product.M_Product_ID AND pp.M_PriceList_Version_ID = ?)", false, this.getAD_Client_ID(), priceListVersion.getM_PriceList_Version_ID());
                Arrays.asList(productArray).forEach(productPair -> {
                    try {
                        MProduct product = MProduct.get(this.getCtx(), productPair.getKey());
                        this.exportEntity(product);
                        this.addLog(productPair.getName() + ": @Ok@");
                        productCounter.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception e) {
                        this.log.warning("Error: " + e.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + productPair.getName() + ": " + e.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@M_Product_ID@: " + productCounter.get());
            }
            if (this.isExportProductCategory()) {
                AtomicInteger categoryCounter = new AtomicInteger();
                KeyNamePair[] categoryArray = DB.getKeyNamePairs("SELECT W_Category_ID, Name FROM W_Category WHERE AD_Client_ID = ? AND IsActive = 'Y'", false, this.getAD_Client_ID());
                Arrays.asList(categoryArray).forEach(categoryPair -> {
                    try {
                        MWCategory category = MWCategory.getById(this.getCtx(), categoryPair.getKey(), this.get_TrxName());
                        this.exportEntity(category);
                        this.addLog(categoryPair.getName() + ": @Ok@");
                        categoryCounter.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception e) {
                        this.log.warning("Error: " + e.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + categoryPair.getName() + ": " + e.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@W_Category_ID@: " + categoryCounter);
            }
            if (this.isExportProductAttribute()) {
                AtomicInteger attributeCounter = new AtomicInteger();
                KeyNamePair[] attributeArray = DB.getKeyNamePairs("SELECT M_Attribute_ID, Name FROM M_Attribute WHERE AD_Client_ID = ? AND IsActive = 'Y' AND EXISTS(SELECT 1 FROM M_AttributeValue av WHERE av.M_Attribute_ID = M_Attribute.M_Attribute_ID)", false, this.getAD_Client_ID());
                Arrays.asList(attributeArray).forEach(attributePair -> {
                    try {
                        MAttribute attribute = new MAttribute(this.getCtx(), attributePair.getKey(), this.get_TrxName());
                        this.exportEntity(attribute);
                        this.addLog(attributePair.getName() + ": @Ok@");
                        attributeCounter.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception e) {
                        this.log.warning("Error: " + e.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + attributePair.getName() + ": " + e.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@M_AttributeSet_ID@: " + attributeCounter);
            }
            if (this.isExportTax()) {
                AtomicInteger taxCategoryCounter = new AtomicInteger();
                KeyNamePair[] taxCategoryArray = DB.getKeyNamePairs("SELECT C_TaxCategory_ID, Name FROM C_TaxCategory WHERE AD_Client_ID = ? AND IsActive = 'Y' AND EXISTS(SELECT 1 FROM C_Tax t WHERE t.C_TaxCategory_ID = C_TaxCategory.C_TaxCategory_ID AND (t.IsSalesTax = 'Y' OR t.SOPOType IN('S', 'B')))", false, this.getAD_Client_ID());
                Arrays.asList(taxCategoryArray).forEach(taxCategoryPair -> {
                    try {
                        MTaxCategory taxCategory = new MTaxCategory(this.getCtx(), taxCategoryPair.getKey(), this.get_TrxName());
                        this.exportEntity(taxCategory);
                        this.addLog(taxCategoryPair.getName() + ": @Ok@");
                        taxCategoryCounter.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception e) {
                        this.log.warning("Error: " + e.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + taxCategoryPair.getName() + ": " + e.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@C_TaxCategory_ID@: " + taxCategoryCounter);
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
        finally {
            this.ecommerceApi.close();
        }
        return "@Created@: " + this.created.get() + " - @Errors@: " + this.errors.get();
    }

    private void exportEntity(PO entity) throws Exception {
        IECommerceEntity wrapper = this.ecommerceApi.getPersistenceWrapper(entity);
        if (wrapper == null) {
            return;
        }
        this.ecommerceApi.create(wrapper.withWebStoreId(this.store.getW_Store_ID()));
    }
}

