/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.model.MHRLeave;
import org.eevolution.model.MHRLeaveAssign;
import org.eevolution.model.MHRLeaveReason;
import org.eevolution.model.MHRLeaveType;
import org.spin.process.CreateRepeatedLeaveAbstract;
import org.spin.util.TNAUtil;

public class CreateRepeatedLeave
extends CreateRepeatedLeaveAbstract {
    private int created = 0;

    @Override
    protected String doIt() throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer("IsLeaveRepeated").append(" = ").append(" ?");
        arrayList.add(true);
        if (this.getLeaveTypeId() > 0) {
            arrayList.add(this.getLeaveTypeId());
            stringBuffer.append(" AND ").append("HR_LeaveType_ID").append(" = ").append(" ?");
        }
        if (this.getLeaveReasonId() == 0) {
            MHRLeaveReason mHRLeaveReason = (MHRLeaveReason)new Query(this.getCtx(), "HR_LeaveReason", null, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).first();
            if (mHRLeaveReason == null) {
                throw new AdempiereException("@HR_LeaveReason_ID@ @NotFound@");
            }
            this.setLeaveReasonId(mHRLeaveReason.getHR_LeaveReason_ID());
        }
        new Query(this.getCtx(), "HR_LeaveType", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setClient_ID().setOnlyActiveRecords(true).list().forEach(mHRLeaveType -> this.processLeaveType((MHRLeaveType)mHRLeaveType));
        return "@Created@: " + this.created;
    }

    private void processLeaveType(MHRLeaveType mHRLeaveType) {
        BigDecimal bigDecimal;
        String string = TNAUtil.getDurationUnitFromFrequencyType(mHRLeaveType.getFrequencyType());
        if (Util.isEmpty(string)) {
            return;
        }
        if (string.equals("h")) {
            string = "D";
        }
        if ((bigDecimal = mHRLeaveType.getLeaveDurationTime()) == null || bigDecimal.compareTo(Env.ZERO) <= 0) {
            bigDecimal = Env.ONE;
        }
        List list = new Query(this.getCtx(), "HR_LeaveAssign", "HR_LeaveType_ID = ? AND ValidFrom <= ? AND (ValidTo >= ? OR ValidTo IS NULL) AND (DateLastRun < ? OR DateLastRun IS NULL)", this.get_TrxName()).setParameters(mHRLeaveType.getHR_LeaveType_ID(), this.getDateDoc(), this.getDateDoc(), this.getDateDoc()).setClient_ID().setOnlyActiveRecords(true).list();
        for (MHRLeaveAssign mHRLeaveAssign : list) {
            Timestamp timestamp;
            Timestamp timestamp2 = mHRLeaveAssign.getDateLastRun();
            if (timestamp2 == null) {
                timestamp2 = mHRLeaveAssign.getValidFrom();
            }
            if (!TimeUtil.isSameDay(timestamp = TimeUtil.addDuration(timestamp2 = TimeUtil.getDay(timestamp2), string, bigDecimal), this.getDateDoc())) continue;
            MHRLeave mHRLeave = new MHRLeave(this.getCtx(), 0, this.get_TrxName());
            mHRLeave.setHR_LeaveType_ID(mHRLeaveType.getHR_LeaveType_ID());
            mHRLeave.setHR_LeaveAssign_ID(mHRLeaveAssign.getHR_LeaveAssign_ID());
            mHRLeave.setHR_LeaveReason_ID(this.getLeaveReasonId());
            mHRLeave.setDateDoc(this.getDateDoc());
            mHRLeave.setC_BPartner_ID(mHRLeaveAssign.getC_BPartner_ID());
            mHRLeave.saveEx();
            if (!mHRLeave.processIt("PR")) {
                throw new AdempiereException(mHRLeave.getProcessMsg());
            }
            mHRLeave.saveEx();
            this.addLog("@HR_Leave_ID@ " + mHRLeave.getDocumentNo() + " @DateDoc@: " + DisplayType.getDateFormat(15).format(mHRLeave.getDateDoc()));
            mHRLeaveAssign.setDateLastRun(mHRLeave.getEndDate());
            mHRLeaveAssign.saveEx();
            ++this.created;
        }
    }
}

