/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.adempiere.model.X_AD_Browse_Access;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessAccess;
import org.compiere.model.Query;
import org.spin.process.CopyBrowserFromRoleAbstract;

public class CopyBrowserFromRole
extends CopyBrowserFromRoleAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@AD_Role_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        AtomicInteger browserAdded = new AtomicInteger(0);
        AtomicInteger processAdded = new AtomicInteger(0);
        this.getSelectionKeys().stream().filter(browserId -> browserId > 0).filter(browserId -> !this.isExistsBrowser((int)browserId)).forEach(browserId -> {
            MProcess process;
            MBrowse browser = MBrowse.get(this.getCtx(), browserId);
            this.addBrowsserAccess(browser, browserAdded);
            if (this.isDependentEntities() && !this.isExistsProcess((process = MProcess.get(this.getCtx(), browser.getAD_Process_ID())).getAD_Process_ID())) {
                this.addProcessAccess(process, processAdded);
            }
        });
        return "@AD_Browse_ID@ @Added@ " + browserAdded.get() + ", @AD_Process_ID@ @Added@ " + processAdded.get();
    }

    private void addBrowsserAccess(MBrowse browser, AtomicInteger browserAdded) {
        Optional.ofNullable(browser).ifPresent(windowToAdd -> {
            X_AD_Browse_Access access = new X_AD_Browse_Access(this.getCtx(), 0, this.get_TrxName());
            access.setAD_Role_ID(this.getRecord_ID());
            access.setAD_Browse_ID(browser.getAD_Browse_ID());
            access.setIsReadWrite(this.isReadWrite());
            access.saveEx();
            browserAdded.getAndAdd(1);
        });
    }

    private void addProcessAccess(MProcess process, AtomicInteger processAdded) {
        Optional.ofNullable(process).ifPresent(processToAdd -> {
            MProcessAccess access = new MProcessAccess((MProcess)processToAdd, this.getRecord_ID());
            access.setIsReadWrite(this.isReadWrite());
            access.saveEx();
            processAdded.getAndAdd(1);
        });
    }

    private boolean isExistsBrowser(int windowId) {
        return new Query(this.getCtx(), "AD_Browse_Access", "AD_Browse_ID = ? AND AD_Role_ID= ?", this.get_TrxName()).setParameters(windowId, this.getRecord_ID()).match();
    }

    private boolean isExistsProcess(int windowId) {
        return new Query(this.getCtx(), "AD_Process_Access", "AD_Process_ID = ? AND AD_Role_ID= ?", this.get_TrxName()).setParameters(windowId, this.getRecord_ID()).match();
    }
}

