/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.List;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTabCustom;
import org.compiere.model.MTable;
import org.compiere.model.MWindowCustom;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.process.ASPCopyFromTab;
import org.spin.process.ASPCopyFromWindowAbstract;

public class ASPCopyFromWindow
extends ASPCopyFromWindowAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@AD_WindowCustom_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        MWindowCustom fromCustomWindow = new MWindowCustom(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        MWindowCustom toCustomWindow = new MWindowCustom(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues(fromCustomWindow, toCustomWindow, true);
        toCustomWindow.setASP_Level_ID(this.getLevelId());
        toCustomWindow.saveEx();
        List<MTabCustom> sourceTabs = fromCustomWindow.getTabs();
        toCustomWindow.getTabs().forEach(targetTab -> {
            Optional<MTabCustom> maybeSourceTab = sourceTabs.stream().filter(sourceTab -> sourceTab.getAD_Tab_ID() == targetTab.getAD_Tab_ID()).findFirst();
            if (maybeSourceTab.isPresent()) {
                ProcessBuilder.create(this.getCtx()).process(ASPCopyFromTab.getProcessId()).withoutTransactionClose().withRecordId(MTabCustom.Table_ID, targetTab.getAD_TabCustom_ID()).withParameter("AD_TabCustom_ID", maybeSourceTab.get().getAD_TabCustom_ID()).execute(this.get_TrxName());
            } else {
                targetTab.setIsActive(false);
                targetTab.saveEx();
            }
        });
        this.copyTranslation(fromCustomWindow, toCustomWindow);
        return "Ok";
    }

    private void copyTranslation(PO source, PO target) {
        String tableName = source.get_TableName() + "_Trl";
        MTable.get(this.getCtx(), source.get_Table_ID()).getColumnsAsList().stream().filter(column -> column.isTranslated()).findAny().ifPresent(column -> new Query(this.getCtx(), tableName, source.get_KeyColumns()[0] + " = ?", this.get_TrxName()).setParameters(source.get_ID()).list().forEach(sourceTranslation -> new Query(this.getCtx(), tableName, target.get_KeyColumns()[0] + " = ? AND AD_Language = ?", this.get_TrxName()).setParameters(target.get_ID(), sourceTranslation.get_ValueAsString("AD_Language")).list().forEach(targetTranslation -> {
            MTable.get(this.getCtx(), source.get_Table_ID()).getColumnsAsList().stream().filter(translatedColumn -> translatedColumn.isTranslated()).forEach(translatedColumn -> targetTranslation.set_ValueOfColumn(translatedColumn.getColumnName(), sourceTranslation.get_Value(translatedColumn.getColumnName())));
            targetTranslation.saveEx();
        })));
    }
}

