/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_Role;
import org.compiere.model.I_AD_User;
import org.compiere.model.I_ASP_Level;
import org.compiere.model.MBrowseCustom;
import org.compiere.model.MBrowseFieldCustom;
import org.compiere.model.PO;
import org.spin.process.ASPCopyBrowserFromAbstract;

public class ASPCopyBrowserFrom
extends ASPCopyBrowserFromAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        AtomicInteger counter = new AtomicInteger(0);
        this.getSelectionKeys().forEach(customBrowseId -> {
            MBrowseCustom fromCustomBrowse = new MBrowseCustom(this.getCtx(), (int)customBrowseId, this.get_TrxName());
            MBrowseCustom toCustomBrowse = new MBrowseCustom(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromCustomBrowse, toCustomBrowse);
            if (this.getTable_ID() == I_ASP_Level.Table_ID) {
                toCustomBrowse.setASP_Level_ID(this.getRecord_ID());
            } else if (this.getTable_ID() == I_AD_Role.Table_ID) {
                toCustomBrowse.setAD_Role_ID(this.getRecord_ID());
            } else if (this.getTable_ID() == I_AD_User.Table_ID) {
                toCustomBrowse.setAD_User_ID(this.getRecord_ID());
            }
            toCustomBrowse.saveEx();
            List<MBrowseFieldCustom> fromFieldList = fromCustomBrowse.getFields();
            List<MBrowseFieldCustom> toFieldList = toCustomBrowse.getFields();
            if (fromFieldList != null && fromFieldList.size() != 0) {
                toFieldList.forEach(parameter -> {
                    parameter.setIsDisplayed(false);
                    parameter.saveEx();
                });
                fromFieldList.forEach(fromField -> {
                    Optional<MBrowseFieldCustom> maybeCustomField = toFieldList.stream().filter(toField -> toField.getAD_Browse_Field_ID() == fromField.getAD_Browse_Field_ID()).findFirst();
                    if (maybeCustomField.isPresent()) {
                        MBrowseFieldCustom fieldToOverwrite = maybeCustomField.get();
                        fieldToOverwrite.overwriteValuesFromCustomField((MBrowseFieldCustom)fromField);
                        fieldToOverwrite.saveEx();
                        counter.incrementAndGet();
                    }
                });
            }
        });
        return "@Update@: " + counter.get();
    }
}

