/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pq.pos;

import java.util.Arrays;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.service.CPOS;
import org.adempiere.pos.util.POSTicketHandler;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.PO;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.model.MADAppRegistration;
import org.spin.pq.support.IPrintQueue;
import org.spin.pq.util.PrintQueueUtil;
import org.spin.process.InvoiceFiscalPrint;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class DefaultPrintTicketHandler
extends POSTicketHandler {
    public DefaultPrintTicketHandler(CPOS pos) {
        super(pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void printTicket() {
        MOrder order = this.getPOS().getOrder();
        if (!this.getPOS().isInvoiced()) {
            MDocType documentType = MDocType.get(order.getCtx(), order.getC_DocTypeTarget_ID());
            if (documentType.get_ValueAsBoolean("IsPrintedOnPrintQueue") && !documentType.get_ValueAsBoolean("IsPrintedOnQueueAfterComplete") && documentType.getAD_PrintFormat_ID() > 0 && documentType.get_ValueAsInt("PrintQueue_ID") > 0) {
                try {
                    MADAppRegistration registeredApplication = MADAppRegistration.getById(Env.getCtx(), documentType.get_ValueAsInt("PrintQueue_ID"), order.get_TrxName());
                    IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
                    if (supportedApplication == null || !IPrintQueue.class.isAssignableFrom(supportedApplication.getClass())) return;
                    IPrintQueue printQueue = (IPrintQueue)supportedApplication;
                    ReportEngine reportEngine = ReportEngine.get(this.getPOS().getCtx(), 0, order.getC_Order_ID(), order.get_TrxName());
                    printQueue.printDocument(reportEngine.getName(), reportEngine.createPDFData());
                    return;
                }
                catch (Exception e) {
                    throw new AdempiereException(e);
                }
            } else {
                ProcessInfo info = new ProcessInfo(null, 0);
                info.setTransactionName(this.getPOS().get_TrxName());
                ReportCtl.startDocumentPrint(0, null, this.getPOS().getC_Order_ID(), null, this.getPOS().getWindowNo(), false, null, info);
            }
            return;
        } else {
            Arrays.asList(order.getInvoices()).forEach(invoice -> {
                MDocType documentType = MDocType.get(order.getCtx(), invoice.getC_DocTypeTarget_ID());
                if (documentType.get_ValueAsBoolean("IsPrintedOnPrintQueue") && !documentType.get_ValueAsBoolean("IsPrintedOnQueueAfterComplete") && documentType.getAD_PrintFormat_ID() > 0 && documentType.get_ValueAsInt("PrintQueue_ID") > 0) {
                    PrintQueueUtil.sendDocumentToQueue((PO)invoice, (int)documentType.getAD_PrintFormat_ID(), (int)documentType.get_ValueAsInt("PrintQueue_ID"));
                } else if (documentType.get_ValueAsBoolean("IsPrintedOnFiscalPrinter") && !documentType.get_ValueAsBoolean("IsPrintAfterComplete")) {
                    int fiscalPrinterId = this.getPOS().getM_POS().get_ValueAsInt("FiscalPrinter_ID");
                    ProcessInfo processInfo = ProcessBuilder.create(invoice.getCtx()).process(InvoiceFiscalPrint.getProcessId()).withParameter("FiscalPrinter_ID", fiscalPrinterId).withRecordId(MInvoice.Table_ID, invoice.getC_Invoice_ID()).execute(invoice.get_TrxName());
                    if (processInfo.isError()) {
                        throw new AdempierePOSException(processInfo.getSummary());
                    }
                }
            });
        }
    }

    @Override
    public void openDrawer() {
    }

    @Override
    public void showMessage(String message) {
    }
}

