/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model.validator;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MStore;
import org.compiere.model.MUser;
import org.compiere.model.MUserRoles;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_W_Basket;
import org.compiere.model.X_W_BasketLine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.util.VueStoreFrontUtil;

public class VueStoreFront
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(VueStoreFront.class);
    private int clientId = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("AD_User", this);
        engine.addModelChange("W_Basket", this);
        engine.addModelChange("W_BasketLine", this);
    }

    @Override
    public int getAD_Client_ID() {
        return this.clientId;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        if (type == 1) {
            MUser user;
            if (po.get_TableName().equals("W_BasketLine")) {
                X_W_BasketLine basketLine = (X_W_BasketLine)po;
                VueStoreFrontUtil.setBasketLineDefaultValues(basketLine);
            } else if (po instanceof MUser && (user = (MUser)po).isWebstoreUser()) {
                MStore defaultStore = VueStoreFrontUtil.getDefaultStore(Env.getAD_Org_ID(Env.getCtx()));
                if (defaultStore == null) {
                    throw new AdempiereException("@W_Store_ID@ @NotFound@");
                }
                MBPartner customer = VueStoreFrontUtil.getTemplate(user.getCtx(), defaultStore.get_ValueAsInt("C_TemplateBPartner_ID"), user.get_TrxName());
                customer.setValue(user.getEMail());
                customer.setTaxID(user.getEMail());
                customer.setName(user.getName());
                customer.saveEx();
                user.setC_BPartner_ID(customer.getC_BPartner_ID());
            }
        } else if (type == 2) {
            X_W_BasketLine basketLine;
            if (po.get_TableName().equals("W_BasketLine") && ((basketLine = (X_W_BasketLine)po).is_ValueChanged("Qty") || basketLine.is_ValueChanged("Price"))) {
                VueStoreFrontUtil.setBasketLineDefaultValues(basketLine);
            }
        } else if (type == 4) {
            MUser user;
            if (po instanceof MUser && (user = (MUser)po).isWebstoreUser()) {
                MStore defaultStore = VueStoreFrontUtil.getDefaultStore(Env.getAD_Org_ID(Env.getCtx()));
                if (defaultStore == null) {
                    throw new AdempiereException("@W_Store_ID@ @NotFound@");
                }
                int defaultRoleId = defaultStore.get_ValueAsInt("CustomerRole_ID");
                if (defaultRoleId <= 0) {
                    throw new AdempiereException("@CustomerRole_ID@ @NotFound@");
                }
                new MUserRoles(user.getCtx(), user.getAD_User_ID(), defaultRoleId, user.get_TrxName()).saveEx();
                if (user.getC_BPartner_ID() <= 0) {
                    MBPartner customer = VueStoreFrontUtil.getTemplate(user.getCtx(), defaultStore.get_ValueAsInt("C_TemplateBPartner_ID"), user.get_TrxName());
                    customer.setValue(user.getEMail());
                    customer.setTaxID(user.getEMail());
                    customer.setName(user.getName());
                    customer.saveEx();
                    user.setC_BPartner_ID(customer.getC_BPartner_ID());
                }
            }
        } else if (type == 5) {
            if (po.get_TableName().equals("W_Basket")) {
                X_W_Basket basket = (X_W_Basket)po;
                VueStoreFrontUtil.deletePackageFromBasket(basket.getCtx(), basket.getW_Basket_ID(), basket.get_TrxName());
            } else if (po.get_TableName().equals("W_BasketLine")) {
                X_W_BasketLine basketLine = (X_W_BasketLine)po;
                VueStoreFrontUtil.deletePackageLineFromBasketLine(basketLine.getCtx(), basketLine.getW_BasketLine_ID(), basketLine.get_TrxName());
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        return null;
    }
}

