/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.spin.model.MFMAccount;
import org.spin.model.MFMTransaction;
import org.spin.model.X_FM_Batch;

public class MFMBatch
extends X_FM_Batch
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20180228L;
    private List<MFMTransaction> lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MFMBatch(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MFMBatch(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), mDocType.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String string;
        if (!this.m_justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        this.updateHeader();
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void updateHeader() {
        BigDecimal bigDecimal = Env.ZERO;
        for (MFMTransaction mFMTransaction : this.getLines(true)) {
            bigDecimal = bigDecimal.add(mFMTransaction.getAmount());
        }
        this.setTotalAmt(bigDecimal);
        this.saveEx();
    }

    private void setDefiniteDocumentNo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (mDocType.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (mDocType.isOverwriteSeqOnComplete()) {
            String string = null;
            int n = this.p_info.getColumnIndex("C_DocType_ID");
            if (n == -1) {
                n = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (n != -1) {
                string = DB.getDocumentNo(this.get_ValueAsInt(n), this.get_TrxName(), true);
            }
            if (string != null) {
                this.setDocumentNo(string);
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        if (this.getDocStatus().equals("DR")) {
            this.setProcessed(true);
            this.setProcessing(false);
            this.setDocAction("--");
            return true;
        }
        return this.reverseCorrectIt();
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MFMBatch mFMBatch = this.reverseIt(false);
        if (mFMBatch == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        MFMBatch mFMBatch = this.reverseIt(true);
        if (mFMBatch == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.setProcessed(false);
        return this.reverseCorrectIt();
    }

    @Override
    public void setProcessed(boolean bl) {
        super.setProcessed(bl);
        DB.executeUpdate("UPDATE FM_Transaction SET Processed = " + (bl ? "'Y'" : "'N'") + " WHERE FM_Batch_ID = ?", this.getFM_Batch_ID(), this.get_TrxName());
    }

    public MFMBatch reverseIt(boolean bl) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> optional = Optional.of(Env.getContextAsDate(this.getCtx(), "#Date"));
        Timestamp timestamp2 = bl ? optional.orElse(timestamp) : this.getDateDoc();
        MPeriod.testPeriodOpen(this.getCtx(), timestamp2, this.getC_DocType_ID(), this.getAD_Org_ID());
        MFMBatch mFMBatch = MFMBatch.copyFrom(this, this.getDateDoc(), this.getC_DocType_ID());
        if (mFMBatch == null) {
            return null;
        }
        mFMBatch.setReversal_ID(this.getFM_Batch_ID());
        mFMBatch.setProcessing(false);
        mFMBatch.setDocStatus("RE");
        mFMBatch.setDocAction("--");
        mFMBatch.updateHeader();
        mFMBatch.setProcessed(true);
        mFMBatch.setProcessing(false);
        mFMBatch.setPosted(false);
        mFMBatch.saveEx(this.get_TrxName());
        this.setReversal_ID(mFMBatch.getFM_Batch_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.setProcessed(true);
        this.setDocAction("--");
        this.saveEx();
        return mFMBatch;
    }

    public static MFMBatch copyFrom(MFMBatch mFMBatch, Timestamp timestamp, int n) {
        MFMBatch mFMBatch2 = new MFMBatch(mFMBatch.getCtx(), 0, mFMBatch.get_TrxName());
        PO.copyValues(mFMBatch, mFMBatch2, mFMBatch.getAD_Client_ID(), mFMBatch.getAD_Org_ID());
        mFMBatch2.set_ValueNoCheck("DocumentNo", null);
        mFMBatch2.setDocStatus("DR");
        mFMBatch2.setDocAction("CO");
        mFMBatch2.setC_DocType_ID(n);
        mFMBatch2.setPosted(false);
        mFMBatch2.setProcessed(false);
        mFMBatch2.setProcessing(false);
        mFMBatch2.saveEx();
        mFMBatch2.copyLinesFrom(mFMBatch);
        return mFMBatch2;
    }

    public int copyLinesFrom(MFMBatch mFMBatch) {
        if (this.isProcessed() || mFMBatch == null) {
            return 0;
        }
        List<MFMTransaction> list = mFMBatch.getLines(false);
        for (MFMTransaction mFMTransaction : list) {
            MFMTransaction mFMTransaction2 = new MFMTransaction(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(mFMTransaction, mFMTransaction2, mFMTransaction.getAD_Client_ID(), mFMTransaction.getAD_Org_ID());
            mFMTransaction2.setFM_Batch_ID(this.getFM_Batch_ID());
            mFMTransaction2.setAmount(mFMTransaction.getAmount().negate());
            mFMTransaction2.setProcessed(false);
            mFMTransaction2.saveEx();
        }
        return list.size();
    }

    public List<MFMTransaction> getLines(boolean bl) {
        if (bl || this.lines == null) {
            this.lines = new Query(this.getCtx(), "FM_Transaction", "FM_Batch_ID=" + this.getFM_Batch_ID(), this.get_TrxName()).list();
        }
        return this.lines;
    }

    public List<MFMTransaction> getLines() {
        return this.getLines(false);
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    public void setC_DocType_ID() {
        int n = MDocType.getDocType("FMB");
        if (n <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", DocBaseTypeType=FMB");
        } else {
            this.log.fine("(SO) - FMB");
            this.setC_DocType_ID(n);
        }
    }

    public MFMTransaction addTransaction(int n, BigDecimal bigDecimal) {
        return this.addTransaction(n, 0, 0, bigDecimal);
    }

    public MFMTransaction addTransaction(int n, int n2, int n3, BigDecimal bigDecimal) {
        if (n <= 0) {
            return null;
        }
        MFMTransaction mFMTransaction = new MFMTransaction(this);
        mFMTransaction.setFM_TransactionType_ID(n);
        MFMAccount mFMAccount = MFMAccount.getById(this.getCtx(), this.getFM_Account_ID(), this.get_TrxName());
        MCurrency mCurrency = MCurrency.get(this.getCtx(), mFMAccount.getC_Currency_ID());
        if (mCurrency.getC_Currency_ID() != n2 && n2 > 0) {
            int n4 = MConversionRate.getConversionRateId(n2, mCurrency.getC_Currency_ID(), this.getDateAcct(), n3, this.getAD_Client_ID(), this.getAD_Org_ID());
            if (n4 <= 0) {
                throw new AdempiereException(MConversionRate.getErrorMessage(this.getCtx(), "ErrorConvertingDocumentCurrencyToBaseCurrency", n2, mFMAccount.getC_Currency_ID(), n3, this.getDateAcct(), this.get_TrxName()));
            }
            BigDecimal bigDecimal2 = MConversionRate.getRate(this.getCtx(), n4);
            bigDecimal = bigDecimal.multiply(bigDecimal2);
        }
        mFMTransaction.setAmount(bigDecimal.setScale(mCurrency.getStdPrecision(), 4));
        mFMTransaction.saveEx();
        return mFMTransaction;
    }

    @Override
    public int customizeValidActions(String string, Object object, String string2, String string3, int n, String[] stringArray, String[] stringArray2, int n2) {
        if (n == Table_ID) {
            if (string.equals("DR") || string.equals("IP") || string.equals("IN")) {
                stringArray2[n2++] = "PR";
            } else if (string.equals("CO")) {
                stringArray2[n2++] = "RA";
                stringArray2[n2++] = "RC";
            }
        }
        return n2;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MFMBatch[").append(this.getSummary()).append("]");
        return stringBuffer.toString();
    }
}

