/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MFMAccount;
import org.spin.model.X_FM_Amortization;
import org.spin.model.X_I_FM_Agreement;

public class MFMAmortization
extends X_FM_Amortization {
    private static final long serialVersionUID = 1L;

    public MFMAmortization(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MFMAmortization(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MFMAmortization(X_I_FM_Agreement x_I_FM_Agreement) {
        super(x_I_FM_Agreement.getCtx(), x_I_FM_Agreement.get_ValueAsInt("FM_Amortization_ID"), x_I_FM_Agreement.get_TrxName());
        this.setPeriodNo(x_I_FM_Agreement.get_ValueAsInt("PeriodNo"));
        if (x_I_FM_Agreement.get_Value("DueDate") != null) {
            this.setDueDate((Timestamp)x_I_FM_Agreement.get_Value("DueDate"));
        }
        if (x_I_FM_Agreement.get_Value("ValidFrom") != null) {
            this.setStartDate((Timestamp)x_I_FM_Agreement.get_Value("ValidFrom"));
        } else {
            this.setStartDate((Timestamp)x_I_FM_Agreement.get_Value("DateDoc"));
        }
        if (x_I_FM_Agreement.get_Value("EndDate") != null) {
            this.setEndDate((Timestamp)x_I_FM_Agreement.get_Value("EndDate"));
        } else {
            this.setEndDate((Timestamp)x_I_FM_Agreement.get_Value("DateDoc"));
        }
        if (x_I_FM_Agreement.get_Value("CapitalAmt") != null) {
            this.setCapitalAmt((BigDecimal)x_I_FM_Agreement.get_Value("CapitalAmt"));
        }
        if (x_I_FM_Agreement.get_Value("InterestAmt") != null) {
            this.setInterestAmt((BigDecimal)x_I_FM_Agreement.get_Value("InterestAmt"));
        }
        if (x_I_FM_Agreement.get_Value("TaxAmt") != null) {
            this.setTaxAmt((BigDecimal)x_I_FM_Agreement.get_Value("TaxAmt"));
        }
        this.setFM_Account_ID(x_I_FM_Agreement.getFM_Account_ID());
        if (x_I_FM_Agreement.get_Value("IsPaid") != null) {
            this.setIsPaid(x_I_FM_Agreement.get_ValueAsBoolean("IsPaid"));
        }
    }

    public static int deleteForAccount(MFMAccount mFMAccount) {
        return DB.executeUpdate("DELETE FROM FM_Amortization WHERE FM_Account_ID = ? AND IsPaid = 'N'", mFMAccount.getFM_Account_ID(), mFMAccount.get_TrxName());
    }

    public static boolean createAmortization(Properties properties, BigDecimal bigDecimal, String string, Timestamp timestamp, Timestamp timestamp2, int n, BigDecimal bigDecimal2, int n2, Timestamp timestamp3, BigDecimal bigDecimal3, String string2) {
        MFMAmortization mFMAmortization = new MFMAmortization(properties, 0, string2);
        mFMAmortization.setCapitalAmt(bigDecimal);
        mFMAmortization.setDescription(string);
        mFMAmortization.setDueDate(timestamp);
        mFMAmortization.setEndDate(timestamp2);
        mFMAmortization.setFM_Account_ID(n);
        mFMAmortization.setInterestAmt(bigDecimal2);
        mFMAmortization.setPeriodNo(n2);
        mFMAmortization.setStartDate(timestamp3);
        mFMAmortization.setTaxAmt(bigDecimal3);
        mFMAmortization.saveEx(string2);
        return true;
    }

    public static boolean checkAccount(MFMAccount mFMAccount) {
        return new Query(mFMAccount.getCtx(), "FM_Amortization", "FM_Account_ID = ? AND IsPaid = 'Y'", mFMAccount.get_TrxName()).setParameters(mFMAccount.getFM_Account_ID()).match();
    }

    public static List<MFMAmortization> getFromAccount(int n, String string) {
        return new Query(Env.getCtx(), "FM_Amortization", "FM_Account_ID = ?", string).setParameters(n).list();
    }

    public static List<MFMAmortization> getOpenFromAccount(int n, String string) {
        return new Query(Env.getCtx(), "FM_Amortization", "FM_Account_ID = ? AND IsInvoiced = 'N' AND IsPaid = 'N'", string).setParameters(n).list();
    }

    public static MFMAmortization getLastAmortizationFromAccount(int n, String string) {
        return (MFMAmortization)new Query(Env.getCtx(), "FM_Amortization", "FM_Account_ID = ?", string).setParameters(n).setOrderBy("PeriodNo DESC").first();
    }

    public static List<MFMAmortization> getAmortizationList(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("FM_Account_ID = ?");
        if (!Util.isEmpty(string)) {
            stringBuffer.append(" AND ").append(string);
        }
        return new Query(Env.getCtx(), "FM_Amortization", stringBuffer.toString(), string2).setParameters(n).setOrderBy("PeriodNo").list();
    }

    public static List<MFMAmortization> getToInvoiceList(int n, String string) {
        return MFMAmortization.getAmortizationList(n, "IsInvoiced = 'N'", string);
    }

    public static List<MFMAmortization> getToPayList(int n, String string) {
        return MFMAmortization.getAmortizationList(n, "IsPaid = 'N'", string);
    }
}

