/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAccountProduct;
import org.spin.model.MFMAgreementType;
import org.spin.model.X_FM_Agreement;
import org.spin.model.X_I_FM_Agreement;
import org.spin.util.FinancialSetting;

public class MFMAgreement
extends X_FM_Agreement
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20180228L;
    private static CCache<Integer, MFMAgreement> agreementCacheIds = new CCache("FM_Agreement", 30);
    private List<MFMAccountProduct> products = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MFMAgreement(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MFMAgreement(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public static MFMAgreement getById(Properties properties, int n, String string) {
        if (n <= 0) {
            return null;
        }
        MFMAgreement mFMAgreement = agreementCacheIds.get(n);
        if (mFMAgreement != null && mFMAgreement.get_ID() > 0) {
            return mFMAgreement;
        }
        mFMAgreement = (MFMAgreement)new Query(properties, "FM_Agreement", "FM_Agreement_ID=?", string).setClient_ID().setParameters(n).first();
        if (mFMAgreement != null && mFMAgreement.get_ID() > 0) {
            agreementCacheIds.put(mFMAgreement.get_ID(), mFMAgreement);
        }
        return mFMAgreement;
    }

    public static MFMAgreement getById(Properties properties, int n) {
        return MFMAgreement.getById(properties, n, null);
    }

    public MFMAgreement(X_I_FM_Agreement x_I_FM_Agreement) {
        super(x_I_FM_Agreement.getCtx(), x_I_FM_Agreement.getFM_Agreement_ID(), x_I_FM_Agreement.get_TrxName());
        this.setDocumentNo(x_I_FM_Agreement.getDocumentNo());
        this.setC_BPartner_ID(x_I_FM_Agreement.getC_BPartner_ID());
        this.setFM_Product_ID(x_I_FM_Agreement.getFM_Product_ID());
        this.setDescription(x_I_FM_Agreement.getDescription());
        this.setText(x_I_FM_Agreement.getText());
        this.setC_DocType_ID(x_I_FM_Agreement.getC_DocType_ID());
        this.setFM_AgreementType_ID(x_I_FM_Agreement.getFM_AgreementType_ID());
        this.setDateDoc(x_I_FM_Agreement.getDateDoc());
        if (x_I_FM_Agreement.getValidFrom() == null) {
            this.setValidFrom(x_I_FM_Agreement.getDateDoc());
        } else {
            this.setValidFrom(x_I_FM_Agreement.getValidFrom());
        }
        if (x_I_FM_Agreement.getValidTo() == null) {
            this.setValidTo(x_I_FM_Agreement.getDateDoc());
        } else {
            this.setValidTo(x_I_FM_Agreement.getValidTo());
        }
        this.setIsSOTrx(x_I_FM_Agreement.isSOTrx());
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        for (MFMAccountProduct object : this.getAccountProducts()) {
            this.m_processMsg = FinancialSetting.get().fireDocValidate(this, 1, object.getFM_Product_ID());
            if (this.m_processMsg == null) continue;
            return "IN";
        }
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), mDocType.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        for (MFMAccountProduct mFMAccountProduct : this.getAccountProducts()) {
            this.m_processMsg = FinancialSetting.get().fireDocValidate(this, 8, mFMAccountProduct.getFM_Product_ID());
            if (this.m_processMsg == null) continue;
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        Object object;
        if (!this.m_justPrepared && !"IP".equals(object = this.prepareIt())) {
            return object;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        for (MFMAccountProduct object2 : this.getAccountProducts()) {
            this.m_processMsg = FinancialSetting.get().fireDocValidate(this, 7, object2.getFM_Product_ID());
            if (this.m_processMsg == null) continue;
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        object = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (object != null) {
            this.m_processMsg = object;
            return "IN";
        }
        for (MFMAccountProduct mFMAccountProduct : this.getAccountProducts()) {
            this.m_processMsg = FinancialSetting.get().fireDocValidate(this, 9, mFMAccountProduct.getFM_Product_ID());
            if (this.m_processMsg == null) continue;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (mDocType.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (mDocType.isOverwriteSeqOnComplete()) {
            String string = null;
            int n = this.p_info.getColumnIndex("C_DocType_ID");
            if (n == -1) {
                n = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (n != -1) {
                string = DB.getDocumentNo(this.get_ValueAsInt(n), this.get_TrxName(), true);
            }
            if (string != null) {
                this.setDocumentNo(string);
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.setProcessed(false);
        this.setDocAction("CO");
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MFMAgreement[").append(this.getSummary()).append("]");
        return stringBuffer.toString();
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        MFMAgreementType mFMAgreementType;
        if (bl && Util.isEmpty(this.getText()) && this.getFM_AgreementType_ID() != 0 && (mFMAgreementType = MFMAgreementType.getById(this.getCtx(), this.getFM_AgreementType_ID())).getText() != null) {
            this.setText(mFMAgreementType.getText());
        }
        return super.beforeSave(bl);
    }

    public List<MFMAccount> getAccounts() {
        return MFMAccount.getAccountFromAgreement(this);
    }

    public List<MFMAccountProduct> getAccountProducts() {
        if (this.products != null) {
            return this.products;
        }
        this.products = new Query(this.getCtx(), "FM_AccountProduct", "EXISTS(SELECT 1 FROM FM_Account a WHERE a.FM_Account_ID = FM_AccountProduct.FM_Account_ID AND a.FM_Agreement_ID = ?)", this.get_TrxName()).setClient_ID().setParameters(this.getFM_Agreement_ID()).setOnlyActiveRecords(true).list();
        return this.products;
    }

    @Override
    public int customizeValidActions(String string, Object object, String string2, String string3, int n, String[] stringArray, String[] stringArray2, int n2) {
        if (n == Table_ID) {
            if (string.equals("DR") || string.equals("IP") || string.equals("IN")) {
                stringArray2[n2++] = "PR";
            } else if (string.equals("CO")) {
                stringArray2[n2++] = "RE";
                stringArray2[n2++] = "VO";
            }
        }
        return n2;
    }

    public void setFM_AgreementType_ID() {
        MFMAgreementType mFMAgreementType = MFMAgreementType.getDefault(Env.getCtx());
        if (mFMAgreementType != null) {
            this.setFM_AgreementType_ID(mFMAgreementType.getFM_AgreementType_ID());
        }
    }

    public void setC_DocType_ID(String string) {
        int n = MDocType.getDocType(string);
        if (n <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", DocBaseTypeType=" + string);
        } else {
            this.log.fine("(SO) - " + string);
            this.setC_DocType_ID(n);
        }
    }
}

