/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MStore;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.model.X_C_PaymentMethod;

public class MCPaymentMethod
extends X_C_PaymentMethod {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MCPaymentMethod> paymentMethodCacheIds = new CCache("C_PaymentMethod", 30);
    private static CCache<String, MCPaymentMethod> paymentMethodGroupCodes = new CCache("C_PaymentMethod", 30);

    public MCPaymentMethod(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MCPaymentMethod(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public static MCPaymentMethod getById(Properties properties, int n, String string) {
        if (n <= 0) {
            return null;
        }
        MCPaymentMethod mCPaymentMethod = paymentMethodCacheIds.get(n);
        if (mCPaymentMethod != null && mCPaymentMethod.get_ID() > 0) {
            return mCPaymentMethod;
        }
        mCPaymentMethod = (MCPaymentMethod)new Query(properties, "C_PaymentMethod", "C_PaymentMethod_ID=?", string).setParameters(n).first();
        if (mCPaymentMethod != null && mCPaymentMethod.get_ID() > 0) {
            int n2 = Env.getAD_Client_ID(properties);
            String string2 = n2 + "#" + mCPaymentMethod.getValue();
            paymentMethodGroupCodes.put(string2, mCPaymentMethod);
            paymentMethodCacheIds.put(mCPaymentMethod.get_ID(), mCPaymentMethod);
        }
        return mCPaymentMethod;
    }

    public static MCPaymentMethod getByValue(Properties properties, String string, String string2) {
        String string3;
        MCPaymentMethod mCPaymentMethod;
        if (string == null) {
            return null;
        }
        if (paymentMethodGroupCodes.size() == 0) {
            MCPaymentMethod.getAll(properties, true, string2);
        }
        if ((mCPaymentMethod = paymentMethodGroupCodes.get(string3 = string)) != null && mCPaymentMethod.get_ID() > 0) {
            return mCPaymentMethod;
        }
        mCPaymentMethod = (MCPaymentMethod)new Query(properties, "C_PaymentMethod", "Value=?", string2).setParameters(string).first();
        if (mCPaymentMethod != null && mCPaymentMethod.get_ID() > 0) {
            paymentMethodGroupCodes.put(string3, mCPaymentMethod);
            paymentMethodCacheIds.put(mCPaymentMethod.get_ID(), mCPaymentMethod);
        }
        return mCPaymentMethod;
    }

    public static List<MCPaymentMethod> getAll(Properties properties, boolean bl, String string) {
        if (bl || paymentMethodCacheIds.size() > 0) {
            List<MCPaymentMethod> list = new Query(Env.getCtx(), "C_PaymentMethod", null, string).setClient_ID().setOrderBy("Name").list();
            list.stream().forEach(mCPaymentMethod -> {
                String string = mCPaymentMethod.getValue();
                paymentMethodCacheIds.put(mCPaymentMethod.getC_PaymentMethod_ID(), (MCPaymentMethod)mCPaymentMethod);
                paymentMethodGroupCodes.put(string, (MCPaymentMethod)mCPaymentMethod);
            });
            return list;
        }
        List<MCPaymentMethod> list = paymentMethodCacheIds.entrySet().stream().map(entry -> (MCPaymentMethod)entry.getValue()).collect(Collectors.toList());
        return list;
    }

    public static List<MCPaymentMethod> getOfStore(Properties properties, int n, String string) {
        return new Query(Env.getCtx(), "C_PaymentMethod", "EXISTS(SELECT 1 FROM C_PaymentMethodAllocation a WHERE a.C_PaymentMethod_ID = C_PaymentMethod.C_PaymentMethod_ID AND a.W_Store_ID = ?)", string).setParameters(n).setClient_ID().list();
    }

    public List<MStore> getStoresList() {
        return new Query(Env.getCtx(), "M_Product", "EXISTS(SELECT 1 FROM C_PaymentMethodAllocation a WHERE a.W_Store_ID = W_Store.W_Store_ID AND a.W_ProductCategory_ID = ?)", this.get_TrxName()).setParameters(this.getC_PaymentMethod_ID()).setClient_ID().list();
    }

    @Override
    public String toString() {
        return "MWPaymentMethod [getName()=" + this.getName() + ", getValue()=" + this.getValue() + ", getC_PaymentMethod_ID()=" + this.getC_PaymentMethod_ID() + "]";
    }
}

