/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.model.MADAppRegistrationPara;
import org.spin.model.MADAppSupport;
import org.spin.model.MADAppSupportPara;
import org.spin.model.X_AD_AppRegistration;

public class MADAppRegistration
extends X_AD_AppRegistration {
    private static final long serialVersionUID = -1171525387615789574L;
    private static CCache<Integer, MADAppRegistration> definitionCacheIds = new CCache("AD_AppRegistration", 30);
    private static CCache<String, MADAppRegistration> definitionCacheValues = new CCache("AD_AppRegistration", 30);
    private Map<String, MADAppRegistrationPara> parameters = null;

    public MADAppRegistration(Properties ctx, int AD_AppRegistration_ID, String trxName) {
        super(ctx, AD_AppRegistration_ID, trxName);
    }

    public MADAppRegistration(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MADAppRegistration getById(Properties ctx, int registrationId, String trxName) {
        if (registrationId <= 0) {
            return null;
        }
        MADAppRegistration definition = definitionCacheIds.get(registrationId);
        if (definition != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADAppRegistration)new Query(ctx, "AD_AppRegistration", "AD_AppRegistration_ID=?", trxName).setParameters(registrationId).first();
        if (definition != null && definition.get_ID() > 0) {
            String key = definition.getValue();
            definitionCacheValues.put(key, definition);
            definitionCacheIds.put(definition.get_ID(), definition);
        }
        return definition;
    }

    public static MADAppRegistration getByApplicationType(Properties ctx, String applicationType, String trxName) {
        String key;
        MADAppRegistration definition;
        if (applicationType == null) {
            return null;
        }
        if (definitionCacheValues.size() == 0) {
            MADAppRegistration.getAll(ctx, true, trxName);
        }
        if ((definition = definitionCacheValues.get(key = applicationType)) != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADAppRegistration)new Query(ctx, "AD_AppRegistration", "ApplicationType=?", trxName).setParameters(applicationType).setOrderBy("Value").first();
        if (definition != null && definition.get_ID() > 0) {
            definitionCacheValues.put(key, definition);
            definitionCacheIds.put(definition.get_ID(), definition);
        }
        return definition;
    }

    public static List<MADAppRegistration> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || definitionCacheIds.size() == 0) {
            List<MADAppRegistration> definitionList = new Query(Env.getCtx(), "AD_AppRegistration", null, trxName).setOrderBy("Value").list();
            definitionList.stream().forEach(definition -> {
                String key = definition.getValue();
                definitionCacheIds.put(definition.getAD_AppRegistration_ID(), (MADAppRegistration)definition);
                definitionCacheValues.put(key, (MADAppRegistration)definition);
            });
            return definitionList;
        }
        List<MADAppRegistration> definitionList = definitionCacheIds.entrySet().stream().map(activity -> (MADAppRegistration)activity.getValue()).collect(Collectors.toList());
        return definitionList;
    }

    public static void resetCache() {
        definitionCacheIds.clear();
        definitionCacheValues.clear();
    }

    public String getParameterValue(String parameterName) {
        MADAppRegistrationPara parameter;
        if (this.parameters == null) {
            this.loadParameters();
        }
        if ((parameter = this.parameters.get(parameterName)) == null) {
            return null;
        }
        return parameter.getParameterValue();
    }

    public String getParameterType(String parameterName) {
        MADAppRegistrationPara parameter;
        if (this.parameters == null) {
            this.loadParameters();
        }
        if ((parameter = this.parameters.get(parameterName)) == null) {
            return null;
        }
        return parameter.getParameterType();
    }

    private void loadParameters() {
        this.parameters = new HashMap<String, MADAppRegistrationPara>();
        new Query(this.getCtx(), "AD_AppRegistration_Para", "AD_AppRegistration_ID = ?", this.get_TrxName()).setParameters(this.getAD_AppRegistration_ID()).list().forEach(parameter -> this.parameters.put(parameter.getParameterName(), (MADAppRegistrationPara)parameter));
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        List<MADAppSupportPara> defaultParametersList;
        if (newRecord && success && (defaultParametersList = MADAppSupport.getById(this.getCtx(), this.getAD_AppSupport_ID(), this.get_TrxName()).getDefaultParametersList()) != null) {
            defaultParametersList.forEach(defaultParameter -> {
                MADAppRegistrationPara parameter = new MADAppRegistrationPara(this.getCtx(), 0, this.get_TrxName());
                parameter.setAD_AppRegistration_ID(this.getAD_AppRegistration_ID());
                parameter.setDefaultParameter((MADAppSupportPara)defaultParameter);
                parameter.saveEx();
            });
        }
        return super.afterSave(newRecord, success);
    }

    public Map<String, MADAppRegistrationPara> getAllParameters() {
        if (this.parameters == null) {
            this.loadParameters();
        }
        return this.parameters;
    }

    @Override
    public String toString() {
        return "MADAppRegistration [getAD_AppRegistration_ID()=" + this.getAD_AppRegistration_ID() + ", getName()=" + this.getName() + ", getApplicationType()=" + this.getApplicationType() + ", getValue()=" + this.getValue() + "]";
    }
}

