/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.Env;

public class CalloutInventory
extends CalloutEngine {
    public String productUom(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        Integer productId = (Integer)value;
        if (productId == null || productId == 0) {
            mTab.setValue("M_AttributeSetInstance_ID", null);
            mTab.setValue("QtyCount", (Object)new BigDecimal(0));
            mTab.setValue("QtyCountEntered", (Object)new BigDecimal(0));
            mTab.setValue("QtyInternalUse", (Object)new BigDecimal(0));
            mTab.setValue("QtyInternalUseEntered", (Object)new BigDecimal(0));
            mTab.setValue("C_UOM_ID", null);
            return "";
        }
        MProduct product = MProduct.get(ctx, productId);
        mTab.setValue("C_UOM_ID", (Object)new Integer(product.getC_UOM_ID()));
        return this.quantity(ctx, WindowNo, mTab, mField, value);
    }

    public String quantity(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int productId = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        if (productId == 0) {
            BigDecimal qtyCountEntered = (BigDecimal)mTab.getValue("QtyCountEntered");
            BigDecimal qtyInternalUseEntered = (BigDecimal)mTab.getValue("QtyInternalUseEntered");
            mTab.setValue("QtyCount", (Object)qtyCountEntered);
            mTab.setValue("QtyInternalUse", (Object)qtyInternalUseEntered);
            return "";
        }
        if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyOrdered;
            int unitOfMeasureToId = (Integer)value;
            String columnName = null;
            String targetColumnName = null;
            BigDecimal qtyCountEntered = (BigDecimal)mTab.getValue("QtyCountEntered");
            BigDecimal qtyInternalUseEntered = (BigDecimal)mTab.getValue("QtyInternalUseEntered");
            BigDecimal QtyEntered = Env.ZERO;
            if (Optional.ofNullable(qtyCountEntered).orElse(Env.ZERO).compareTo(Env.ZERO) > 0) {
                columnName = "QtyCountEntered";
                targetColumnName = "QtyCount";
                QtyEntered = qtyCountEntered;
            } else if (Optional.ofNullable(qtyInternalUseEntered).orElse(Env.ZERO).compareTo(Env.ZERO) > 0) {
                columnName = "QtyInternalUseEntered";
                targetColumnName = "QtyInternalUse";
                QtyEntered = qtyInternalUseEntered;
            }
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, unitOfMeasureToId), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + unitOfMeasureToId + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue(columnName, (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, productId, unitOfMeasureToId, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            this.log.fine("UOM=" + unitOfMeasureToId + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyOrdered=" + QtyOrdered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue(targetColumnName, (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("QtyCountEntered")) {
            BigDecimal QtyOrdered;
            BigDecimal QtyEntered = (BigDecimal)value;
            int unitOfMeasureToId = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, unitOfMeasureToId), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + unitOfMeasureToId + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, productId, unitOfMeasureToId, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            this.log.fine("UOM=" + unitOfMeasureToId + ", QtyCount=" + QtyEntered + " -> " + conversion + " QtyCount=" + QtyOrdered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyCount", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("QtyInternalUseEntered")) {
            BigDecimal QtyOrdered;
            BigDecimal QtyEntered = (BigDecimal)value;
            int C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, productId, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyInternalUseEntered=" + QtyEntered + " -> " + conversion + " QtyInternalUse=" + QtyOrdered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyInternalUse", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("QtyCount")) {
            BigDecimal QtyEntered;
            int unitOfMeasureToId = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal QtyOrdered = (BigDecimal)value;
            int precision = MProduct.get(ctx, productId).getUOMPrecision();
            BigDecimal QtyOrdered1 = QtyOrdered.setScale(precision, 4);
            if (QtyOrdered.compareTo(QtyOrdered1) != 0) {
                this.log.fine("Corrected QtyOrdered Scale " + QtyOrdered + "->" + QtyOrdered1);
                QtyOrdered = QtyOrdered1;
                mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, productId, unitOfMeasureToId, QtyOrdered)) == null) {
                QtyEntered = QtyOrdered;
            }
            boolean conversion = QtyOrdered.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + unitOfMeasureToId + ", QtyOrdered=" + QtyOrdered + " -> " + conversion + " QtyEntered=" + QtyEntered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyCountEntered", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("QtyInternalUse")) {
            BigDecimal QtyEntered;
            int unitOfMeasureToId = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal QtyOrdered = (BigDecimal)value;
            int precision = MProduct.get(ctx, productId).getUOMPrecision();
            BigDecimal QtyOrdered1 = QtyOrdered.setScale(precision, 4);
            if (QtyOrdered.compareTo(QtyOrdered1) != 0) {
                this.log.fine("Corrected QtyOrdered Scale " + QtyOrdered + "->" + QtyOrdered1);
                QtyOrdered = QtyOrdered1;
                mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, productId, unitOfMeasureToId, QtyOrdered)) == null) {
                QtyEntered = QtyOrdered;
            }
            boolean conversion = QtyOrdered.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + unitOfMeasureToId + ", QtyOrdered=" + QtyOrdered + " -> " + conversion + " QtyEntered=" + QtyEntered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyInternalUseEntered", (Object)QtyEntered);
        }
        return "";
    }
}

