/*
 * Decompiled with CFR 0.152.
 */
package org.spin.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.X_C_OrderLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.model.X_DD_OrderLine;

public class OutBoundOrder {
    public static CLogger log = CLogger.getCLogger(OutBoundOrder.class);
    public final int SELECT = 0;
    public final int ORDER = 2;
    public final int OL_WAREHOUSE = 1;
    public final int ORDER_LINE = 2;
    public final int OL_PRODUCT = 3;
    public final int OL_UOM = 4;
    public final int OL_QTY_ON_HAND = 5;
    public final int OL_QTY = 6;
    public final int OL_WEIGHT = 7;
    public final int OL_VOLUME = 8;
    public final int OL_SEQNO = 9;
    public final int OL_QTY_ENTERED = 10;
    public final int OL_UOM_CONVERSION = 11;
    public final int OL_QTY_ORDERED = 12;
    public final int OL_QTY_RESERVERD = 13;
    public final int OL_QTY_INVOICED = 14;
    public final int OL_QTY_DELIVERED = 15;
    public final int OL_QTY_IN_TRANSIT = 16;
    public final int OL_DELIVERY_RULE = 17;
    public final int SW_PRODUCT = 0;
    public final int SW_UOM = 1;
    public final int SW_WAREHOUSE = 2;
    public final int SW_QTY_ON_HAND = 3;
    public final int SW_QTY_IN_TRANSIT = 4;
    public final int SW_QTY_SET = 5;
    public final int SW_QTY_AVAILABLE = 6;
    public Vector<BufferTableSelect> m_BufferSelect = null;
    public StringBuffer m_Symmary = new StringBuffer();
    public StringBuffer m_QueryAdd = new StringBuffer();
    protected int clientId = 0;
    protected int orgId = 0;
    protected int salesRegionId = 0;
    protected int salesRepId = 0;
    protected int warehouseId = 0;
    protected String movementType = null;
    protected String documentAction = null;
    protected int docTypeId = 0;
    protected int docTypeTargetId = 0;
    protected String deliveryRule = null;
    protected String deliveryViaRule = null;
    protected Timestamp documentDate = null;
    protected Timestamp shipmentDate = null;
    protected int shipperId = 0;
    protected BigDecimal payloadCapacity = Env.ZERO;
    protected BigDecimal volumeCapacity = Env.ZERO;
    protected int uOMWeightId = 0;
    protected int uOMVolumeId = 0;
    protected int weightPrecision = 0;
    protected int volumePrecision = 0;
    protected int rowsSelected = 0;
    protected String uOMWeightSymbol = null;
    protected String uOMVolumeSymbol = null;
    protected BigDecimal totalWeight = Env.ZERO;
    protected BigDecimal totalVolume = Env.ZERO;
    protected int maxSeqNo = 0;
    protected MWMInOutBound outBoundOrder = null;
    protected Integer locatorId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Vector<Object>> getOrderData(IMiniTable orderTable) {
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = null;
        if (this.movementType.equals("DD_Order")) {
            sql = new StringBuffer("SELECT wr.Name Warehouse, ord.DD_Order_ID, ord.DocumentNo, ord.DateOrdered, ord.DatePromised, reg.Name, cit.Name, sr.Name SalesRep, cp.Name Partner, bploc.Name, loc.Address1, loc.Address2, loc.Address3, loc.Address4, ord.C_BPartner_Location_ID, ord.Weight, ord.Volume FROM DD_Order ord INNER JOIN DD_OrderLine lord ON(lord.DD_Order_ID = ord.DD_Order_ID) INNER JOIN M_Product pr ON(pr.M_Product_ID = lord.M_Product_ID) INNER JOIN C_BPartner cp ON(cp.C_BPartner_ID = ord.C_BPartner_ID) INNER JOIN AD_User sr ON(sr.AD_User_ID = ord.SalesRep_ID) INNER JOIN M_Locator wloc ON(wloc.M_Locator_ID = lord.M_Locator_ID) INNER JOIN M_Warehouse wr ON(wr.M_Warehouse_ID = wloc.M_Warehouse_ID) INNER JOIN C_BPartner_Location bploc ON(bploc.C_BPartner_Location_ID = ord.C_BPartner_Location_ID) INNER JOIN C_Location loc ON(loc.C_Location_ID = bploc.C_Location_ID) LEFT JOIN C_Region reg ON(reg.C_Region_ID = loc.C_Region_ID) LEFT JOIN C_City cit ON(cit.C_City_ID = loc.C_City_ID) LEFT JOIN (SELECT lord.DD_OrderLine_ID, \t(COALESCE(lord.QtyOrdered, 0) - \t\tSUM(\t\t\t\tCASE WHEN (c.IsDelivered = 'N' AND lc.DD_Order_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\t\t\t\tTHEN COALESCE(lc.MovementQty, 0) \t\t\t\t\t\tELSE 0 \t\t\t\tEND\t\t\t)\t) QtyAvailable \tFROM DD_OrderLine lord \tLEFT JOIN WM_InOutBoundLine lc ON(lc.DD_OrderLine_ID = lord.DD_OrderLine_ID) \tLEFT JOIN WM_InOutBound c ON(c.WM_InOutBound_ID = lc.WM_InOutBound_ID) \tWHERE lord.M_Product_ID IS NOT NULL \tGROUP BY lord.DD_Order_ID, lord.DD_OrderLine_ID, lord.QtyOrdered \tORDER BY lord.DD_OrderLine_ID ASC) qafl \tON(qafl.DD_OrderLine_ID = lord.DD_OrderLine_ID) WHERE  wr.IsActive = 'Y' AND ord.DocStatus = 'CO' AND COALESCE(qafl.QtyAvailable, 0) > 0 AND ord.AD_Client_ID=? ");
            if (this.orgId > 0) {
                sql.append("AND lord.AD_Org_ID=? ");
            }
            if (this.warehouseId > 0) {
                sql.append("AND wr.M_Warehouse_ID=? ");
            }
            if (this.salesRegionId > 0) {
                sql.append("AND bploc.C_SalesRegion_ID=? ");
            }
            if (this.salesRepId > 0) {
                sql.append("AND ord.SalesRep_ID=? ");
            }
            if (this.docTypeId > 0) {
                sql.append("AND ord.C_DocType_ID=? ");
            }
            sql.append("GROUP BY wr.Name, ord.DD_Order_ID, ord.DocumentNo, ord.DateOrdered, ord.DatePromised, ord.Weight, ord.Volume, sr.Name, cp.Name, bploc.Name, reg.Name, cit.Name, loc.Address1, loc.Address2, loc.Address3, loc.Address4, ord.C_BPartner_Location_ID ");
            sql.append("HAVING (SUM(COALESCE(lord.QtyOrdered, 0)) - SUM(COALESCE(lord.QtyInTransit, 0)) - SUM(COALESCE(lord.QtyDelivered, 0))) > 0 ");
            sql.append("ORDER BY ord.DD_Order_ID ASC");
        } else {
            sql = new StringBuffer("SELECT wr.Name Warehouse, ord.C_Order_ID, ord.DocumentNo, ord.DateOrdered, ord.DatePromised, reg.Name, cit.Name, sr.Name SalesRep, cp.Name Partner, bploc.Name, loc.Address1, loc.Address2, loc.Address3, loc.Address4, ord.C_BPartner_Location_ID, ord.Weight, ord.Volume FROM C_Order ord INNER JOIN C_OrderLine lord ON(lord.C_Order_ID = ord.C_Order_ID) INNER JOIN M_Product pr ON(pr.M_Product_ID = lord.M_Product_ID) INNER JOIN C_BPartner cp ON(cp.C_BPartner_ID = ord.C_BPartner_ID) INNER JOIN M_Warehouse wr ON(wr.M_Warehouse_ID = ord.M_Warehouse_ID) INNER JOIN C_BPartner_Location bploc ON(bploc.C_BPartner_Location_ID = ord.C_BPartner_Location_ID) INNER JOIN C_Location loc ON(loc.C_Location_ID = bploc.C_Location_ID) LEFT JOIN AD_User sr ON(sr.AD_User_ID = ord.SalesRep_ID) LEFT JOIN C_Region reg ON(reg.C_Region_ID = loc.C_Region_ID) LEFT JOIN C_City cit ON(cit.C_City_ID = loc.C_City_ID) LEFT JOIN (SELECT lord.C_OrderLine_ID, \t(COALESCE(lord.QtyOrdered, 0) - \t\tSUM(\t\t\t\tCASE WHEN (c.IsDelivered = 'N' AND lc.C_Order_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\t\t\t\tTHEN COALESCE(lc.MovementQty, 0) \t\t\t\t\t\tELSE 0 \t\t\t\tEND\t\t\t)\t) QtyAvailable \tFROM C_OrderLine lord \tLEFT JOIN WM_InOutBoundLine lc ON(lc.C_OrderLine_ID = lord.C_OrderLine_ID) \tLEFT JOIN WM_InOutBound c ON(c.WM_InOutBound_ID = lc.WM_InOutBound_ID) \tWHERE lord.M_Product_ID IS NOT NULL \tGROUP BY lord.C_Order_ID, lord.C_OrderLine_ID, lord.QtyOrdered \tORDER BY lord.C_OrderLine_ID ASC) qafl \tON(qafl.C_OrderLine_ID = lord.C_OrderLine_ID) WHERE ord.IsSOTrx = 'Y' AND wr.IsActive = 'Y' AND ord.DocStatus = 'CO' AND COALESCE(qafl.QtyAvailable, 0) > 0 AND ord.AD_Client_ID=? ");
            if (this.orgId > 0) {
                sql.append("AND lord.AD_Org_ID=? ");
            }
            if (this.warehouseId > 0) {
                sql.append("AND lord.M_Warehouse_ID=? ");
            }
            if (this.salesRegionId > 0) {
                sql.append("AND bploc.C_SalesRegion_ID=? ");
            }
            if (this.salesRepId > 0) {
                sql.append("AND ord.SalesRep_ID=? ");
            }
            if (this.docTypeId > 0) {
                sql.append("AND ord.C_DocType_ID=? ");
            }
            sql.append("GROUP BY wr.Name, ord.C_Order_ID, ord.DocumentNo, ord.DateOrdered, ord.DatePromised, ord.Weight, ord.Volume, sr.Name, cp.Name, bploc.Name, reg.Name, cit.Name, loc.Address1, loc.Address2, loc.Address3, loc.Address4, ord.C_BPartner_Location_ID ");
            sql.append("HAVING (SUM(COALESCE(lord.QtyOrdered, 0)) - SUM(COALESCE(lord.QtyDelivered, 0))) > 0 ");
            sql.append("ORDER BY ord.C_Order_ID ASC");
        }
        log.fine("LoadOrderSQL=" + sql.toString());
        try {
            int param = 1;
            int column = 1;
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(param++, Env.getAD_Client_ID(Env.getCtx()));
            if (this.orgId > 0) {
                pstmt.setInt(param++, this.orgId);
            }
            if (this.warehouseId > 0) {
                pstmt.setInt(param++, this.warehouseId);
            }
            if (this.salesRegionId > 0) {
                pstmt.setInt(param++, this.salesRegionId);
            }
            if (this.salesRepId > 0) {
                pstmt.setInt(param++, this.salesRepId);
            }
            if (this.docTypeId > 0) {
                pstmt.setInt(param++, this.docTypeId);
            }
            log.fine("AD_Org_ID=" + this.orgId);
            log.fine("M_Warehouse_ID=" + this.warehouseId);
            log.fine("SalesRep_ID=" + this.salesRepId);
            log.fine("C_DocType_ID=" + this.docTypeId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                column = 1;
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getString(column++));
                KeyNamePair pp = new KeyNamePair(rs.getInt(column++), rs.getString(column++));
                line.add(pp);
                line.add(rs.getTimestamp(column++));
                line.add(rs.getTimestamp(column++));
                line.add(rs.getString(column++));
                line.add(rs.getString(column++));
                line.add(rs.getString(column++));
                line.add(rs.getString(column++));
                line.add(rs.getString(column++));
                line.add(rs.getString(column++));
                line.add(rs.getString(column++));
                line.add(rs.getString(column++));
                line.add(rs.getString(column++));
                line.add(rs.getBigDecimal(column++));
                line.add(rs.getBigDecimal(column++));
                data.add(line);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql.toString(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        DB.close(rs, pstmt);
        return data;
    }

    protected StringBuffer getQueryLine(IMiniTable orderTable) {
        StringBuffer sql = null;
        log.config("getQueryLine");
        if (this.movementType.equals("DD_Order")) {
            int rows = orderTable.getRowCount();
            this.rowsSelected = 0;
            StringBuffer sqlWhere = new StringBuffer("ord.DD_Order_ID IN(0");
            for (int i = 0; i < rows; ++i) {
                if (!((Boolean)orderTable.getValueAt(i, 0)).booleanValue()) continue;
                int ID = ((KeyNamePair)orderTable.getValueAt(i, 2)).getKey();
                sqlWhere.append(",");
                sqlWhere.append(ID);
                ++this.rowsSelected;
            }
            sqlWhere.append(")");
            sql = new StringBuffer("SELECT alm.M_Warehouse_ID, alm.Name Warehouse, lord.DD_OrderLine_ID OrderLine_ID, ord.DocumentNo, lord.M_Product_ID, (pro.Name || COALESCE(' - ' || productattribute(lord.M_AttributeSetInstance_ID), '')) Product, pro.C_UOM_ID, uomp.UOMSymbol, s.QtyOnHand, lord.QtyOrdered, lord.C_UOM_ID Order_UOM_ID, uom.UOMSymbol Order_UOMSymbol, lord.QtyReserved, 0 QtyInvoiced, lord.QtyDelivered, SUM(\t\tCOALESCE(CASE \t\t\tWHEN (c.IsDelivered = 'N' AND lc.DD_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\tTHEN lc.MovementQty \t\t\tELSE 0 \t\tEND, 0)) QtyLoc, (COALESCE(lord.QtyOrdered, 0) - COALESCE(lord.QtyInTransit, 0) - COALESCE(lord.QtyDelivered, 0) - \tSUM(\t\tCOALESCE(CASE \t\t\tWHEN (c.IsDelivered = 'N' AND lc.DD_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\tTHEN lc.MovementQty \t\t\tELSE 0 \t\tEND, 0)\t\t)) Qty, pro.Weight, pro.Volume, ord.DeliveryRule, pro.IsStocked, lord.QtyEntered FROM DD_Order ord INNER JOIN DD_OrderLine lord ON(lord.DD_Order_ID = ord.DD_Order_ID) INNER JOIN M_Locator l ON(l.M_Locator_ID = lord.M_Locator_ID) INNER JOIN M_Warehouse alm ON(alm.M_Warehouse_ID = l.M_Warehouse_ID) INNER JOIN M_Product pro ON(pro.M_Product_ID = lord.M_Product_ID) INNER JOIN C_UOM uom ON(uom.C_UOM_ID = lord.C_UOM_ID) INNER JOIN C_UOM uomp ON(uomp.C_UOM_ID = pro.C_UOM_ID) LEFT JOIN WM_InOutBoundLine lc ON(lc.DD_OrderLine_ID = lord.DD_OrderLine_ID) LEFT JOIN WM_InOutBound c ON(c.WM_InOutBound_ID = lc.WM_InOutBound_ID) LEFT JOIN (\t\t\t\tSELECT l.M_Warehouse_ID, st.M_Product_ID, \t\t\t\t\tCOALESCE(SUM(st.QtyOnHand), 0) QtyOnHand, \t\t\t\t\t(CASE WHEN p.M_AttributeSet_ID IS NOT NULL THEN COALESCE(st.M_AttributeSetInstance_ID, 0) ELSE 0 END) M_AttributeSetInstance_ID \t\t\t\tFROM M_Storage st \t\t\t\tINNER JOIN M_Product p ON(p.M_Product_ID = st.M_Product_ID) \t\t\t\tINNER JOIN M_Locator l ON(l.M_Locator_ID = st.M_Locator_ID) \t\t\tGROUP BY l.M_Warehouse_ID, st.M_Product_ID, p.M_AttributeSet_ID, 4) s \t\t\t\t\t\t\t\t\t\t\t\t\t\tON(s.M_Product_ID = lord.M_Product_ID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND s.M_Warehouse_ID = l.M_Warehouse_ID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND lord.M_AttributeSetInstance_ID = s.M_AttributeSetInstance_ID) ").append("WHERE ").append(sqlWhere).append(" ");
            sql.append("GROUP BY alm.M_Warehouse_ID, lord.DD_Order_ID, lord.DD_OrderLine_ID, alm.Name, ord.DocumentNo, lord.M_Product_ID, lord.M_AttributeSetInstance_ID, pro.Name, lord.C_UOM_ID, uom.UOMSymbol, lord.QtyEntered, pro.C_UOM_ID, uomp.UOMSymbol, lord.QtyOrdered, lord.QtyReserved, lord.QtyDelivered, pro.Weight, pro.Volume, ord.DeliveryRule, s.QtyOnHand,pro.IsStocked, lord.QtyEntered").append(" ");
            sql.append("HAVING (COALESCE(lord.QtyOrdered, 0) - COALESCE(lord.QtyInTransit, 0) - COALESCE(lord.QtyDelivered, 0) - \t\t\t\t\t\t\t\tSUM(\t\t\t\t\t\t\t\t\tCOALESCE(CASE \t\t\t\t\t\t\t\t\t\tWHEN (c.IsDelivered = 'N' AND lc.DD_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\t\t\t\t\t\t\t\t\tTHEN lc.MovementQty \t\t\t\t\t\t\t\t\t\t\tELSE 0 \t\t\t\t\t\t\t\t\t\tEND, 0)\t\t\t\t\t\t\t\t)\t\t\t) > 0 OR pro.IsStocked = 'N' ").append(" ");
            sql.append("ORDER BY lord.DD_Order_ID ASC");
        } else {
            int rows = orderTable.getRowCount();
            this.rowsSelected = 0;
            StringBuffer sqlWhere = new StringBuffer("ord.C_Order_ID IN(0");
            for (int i = 0; i < rows; ++i) {
                if (!((Boolean)orderTable.getValueAt(i, 0)).booleanValue()) continue;
                int ID = ((KeyNamePair)orderTable.getValueAt(i, 2)).getKey();
                sqlWhere.append(",");
                sqlWhere.append(ID);
                ++this.rowsSelected;
            }
            sqlWhere.append(")");
            sql = new StringBuffer("SELECT lord.M_Warehouse_ID, alm.Name Warehouse, lord.C_OrderLine_ID OrderLine_ID, ord.DocumentNo, lord.M_Product_ID, (pro.Name || COALESCE(' - ' || productattribute(lord.M_AttributeSetInstance_ID), '')) Product, pro.C_UOM_ID, uomp.UOMSymbol, s.QtyOnHand, lord.QtyOrdered, lord.C_UOM_ID Order_UOM_ID, uom.UOMSymbol Order_UOMSymbol, lord.QtyReserved, lord.QtyInvoiced, lord.QtyDelivered, SUM(\t\tCOALESCE(CASE \t\t\tWHEN (c.IsDelivered = 'N' AND lc.C_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\tTHEN lc.MovementQty - COALESCE(iol.MovementQty, 0) \t\t\tELSE 0 \t\tEND, 0)) QtyLoc, (COALESCE(lord.QtyOrdered, 0) - COALESCE(lord.QtyDelivered, 0) - \tSUM(\t\tCOALESCE(CASE \t\t\tWHEN (c.IsDelivered = 'N' AND lc.C_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\tTHEN lc.MovementQty - COALESCE(iol.MovementQty, 0) \t\t\tELSE 0 \t\tEND, 0)\t\t)) Qty, pro.Weight, pro.Volume, ord.DeliveryRule, pro.IsStocked, lord.QtyEntered FROM C_Order ord INNER JOIN C_OrderLine lord ON(lord.C_Order_ID = ord.C_Order_ID) INNER JOIN M_Warehouse alm ON(alm.M_Warehouse_ID = lord.M_Warehouse_ID) INNER JOIN M_Product pro ON(pro.M_Product_ID = lord.M_Product_ID) INNER JOIN C_UOM uom ON(uom.C_UOM_ID = lord.C_UOM_ID) INNER JOIN C_UOM uomp ON(uomp.C_UOM_ID = pro.C_UOM_ID) LEFT JOIN WM_InOutBoundLine lc ON(lc.C_OrderLine_ID = lord.C_OrderLine_ID) LEFT JOIN WM_InOutBound c ON(c.WM_InOutBound_ID = lc.WM_InOutBound_ID) LEFT JOIN (SELECT iol.WM_InOutBoundLine_ID, SUM(iol.MovementQty) MovementQty \t\t\t\t\t\tFROM M_InOut io \t\t\t\t\t\tINNER JOIN M_InOutLine iol ON(iol.M_InOut_ID = io.M_InOut_ID) \t\t\t\t\t\tWHERE io.DocStatus IN('CO', 'CL') \t\t\t\t\t\tAND iol.WM_InOutBoundLine_ID IS NOT NULL\t\t\t\tGROUP BY iol.WM_InOutBoundLine_ID) iol ON(iol.WM_InOutBoundLine_ID = lc.WM_InOutBoundLine_ID) LEFT JOIN (\t\t\t\tSELECT l.M_Warehouse_ID, st.M_Product_ID, \t\t\t\t\tCOALESCE(SUM(st.QtyOnHand), 0) QtyOnHand, \t\t\t\t\t(CASE WHEN p.M_AttributeSet_ID IS NOT NULL THEN COALESCE(st.M_AttributeSetInstance_ID, 0) ELSE 0 END) M_AttributeSetInstance_ID \t\t\t\tFROM M_Storage st \t\t\t\tINNER JOIN M_Product p ON(p.M_Product_ID = st.M_Product_ID) \t\t\t\tINNER JOIN M_Locator l ON(l.M_Locator_ID = st.M_Locator_ID) \t\t\tGROUP BY l.M_Warehouse_ID, st.M_Product_ID, p.M_AttributeSet_ID, 4) s \t\t\t\t\t\t\t\t\t\t\t\t\t\tON(s.M_Product_ID = lord.M_Product_ID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND s.M_Warehouse_ID = lord.M_Warehouse_ID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND lord.M_AttributeSetInstance_ID = s.M_AttributeSetInstance_ID) ").append("WHERE ").append(sqlWhere).append(" ");
            sql.append("GROUP BY lord.M_Warehouse_ID, lord.C_Order_ID, lord.C_OrderLine_ID, alm.Name, ord.DocumentNo, lord.M_Product_ID, lord.M_AttributeSetInstance_ID, pro.Name, lord.C_UOM_ID, uom.UOMSymbol, lord.QtyEntered, pro.C_UOM_ID, uomp.UOMSymbol, lord.QtyOrdered, lord.QtyReserved, lord.QtyDelivered, lord.QtyInvoiced, pro.Weight, pro.Volume, ord.DeliveryRule, s.QtyOnHand, pro.IsStocked, lord.QtyEntered").append(" ");
            sql.append("HAVING (COALESCE(lord.QtyOrdered, 0) - COALESCE(lord.QtyDelivered, 0) - \t\t\t\t\t\t\t\t\tSUM(\t\t\t\t\t\t\t\t\t\tCOALESCE(CASE \t\t\t\t\t\t\t\t\t\t\tWHEN (c.IsDelivered = 'N' AND lc.C_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\t\t\t\t\t\t\t\t\tTHEN lc.MovementQty - COALESCE(iol.MovementQty, 0) \t\t\t\t\t\t\t\t\t\t\tELSE 0 \t\t\t\t\t\t\t\t\t\tEND, 0)\t\t\t\t\t\t\t\t\t)\t\t\t) > 0  OR pro.IsStocked = 'N' ").append(" ");
            sql.append("ORDER BY lord.C_Order_ID ASC");
        }
        log.fine("SQL Line Order=" + sql.toString());
        return sql;
    }

    protected Vector<String> getOrderColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "DocumentNo")));
        columnNames.add(Msg.translate(Env.getCtx(), "DateOrdered"));
        columnNames.add(Msg.translate(Env.getCtx(), "DatePromised"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_Region_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_City_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "SalesRep_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_Location_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "Address1"));
        columnNames.add(Msg.translate(Env.getCtx(), "Address2"));
        columnNames.add(Msg.translate(Env.getCtx(), "Address3"));
        columnNames.add(Msg.translate(Env.getCtx(), "Address4"));
        columnNames.add(Msg.translate(Env.getCtx(), "Weight"));
        columnNames.add(Msg.translate(Env.getCtx(), "Volume"));
        return columnNames;
    }

    protected void setOrderColumnClass(IMiniTable orderTable) {
        int i = 0;
        orderTable.setColumnClass(i++, Boolean.class, false);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, Timestamp.class, true);
        orderTable.setColumnClass(i++, Timestamp.class, true);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, String.class, true);
        orderTable.setColumnClass(i++, BigDecimal.class, true);
        orderTable.setColumnClass(i++, BigDecimal.class, true);
        orderTable.autoSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Vector<Object>> getOrderLineData(IMiniTable orderLineTable, StringBuffer sqlPrep) {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        log.fine("LoadOrderLineSQL=" + sqlPrep.toString());
        try {
            pstmt = DB.prepareStatement(sqlPrep.toString(), null);
            rs = pstmt.executeQuery();
            KeyNamePair warehouse = null;
            KeyNamePair documentNo = null;
            KeyNamePair product = null;
            KeyNamePair productUOM = null;
            KeyNamePair orderUOM = null;
            BigDecimal qtyOnHand = Env.ZERO;
            BigDecimal qtyReserved = Env.ZERO;
            BigDecimal qtyInvoiced = Env.ZERO;
            BigDecimal qtyDelivered = Env.ZERO;
            BigDecimal qtyInTransit = Env.ZERO;
            BigDecimal qtyOrdered = Env.ZERO;
            BigDecimal qty = Env.ZERO;
            BigDecimal qtyEntered = Env.ZERO;
            BigDecimal weight = Env.ZERO;
            BigDecimal volume = Env.ZERO;
            String deliveryRuleKey = null;
            boolean isStocked = false;
            int precision = 0;
            while (rs.next()) {
                ValueNamePair deliveryRule;
                warehouse = new KeyNamePair(rs.getInt("M_Warehouse_ID"), rs.getString("Warehouse"));
                documentNo = new KeyNamePair(rs.getInt("OrderLine_ID"), rs.getString("DocumentNo"));
                product = new KeyNamePair(rs.getInt("M_Product_ID"), rs.getString("Product"));
                productUOM = new KeyNamePair(rs.getInt("C_UOM_ID"), rs.getString("UOMSymbol"));
                qtyOnHand = rs.getBigDecimal("QtyOnHand");
                qtyOrdered = rs.getBigDecimal("QtyOrdered");
                orderUOM = new KeyNamePair(rs.getInt("Order_UOM_ID"), rs.getString("Order_UOMSymbol"));
                qtyReserved = rs.getBigDecimal("QtyReserved");
                qtyInvoiced = rs.getBigDecimal("QtyInvoiced");
                qtyDelivered = rs.getBigDecimal("QtyDelivered");
                qtyInTransit = rs.getBigDecimal("QtyLoc");
                qty = rs.getBigDecimal("Qty");
                weight = rs.getBigDecimal("Weight");
                volume = rs.getBigDecimal("Volume");
                deliveryRuleKey = rs.getString("DeliveryRule");
                qtyEntered = rs.getBigDecimal("QtyEntered");
                isStocked = (rs.getString("IsStocked") == null ? "N" : rs.getString("IsStocked")).equals("Y");
                precision = MUOM.getPrecision(Env.getCtx(), productUOM.getKey());
                if (qtyOnHand == null) {
                    qtyOnHand = Env.ZERO;
                }
                if (!isStocked) {
                    qtyOnHand = qty;
                }
                if (Util.isEmpty(deliveryRuleKey)) {
                    deliveryRuleKey = "A";
                }
                if (!(deliveryRule = new ValueNamePair(deliveryRuleKey, MRefList.getListName(Env.getCtx(), 151, deliveryRuleKey))).getID().equals("F") && !deliveryRule.getID().equals("M")) {
                    BigDecimal diff = (isStocked ? Env.ONE : Env.ZERO).multiply(qtyOnHand.subtract(qty).setScale(precision, 4));
                    if (diff.doubleValue() < 0.0) {
                        qty = qty.subtract(diff.abs()).setScale(precision, 4);
                    }
                    if (qty.doubleValue() <= 0.0) continue;
                }
                Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>();
                line.add(new Boolean(false));
                line.add(warehouse);
                line.add(documentNo);
                line.add(product);
                line.add(productUOM);
                line.add(qtyOnHand);
                line.add(qty);
                line.add(weight.multiply(qty));
                line.add(volume.multiply(qty));
                line.add(Env.ZERO);
                line.add(qtyEntered);
                line.add(orderUOM);
                line.add(qtyOrdered);
                line.add(qtyReserved);
                line.add(qtyInvoiced);
                line.add(qtyDelivered);
                line.add(qtyInTransit);
                line.add(deliveryRule);
                data.add(line);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sqlPrep.toString(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        DB.close(rs, pstmt);
        return data;
    }

    protected Vector<String> getOrderLineColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "DocumentNo")));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Product_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_UOM_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyOnHand"));
        columnNames.add(Msg.translate(Env.getCtx(), "Qty"));
        columnNames.add(Msg.translate(Env.getCtx(), "Weight") + (Util.isEmpty(this.uOMWeightSymbol) ? "" : " (" + this.uOMWeightSymbol + ")"));
        columnNames.add(Msg.translate(Env.getCtx(), "Volume") + (Util.isEmpty(this.uOMWeightSymbol) ? "" : " (" + this.uOMVolumeSymbol + ")"));
        columnNames.add(Msg.translate(Env.getCtx(), "LoadSequence"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyEntered"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_UOM_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyOrdered"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyReserved"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyInvoiced"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyDelivered"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyInTransit"));
        columnNames.add(Msg.translate(Env.getCtx(), "DeliveryRule"));
        return columnNames;
    }

    protected Vector<String> getStockColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate(Env.getCtx(), "M_Product_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_UOM_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyOnHand"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyInTransit"));
        columnNames.add(Msg.translate(Env.getCtx(), "Qty"));
        columnNames.add(Msg.translate(Env.getCtx(), "PickedQty"));
        return columnNames;
    }

    protected void setStockColumnClass(IMiniTable stockTable) {
        int i = 0;
        stockTable.setColumnClass(i++, String.class, true);
        stockTable.setColumnClass(i++, String.class, true);
        stockTable.setColumnClass(i++, String.class, true);
        stockTable.setColumnClass(i++, BigDecimal.class, true);
        stockTable.setColumnClass(i++, BigDecimal.class, true);
        stockTable.setColumnClass(i++, BigDecimal.class, true);
        stockTable.setColumnClass(i++, BigDecimal.class, true);
        stockTable.autoSize();
    }

    protected void setOrderLineColumnClass(IMiniTable orderLineTable) {
        int i = 0;
        orderLineTable.setColumnClass(i++, Boolean.class, false);
        orderLineTable.setColumnClass(i++, String.class, true);
        orderLineTable.setColumnClass(i++, String.class, true);
        orderLineTable.setColumnClass(i++, String.class, true);
        orderLineTable.setColumnClass(i++, String.class, true);
        orderLineTable.setColumnClass(i++, BigDecimal.class, true);
        orderLineTable.setColumnClass(i++, BigDecimal.class, false);
        orderLineTable.setColumnClass(i++, BigDecimal.class, true);
        orderLineTable.setColumnClass(i++, BigDecimal.class, true);
        orderLineTable.setColumnClass(i++, Integer.class, false);
        orderLineTable.setColumnClass(i++, BigDecimal.class, true);
        orderLineTable.setColumnClass(i++, String.class, true);
        orderLineTable.setColumnClass(i++, BigDecimal.class, true);
        orderLineTable.setColumnClass(i++, BigDecimal.class, true);
        orderLineTable.setColumnClass(i++, BigDecimal.class, true);
        orderLineTable.setColumnClass(i++, BigDecimal.class, true);
        orderLineTable.setColumnClass(i++, BigDecimal.class, true);
        orderLineTable.setColumnClass(i++, String.class, true);
        orderLineTable.autoSize();
    }

    public String validateQuantity(IMiniTable orderLineTable) {
        StringBuffer errorMessage = new StringBuffer();
        DecimalFormat format = DisplayType.getNumberFormat(22);
        for (int row = 0; row < orderLineTable.getRowCount(); ++row) {
            if (!((Boolean)orderLineTable.getValueAt(row, 0)).booleanValue()) continue;
            KeyNamePair order = (KeyNamePair)orderLineTable.getValueAt(row, 2);
            int productId = ((KeyNamePair)orderLineTable.getValueAt(row, 3)).getKey();
            BigDecimal qty = (BigDecimal)orderLineTable.getValueAt(row, 6);
            BigDecimal qtyOrdered = (BigDecimal)orderLineTable.getValueAt(row, 12);
            BigDecimal qtyOrderLine = (BigDecimal)orderLineTable.getValueAt(row, 16);
            BigDecimal qtyDelivered = (BigDecimal)orderLineTable.getValueAt(row, 15);
            KeyNamePair uom = (KeyNamePair)orderLineTable.getValueAt(row, 4);
            ValueNamePair deliveryRule = (ValueNamePair)orderLineTable.getValueAt(row, 17);
            MProduct product = MProduct.get(Env.getCtx(), productId);
            int precision = MUOM.getPrecision(Env.getCtx(), uom.getKey());
            if (deliveryRule.getID().equals("F") || deliveryRule.getID().equals("M")) continue;
            BigDecimal qtyAvailable = qtyOrdered.subtract(qtyDelivered).subtract(qtyOrderLine).setScale(precision, 4);
            if (!(qty.setScale(precision, 4).doubleValue() > qtyAvailable.doubleValue())) continue;
            if (errorMessage.length() > 0) {
                errorMessage.append(Env.NL);
            } else {
                errorMessage.append("@Error@ @Qty@ > @QtyAvailable@ ");
            }
            errorMessage.append("@C_Order_ID@ " + order.getName()).append(", @M_Product_ID@ " + product.getValue() + "-" + product.getName()).append(", @Qty@ " + format.format(qty)).append(", @QtyAvailable@ " + format.format(qtyAvailable));
        }
        if (errorMessage.length() > 0) {
            return errorMessage.toString();
        }
        return null;
    }

    public String generateLoadOrder(String trxName, IMiniTable orderLineTable) {
        int quantity = 0;
        int rows = orderLineTable.getRowCount();
        this.outBoundOrder = new MWMInOutBound(Env.getCtx(), 0, trxName);
        MWMInOutBoundLine outBoundOrderLine = null;
        BigDecimal totalWeight = Env.ZERO;
        BigDecimal totalVolume = Env.ZERO;
        if (this.orgId < 0) {
            this.orgId = Env.getAD_Org_ID(Env.getCtx());
        }
        if (this.warehouseId < 0) {
            this.warehouseId = Env.getContextAsInt(Env.getCtx(), "#M_Warehouse_ID");
        }
        this.outBoundOrder.setAD_Org_ID(this.orgId);
        this.outBoundOrder.setDateTrx(this.documentDate);
        this.outBoundOrder.setPickDate(this.documentDate);
        this.outBoundOrder.setShipDate(this.shipmentDate);
        if (this.docTypeTargetId > 0) {
            this.outBoundOrder.setC_DocType_ID(this.docTypeTargetId);
        } else {
            Optional<MDocType> defaultDocumentType = Arrays.asList(MDocType.getOfDocBaseType(Env.getCtx(), "WMO")).stream().filter(documentType -> documentType.isSOTrx()).findFirst();
            if (!defaultDocumentType.isPresent()) {
                throw new DocTypeNotFoundException("WMO", "");
            }
            this.outBoundOrder.setC_DocType_ID(defaultDocumentType.get().getC_DocType_ID());
            this.docTypeTargetId = defaultDocumentType.get().getC_DocType_ID();
        }
        String errorMessage = this.validateQuantity(orderLineTable);
        if (!Util.isEmpty(errorMessage)) {
            throw new AdempiereException(errorMessage);
        }
        if (this.warehouseId > 0) {
            this.outBoundOrder.setM_Warehouse_ID(this.warehouseId);
        }
        if (!Util.isEmpty(this.deliveryRule)) {
            this.outBoundOrder.setDeliveryRule(this.deliveryRule);
        }
        if (!Util.isEmpty(this.deliveryViaRule)) {
            this.outBoundOrder.setDeliveryViaRule(this.deliveryViaRule);
        }
        if (this.shipperId > 0) {
            this.outBoundOrder.setM_Shipper_ID(this.shipperId);
        }
        this.outBoundOrder.setDocStatus("DR");
        this.outBoundOrder.setIsSOTrx(true);
        this.outBoundOrder.saveEx();
        for (int i = 0; i < rows; ++i) {
            PO line;
            if (!((Boolean)orderLineTable.getValueAt(i, 0)).booleanValue()) continue;
            int orderLineId = ((KeyNamePair)orderLineTable.getValueAt(i, 2)).getKey();
            int productId = ((KeyNamePair)orderLineTable.getValueAt(i, 3)).getKey();
            BigDecimal qty = (BigDecimal)orderLineTable.getValueAt(i, 6);
            BigDecimal weight = (BigDecimal)orderLineTable.getValueAt(i, 7);
            BigDecimal volume = (BigDecimal)orderLineTable.getValueAt(i, 8);
            outBoundOrderLine = new MWMInOutBoundLine(this.outBoundOrder);
            outBoundOrderLine.setAD_Org_ID(this.orgId);
            MProduct product = MProduct.get(Env.getCtx(), productId);
            if (this.movementType.equals("DD_Order")) {
                outBoundOrderLine.setDD_OrderLine_ID(orderLineId);
                line = new MDDOrderLine(Env.getCtx(), orderLineId, trxName);
                outBoundOrderLine.setDD_Order_ID(((X_DD_OrderLine)line).getDD_Order_ID());
                outBoundOrderLine.setDD_OrderLine_ID(((X_DD_OrderLine)line).getDD_OrderLine_ID());
                outBoundOrderLine.setM_AttributeSetInstance_ID(((X_DD_OrderLine)line).getM_AttributeSetInstance_ID());
                outBoundOrderLine.setC_UOM_ID(product.getC_UOM_ID());
                outBoundOrderLine.setM_Locator_ID(((X_DD_OrderLine)line).getM_Locator_ID());
                outBoundOrderLine.setM_LocatorTo_ID(((X_DD_OrderLine)line).getM_LocatorTo_ID());
            } else {
                outBoundOrderLine.setC_OrderLine_ID(orderLineId);
                line = new MOrderLine(Env.getCtx(), orderLineId, trxName);
                outBoundOrderLine.setC_Order_ID(((X_C_OrderLine)line).getC_Order_ID());
                outBoundOrderLine.setC_OrderLine_ID(((X_C_OrderLine)line).getC_OrderLine_ID());
                outBoundOrderLine.setM_AttributeSetInstance_ID(((X_C_OrderLine)line).getM_AttributeSetInstance_ID());
                outBoundOrderLine.setC_UOM_ID(product.getC_UOM_ID());
                if (this.locatorId == null) {
                    this.locatorId = this.getDefaultLocator(((X_C_OrderLine)line).getM_Warehouse_ID(), productId, ((X_C_OrderLine)line).getM_AttributeSetInstance_ID(), qty, trxName);
                }
                outBoundOrderLine.setM_LocatorTo_ID(this.locatorId);
            }
            outBoundOrderLine.setM_Product_ID(productId);
            outBoundOrderLine.setMovementQty(qty);
            outBoundOrderLine.setPickedQty(qty);
            totalWeight = totalWeight.add(weight);
            totalVolume = totalVolume.add(volume);
            outBoundOrderLine.saveEx();
            ++quantity;
        }
        this.outBoundOrder.setWeight(totalWeight);
        this.outBoundOrder.setVolume(totalVolume);
        this.outBoundOrder.saveEx();
        if (Util.isEmpty(this.documentAction)) {
            this.documentAction = "CO";
        }
        this.outBoundOrder.setDocAction(this.documentAction);
        this.outBoundOrder.processIt(this.documentAction);
        this.outBoundOrder.saveEx();
        errorMessage = this.outBoundOrder.getProcessMsg();
        if (errorMessage != null && this.outBoundOrder.getDocStatus().equals("IN")) {
            throw new AdempiereException(errorMessage);
        }
        return Msg.parseTranslation(Env.getCtx(), "@Created@ = [" + this.outBoundOrder.getDocumentNo() + "] || @LineNo@ = [" + quantity + "]" + (errorMessage != null ? "\n@Errors@:" + errorMessage : ""));
    }

    private int getDefaultLocator(int warehouseId, int productId, int attributeSetInstanceId, BigDecimal quantity, String transactionName) {
        int locatorId = MStorage.getM_Locator_ID(warehouseId, productId, attributeSetInstanceId, quantity, transactionName);
        if (locatorId > 0) {
            return locatorId;
        }
        MWarehouse warehouse = MWarehouse.get(Env.getCtx(), warehouseId);
        MLocator locator = MLocator.getDefault(warehouse);
        if (locator == null) {
            MProduct product = MProduct.get(Env.getCtx(), productId);
            throw new AdempiereException("@M_Locator_ID@ @NotFound@ [@M_Product_ID@: " + product.getValue() + " - " + product.getName() + " @M_Warehouse_ID@: " + warehouse.getName() + "]");
        }
        return locator.getM_Locator_ID();
    }

    protected void loadDefaultValues() {
        this.uOMWeightId = this.getC_UOM_Weight_ID();
        this.uOMVolumeId = this.getC_UOM_Volume_ID();
        if (this.uOMWeightId > 0) {
            this.weightPrecision = MUOM.getPrecision(Env.getCtx(), this.uOMWeightId);
        }
        if (this.uOMVolumeId > 0) {
            this.volumePrecision = MUOM.getPrecision(Env.getCtx(), this.uOMVolumeId);
        }
    }

    protected int getC_UOM_Weight_ID() {
        return DB.getSQLValue(null, "SELECT ci.C_UOM_Weight_ID FROM AD_ClientInfo ci WHERE ci.AD_Client_ID = ?", this.clientId);
    }

    protected int getC_UOM_Volume_ID() {
        return DB.getSQLValue(null, "SELECT ci.C_UOM_Volume_ID FROM AD_ClientInfo ci WHERE ci.AD_Client_ID = ?", this.clientId);
    }

    protected KeyNamePair[] getDataDocumentType() {
        if (this.movementType == null) {
            return null;
        }
        String docBaseType = this.movementType.equals("DD_Order") ? "DOO" : "SOO";
        String sql = MRole.getDefault().addAccessSQL("SELECT doc.C_DocType_ID, TRIM(doc.Name) FROM C_DocType doc WHERE doc.DocBaseType = '" + docBaseType + "' AND (doc.DocSubTypeSO IS NULL OR doc.DocSubTypeSO NOT IN('RM', 'OB')) ORDER BY doc.Name", "doc", true, true);
        return DB.getKeyNamePairs(null, sql, false, new Object[0]);
    }

    protected KeyNamePair[] getDataWarehouse() {
        String sql = "SELECT w.M_Warehouse_ID, w.Name FROM M_Warehouse w WHERE w.IsActive = 'Y' AND w.AD_Org_ID = " + this.orgId + " ORDER BY w.Name";
        return DB.getKeyNamePairs(null, sql, false, new Object[0]);
    }

    protected BigDecimal getQtyInTransit(int productId, int warehouseId) {
        if (productId == 0 || warehouseId == 0) {
            return Env.ZERO;
        }
        String sql = "SELECT COALESCE(SUM(lc.MovementQty), 0) QtyLoc FROM WM_InOutBound c INNER JOIN WM_InOutBoundLine lc ON(lc.WM_InOutBound_ID = c.WM_InOutBound_ID) WHERE lc.M_Product_ID = ? AND lc.M_Warehouse_ID = ? AND c.DocStatus = 'CO' AND c.IsDelivered = 'N'";
        BigDecimal quantityInTransit = DB.getSQLValueBD(null, sql, productId, warehouseId);
        if (quantityInTransit == null) {
            quantityInTransit = Env.ZERO;
        }
        return quantityInTransit;
    }

    public boolean existsSeqNo(IMiniTable orderLineTable, int row, int seqNo) {
        log.info("existsSeqNo");
        int rows = orderLineTable.getRowCount();
        int seqNoTable = 0;
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)orderLineTable.getValueAt(i, 0)).booleanValue() || i == row || seqNo != (seqNoTable = ((Integer)orderLineTable.getValueAt(i, 9)).intValue())) continue;
            return true;
        }
        return false;
    }

    public String validStock(IMiniTable stockTable) {
        log.info("validStock");
        return null;
    }

    public void loadBuffer(IMiniTable orderLineTable) {
        log.info("Load Buffer");
        int rows = orderLineTable.getRowCount();
        int m_C_OrderLine_ID = 0;
        BigDecimal qty = Env.ZERO;
        Integer seqNo = 0;
        this.m_BufferSelect = new Vector();
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)orderLineTable.getValueAt(i, 0)).booleanValue()) continue;
            m_C_OrderLine_ID = ((KeyNamePair)orderLineTable.getValueAt(i, 2)).getKey();
            qty = (BigDecimal)orderLineTable.getValueAt(i, 6);
            seqNo = (Integer)orderLineTable.getValueAt(i, 9);
            this.m_BufferSelect.addElement(new BufferTableSelect(m_C_OrderLine_ID, qty, seqNo));
        }
    }

    private BufferTableSelect isSelect(int m_Record_ID) {
        log.info("Is Select " + m_Record_ID);
        if (this.m_BufferSelect != null) {
            for (int i = 0; i < this.m_BufferSelect.size(); ++i) {
                if (this.m_BufferSelect.get(i).getRecord_ID() != m_Record_ID) continue;
                return this.m_BufferSelect.get(i);
            }
        }
        return null;
    }

    protected void setValueFromBuffer(IMiniTable orderLineTable) {
        log.info("Set Value From Buffer");
        if (this.m_BufferSelect != null) {
            int rows = orderLineTable.getRowCount();
            int m_C_OrderLine_ID = 0;
            BufferTableSelect bts = null;
            for (int i = 0; i < rows; ++i) {
                m_C_OrderLine_ID = ((KeyNamePair)orderLineTable.getValueAt(i, 2)).getKey();
                bts = this.isSelect(m_C_OrderLine_ID);
                if (bts == null) continue;
                orderLineTable.setValueAt(true, i, 0);
                orderLineTable.setValueAt(bts.getQty(), i, 6);
                orderLineTable.setValueAt(bts.getSeqNo(), i, 9);
            }
        }
    }

    protected boolean moreOneSelect(IMiniTable table) {
        int rows = table.getRowCount();
        int cont = 0;
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)table.getValueAt(i, 0)).booleanValue() || ++cont <= 1) continue;
            return true;
        }
        return false;
    }

    public class BufferTableSelect {
        private int recordId = 0;
        private BigDecimal qty = Env.ZERO;
        private Integer seqNo = 0;

        public BufferTableSelect(int recordId, BigDecimal qty, Integer seqNo) {
            this.recordId = recordId;
            this.qty = qty;
            this.seqNo = seqNo;
        }

        public void setRecord_ID(int recordId) {
            this.recordId = recordId;
        }

        public int getRecord_ID() {
            return this.recordId;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setSeqNo(Integer seqNo) {
            this.seqNo = seqNo;
        }

        public Integer getSeqNo() {
            return this.seqNo;
        }

        public String toString() {
            return "Record_ID = " + this.recordId + " qty = " + this.qty + "seqNo = " + this.seqNo;
        }
    }
}

