/*
 * Decompiled with CFR 0.152.
 */
package org.spin.authentication.services.provider;

import com.nimbusds.oauth2.sdk.ResponseType;
import java.util.Optional;
import org.spin.authentication.services.OpenIDConnect;
import org.spin.model.MADAppRegistration;

public class MicrosoftAuthentication
extends OpenIDConnect {
    private static final String[] defaultScope = new String[]{"openid", "email", "profile"};
    private static final String issuerParameter = "ISSUER";
    private static final String defaultIssuerValue = "consumers";
    private static final String issuerURIParameter = "<issuer>";
    private String authorizationEndPoint = "https://login.microsoftonline.com/".concat("<issuer>").concat("/oauth2/v2.0/authorize");
    private static final String userInfoEndPoint = "https://graph.microsoft.com/oidc/userinfo";
    private String tokenEndPoint = "https://login.microsoftonline.com/".concat("<issuer>").concat("/oauth2/v2.0/token");

    public MicrosoftAuthentication() {
        this.setResponseType(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}));
        this.setUserInfoEndpoint(userInfoEndPoint);
        this.setScope(defaultScope);
    }

    @Override
    public void setAppRegistrationId(int registrationId) {
        super.setAppRegistrationId(registrationId);
        Optional<MADAppRegistration> maybeApRegistration = Optional.ofNullable(this.getApplicationRegistration());
        maybeApRegistration.ifPresent(appRegistration -> {
            Optional<String> maybeIssuer = Optional.ofNullable(appRegistration.getParameterValue(issuerParameter));
            String issuer = maybeIssuer.orElse(defaultIssuerValue);
            this.authorizationEndPoint = this.authorizationEndPoint.replace(issuerURIParameter, issuer);
            this.tokenEndPoint = this.tokenEndPoint.replace(issuerURIParameter, issuer);
            this.setAuthorizationEndPoint(this.authorizationEndPoint);
            this.setTokenEndpoint(this.tokenEndPoint);
        });
    }
}

