/*
 * Decompiled with CFR 0.152.
 */
package org.spin.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.compiere.impexp.BankStatementMatchInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MBankStatementMatcher;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.model.X_I_BankStatement;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class BankStatementMatchController {
    public CLogger log = CLogger.getCLogger(BankStatementMatchController.class);
    private int bankAccountId;
    private int windowNo = 0;
    private MBankStatement bankStatement = null;
    private String languageValue = null;
    private Map<Integer, X_I_BankStatement> importedPaymentHashMap = new HashMap<Integer, X_I_BankStatement>();
    private Map<Integer, MPayment> currentPaymentHashMap = new HashMap<Integer, MPayment>();
    private Map<Integer, X_I_BankStatement> matchedPaymentHashMap = new HashMap<Integer, X_I_BankStatement>();
    private Vector<Vector<Object>> paymentData = new Vector();
    private MBankAccount account = null;
    private BigDecimal amtFrom = null;
    private BigDecimal amtTo = null;
    private Timestamp dateFrom = null;
    private Timestamp dateTo = null;
    private int bpartnerId = 0;
    private int matchMode = -1;
    private int currentSelectedPaymentId = 0;
    private int currentSelectedImportedPaymentId = 0;
    private boolean hasSelection = false;
    public String[] m_matchMode = new String[]{Msg.translate(Env.getCtx(), "NotMatched"), Msg.translate(Env.getCtx(), "Matched")};
    public static final int MODE_NOTMATCHED = 0;
    public static final int MODE_MATCHED = 1;

    public void init(int windowNo, ProcessInfo processInfo) {
        this.setFromPO(processInfo);
        this.windowNo = windowNo;
        this.languageValue = Env.getAD_Language(Env.getCtx());
    }

    public void clear() {
        this.matchedPaymentHashMap = new HashMap<Integer, X_I_BankStatement>();
        this.resetManualMatch();
    }

    public boolean isFromStatement() {
        return this.bankStatement != null;
    }

    public Timestamp getStatementDate() {
        if (this.isFromStatement()) {
            return this.bankStatement.getStatementDate();
        }
        return null;
    }

    public String getButtonMatchMessage(boolean isMatchMode) {
        if (isMatchMode) {
            return Msg.translate(Env.getCtx(), "BankStatementMatch.SimulateUnMatch");
        }
        return Msg.translate(Env.getCtx(), "BankStatementMatch.SimulateMatch");
    }

    public String getButtonMatchMessage() {
        return this.getButtonMatchMessage(this.isMatchedMode());
    }

    public String getAskMatchMessage() {
        if (this.isMatchedMode()) {
            return Msg.translate(Env.getCtx(), "BankStatementMatch.AskUnMatch");
        }
        return Msg.translate(Env.getCtx(), "BankStatementMatch.AskMatch");
    }

    public boolean isMatchedMode() {
        return this.getMatchedMode() == 1;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public void dynInit() throws Exception {
        this.setFromPO(null);
    }

    public void setFromPO(ProcessInfo processInfo) {
        if (processInfo != null && processInfo.getTable_ID() > 0 && processInfo.getRecord_ID() > 0) {
            this.bankStatement = new MBankStatement(Env.getCtx(), processInfo.getRecord_ID(), processInfo.getTransactionName());
            this.bankAccountId = this.bankStatement.getC_BankAccount_ID();
            this.setBankAccountId(this.bankAccountId);
        }
    }

    public void setBankAccountId(int bankAccountId) {
        this.bankAccountId = bankAccountId;
        if (bankAccountId > 0) {
            this.account = MBankAccount.get(Env.getCtx(), bankAccountId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Vector<Object>> getPaymentData() {
        this.paymentData = new Vector();
        StringBuffer sql = new StringBuffer("SELECT p.C_Payment_ID, p.DateTrx, p.IsReceipt, p.DocumentNo, p.C_BPartner_ID, bp.Name BPName, tt.TenderTypeName AS TenderType, c.ISO_Code, (p.PayAmt * CASE WHEN p.IsReceipt = 'Y' THEN 1 ELSE -1 END) AS PayAmt, p.Description, p.* FROM C_Payment p INNER JOIN C_BPartner bp ON(bp.C_BPartner_ID = p.C_BPartner_ID) INNER JOIN C_Currency c ON(c.C_Currency_ID = p.C_Currency_ID) INNER JOIN (SELECT tt.Value AS TenderType, COALESCE(ttr.Name, tt.Name) AS TenderTypeName\t\t\t\tFROM AD_Ref_List tt\t\t\t\tLEFT JOIN AD_Ref_List_Trl ttr ON(ttr.AD_Ref_List_ID = tt.AD_Ref_List_ID AND AD_Language = '" + this.languageValue + "')\t\t\t\tWHERE tt.AD_Reference_ID=214) tt ON(tt.TenderType = p.TenderType) ");
        sql.append("WHERE p.C_BankAccount_ID = ? ");
        sql.append(" AND p.DocStatus NOT IN('IP', 'DR') ");
        sql.append(" AND p.IsReconciled = 'N' ");
        if (this.bankStatement != null) {
            sql.append("AND NOT EXISTS(SELECT 1 FROM C_BankStatement bs INNER JOIN C_BankStatementLine bsl ON(bsl.C_BankStatement_ID = bs.C_BankStatement_ID) WHERE bsl.C_Payment_ID = p.C_Payment_ID AND bs.DocStatus IN('CO', 'CL') AND bsl.C_BankStatement_ID <> ").append(this.bankStatement.getC_BankStatement_ID()).append(") ");
        }
        if (this.isMatchedMode()) {
            sql.append("AND EXISTS(SELECT 1 FROM I_BankStatement ibs WHERE (ibs.C_Payment_ID = p.C_Payment_ID))");
        } else {
            sql.append("AND NOT EXISTS(SELECT 1 FROM I_BankStatement ibs WHERE ibs.C_Payment_ID = p.C_Payment_ID)");
        }
        if (this.getDateFrom() != null) {
            sql.append("AND p.DateTrx >= ? ");
        }
        if (this.getDateTo() != null) {
            sql.append("AND p.DateTrx <= ? ");
        }
        if (this.getAmtFrom() != null) {
            sql.append("AND p.PayAmt >= ? ");
        }
        if (this.getAmtTo() != null) {
            sql.append("AND p.PayAmt <= ? ");
        }
        if (this.getBpartnerId() > 0) {
            sql.append("AND p.C_BPartner_ID = ? ");
        }
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "p", true, false));
        sql.append("ORDER BY p.DateTrx");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        this.currentPaymentHashMap = new HashMap<Integer, MPayment>();
        try {
            int i = 1;
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(i++, this.bankAccountId);
            if (this.getDateFrom() != null) {
                pstmt.setTimestamp(i++, this.getDateFrom());
            }
            if (this.getDateTo() != null) {
                pstmt.setTimestamp(i++, this.getDateTo());
            }
            if (this.getAmtFrom() != null) {
                pstmt.setBigDecimal(i++, this.getAmtFrom());
            }
            if (this.getAmtTo() != null) {
                pstmt.setBigDecimal(i++, this.getAmtTo());
            }
            if (this.getBpartnerId() > 0) {
                pstmt.setInt(i++, this.getBpartnerId());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new IDColumn(rs.getInt("C_Payment_ID")));
                line.add(rs.getTimestamp("DateTrx"));
                line.add(rs.getString("IsReceipt").equals("Y"));
                line.add(rs.getString("DocumentNo"));
                KeyNamePair pp = new KeyNamePair(rs.getInt("C_BPartner_ID"), rs.getString("BPName"));
                line.add(pp);
                line.add(rs.getString("TenderType"));
                line.add(rs.getString("ISO_Code"));
                line.add(rs.getBigDecimal("PayAmt"));
                line.add(rs.getString("Description"));
                this.currentPaymentHashMap.put(rs.getInt("C_Payment_ID"), new MPayment(Env.getCtx(), rs, null));
                this.paymentData.add(line);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, sql.toString(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return this.paymentData;
    }

    public Vector<String> getImportedPaymentColumnNames() {
        Vector<String> columnNames = new Vector<String>(8);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "DateTrx"));
        columnNames.add(Msg.translate(Env.getCtx(), "IsReceipt"));
        columnNames.add(Msg.translate(Env.getCtx(), "ReferenceNo"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        columnNames.add(Msg.translate(Env.getCtx(), "Memo"));
        return columnNames;
    }

    public void configureImportedPaymentTable(IMiniTable miniTable) {
        miniTable.setKeyColumnIndex(0);
        miniTable.setColumnClass(0, IDColumn.class, true, this.getImportedPaymentColumnNames().get(0));
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, Boolean.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, BigDecimal.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.autoSize();
    }

    public Vector<String> getCurrentPaymentColumnNames() {
        Vector<String> columnNames = new Vector<String>(9);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "DateTrx"));
        columnNames.add(Msg.translate(Env.getCtx(), "IsReceipt"));
        columnNames.add(Msg.translate(Env.getCtx(), "DocumentNo"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "TenderType"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        columnNames.add(Msg.translate(Env.getCtx(), "Description"));
        return columnNames;
    }

    public void configureCurrentPaymentTable(IMiniTable miniTable) {
        miniTable.setKeyColumnIndex(0);
        miniTable.setColumnClass(0, IDColumn.class, true, this.getCurrentPaymentColumnNames().get(0));
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, Boolean.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, BigDecimal.class, true);
        miniTable.setColumnClass(8, String.class, true);
        miniTable.autoSize();
    }

    public Vector<String> getMatchedPaymentColumnNames() {
        Vector<String> columnNames = new Vector<String>(11);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "DateTrx"));
        columnNames.add(Msg.translate(Env.getCtx(), "IsReceipt"));
        columnNames.add(Msg.translate(Env.getCtx(), "DocumentNo"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "TenderType"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        columnNames.add(Msg.translate(Env.getCtx(), "Description"));
        columnNames.add(Msg.translate(Env.getCtx(), "ReferenceNo"));
        columnNames.add(Msg.translate(Env.getCtx(), "Memo"));
        return columnNames;
    }

    public void configureMatchedPaymentTable(IMiniTable miniTable) {
        miniTable.setKeyColumnIndex(0);
        miniTable.setColumnClass(0, IDColumn.class, true, this.getMatchedPaymentColumnNames().get(0));
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, Boolean.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, BigDecimal.class, true);
        miniTable.setColumnClass(8, String.class, true);
        miniTable.setColumnClass(9, String.class, true);
        miniTable.setColumnClass(10, String.class, true);
        miniTable.autoSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Vector<Object>> getImportedPaymentData() {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT p.I_BankStatement_ID, p.StatementLineDate, (CASE WHEN p.TrxAmt < 0 THEN 'N' ELSE 'Y' END) AS IsReceipt, p.ReferenceNo, p.C_BPartner_ID, (CASE WHEN p.C_BPartner_ID IS NULL THEN BPartnerValue ELSE bp.Name END) BPName, COALESCE(p.ISO_Code, c.ISO_Code) AS ISO_Code, p.TrxAmt, p.Memo, p.* FROM I_BankStatement p LEFT JOIN C_BPartner bp ON(bp.C_BPartner_ID = p.C_BPartner_ID) LEFT JOIN C_Currency c ON(c.C_Currency_ID = p.C_Currency_ID) ");
        sql.append("WHERE p.C_BankAccount_ID = ? ");
        if (this.isMatchedMode()) {
            sql.append("AND (p.C_Payment_ID IS NOT NULL OR p.C_BPartner_ID IS NOT NULL OR p.C_Invoice_ID IS NOT NULL) ");
        } else {
            sql.append("AND (p.C_Payment_ID IS NULL AND p.C_BPartner_ID IS NULL AND p.C_Invoice_ID IS NULL) ");
        }
        if (this.getDateFrom() != null) {
            sql.append("AND p.StatementLineDate >= ? ");
        }
        if (this.getDateTo() != null) {
            sql.append("AND p.StatementLineDate <= ? ");
        }
        if (this.getAmtFrom() != null) {
            sql.append("AND p.TrxAmt >= ? ");
        }
        if (this.getAmtTo() != null) {
            sql.append("AND p.TrxAmt <= ? ");
        }
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "p", true, false));
        sql.append("ORDER BY p.StatementLineDate");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        this.importedPaymentHashMap = new HashMap<Integer, X_I_BankStatement>();
        try {
            int i = 1;
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(i++, this.bankAccountId);
            if (this.getDateFrom() != null) {
                pstmt.setTimestamp(i++, this.getDateFrom());
            }
            if (this.getDateTo() != null) {
                pstmt.setTimestamp(i++, this.getDateTo());
            }
            if (this.getAmtFrom() != null) {
                pstmt.setBigDecimal(i++, this.getAmtFrom());
            }
            if (this.getAmtTo() != null) {
                pstmt.setBigDecimal(i++, this.getAmtTo());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new IDColumn(rs.getInt("I_BankStatement_ID")));
                line.add(rs.getTimestamp("StatementLineDate"));
                line.add(rs.getString("IsReceipt").equals("Y"));
                line.add(rs.getString("ReferenceNo"));
                KeyNamePair pp = new KeyNamePair(rs.getInt("C_BPartner_ID"), rs.getString("BPName"));
                line.add(pp);
                line.add(rs.getString("ISO_Code"));
                line.add(rs.getBigDecimal("TrxAmt"));
                line.add(rs.getString("Memo"));
                data.add(line);
                this.importedPaymentHashMap.put(rs.getInt("I_BankStatement_ID"), new X_I_BankStatement(Env.getCtx(), rs, null));
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, sql.toString(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return data;
    }

    public int actionMatchUnMatch() {
        int processed = 0;
        this.matchedPaymentHashMap = new HashMap<Integer, X_I_BankStatement>();
        if (this.importedPaymentHashMap.isEmpty()) {
            return 0;
        }
        processed = !this.isMatchedMode() ? this.findMatch() : this.unMatch();
        return processed;
    }

    public int actionUnMatchSelected(IMiniTable matched) {
        int processed = 0;
        int rows = matched.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn selection = (IDColumn)matched.getValueAt(i, 0);
            if (!selection.isSelected()) continue;
            this.matchedPaymentHashMap.remove(selection.getRecord_ID());
            ++processed;
        }
        return processed;
    }

    public boolean actionFindManualMatch(int paymentId, int bankStatementId) {
        boolean processed = false;
        if (this.importedPaymentHashMap.isEmpty()) {
            return processed;
        }
        processed = !this.isMatchedMode() ? this.findManualMatch(0, 0) : this.findManualUnMatch(paymentId, bankStatementId);
        return processed;
    }

    private int unMatch() {
        int matched = 0;
        for (Map.Entry<Integer, X_I_BankStatement> entry : this.importedPaymentHashMap.entrySet()) {
            X_I_BankStatement currentpayment = entry.getValue();
            if (currentpayment.getC_Payment_ID() == 0 && currentpayment.getC_BPartner_ID() == 0 && currentpayment.getC_Invoice_ID() == 0) continue;
            this.matchedPaymentHashMap.put(entry.getValue().getC_Payment_ID(), currentpayment);
            if (currentpayment.getC_Payment_ID() != 0) {
                currentpayment.setC_Payment_ID(-1);
            }
            if (currentpayment.getC_BPartner_ID() != 0) {
                currentpayment.setC_BPartner_ID(-1);
            }
            if (currentpayment.getC_Invoice_ID() != 0) {
                currentpayment.setC_Invoice_ID(-1);
            }
            ++matched;
        }
        return matched;
    }

    public boolean findManualMatch(int paymentId, int bankStatementId) {
        X_I_BankStatement importedPayment = this.importedPaymentHashMap.get(bankStatementId);
        MPayment currentPayment = this.currentPaymentHashMap.get(paymentId);
        boolean processed = false;
        if (importedPayment != null && currentPayment != null) {
            if (currentPayment.getPayAmt().doubleValue() == importedPayment.getTrxAmt().doubleValue() && currentPayment.getC_Currency_ID() == importedPayment.getC_Currency_ID()) {
                importedPayment.setC_Payment_ID(paymentId);
                this.matchedPaymentHashMap.put(paymentId, importedPayment);
                processed = true;
            }
            this.resetManualMatch();
        }
        if (processed) {
            this.deleteOldMatchedImportedPayment(paymentId, bankStatementId);
        }
        return processed;
    }

    private void deleteOldMatchedImportedPayment(int paymentId, int importedPaymentId) {
        Map.Entry<Integer, X_I_BankStatement> entry;
        X_I_BankStatement currentPayment;
        int oldpaymentId = 0;
        Iterator<Map.Entry<Integer, X_I_BankStatement>> iterator = this.matchedPaymentHashMap.entrySet().iterator();
        while (iterator.hasNext() && ((currentPayment = (entry = iterator.next()).getValue()).getI_BankStatement_ID() != importedPaymentId || (oldpaymentId = entry.getKey().intValue()) == paymentId)) {
        }
        if (oldpaymentId > 0 && paymentId != oldpaymentId) {
            this.matchedPaymentHashMap.remove(oldpaymentId);
        }
    }

    public boolean paymentApplyForMatch(int paymentId) {
        this.currentSelectedPaymentId = paymentId;
        return this.applyManualMatch();
    }

    public boolean importedPaymentApplyForMatch(int importedPaymentId) {
        this.currentSelectedImportedPaymentId = importedPaymentId;
        return this.applyManualMatch();
    }

    private boolean applyManualMatch() {
        boolean ok = false;
        if (this.currentSelectedImportedPaymentId > 0 && this.currentSelectedPaymentId > 0) {
            ok = this.findManualMatch(this.currentSelectedPaymentId, this.currentSelectedImportedPaymentId);
        }
        return ok;
    }

    public int getImportedPaymentId(int paymentId) {
        X_I_BankStatement currentPayment = this.matchedPaymentHashMap.get(paymentId);
        if (currentPayment != null) {
            return currentPayment.getI_BankStatement_ID();
        }
        return -1;
    }

    public void resetManualMatch() {
        this.currentSelectedPaymentId = 0;
        this.currentSelectedImportedPaymentId = 0;
    }

    private boolean findManualUnMatch(int paymentId, int bankStatementId) {
        X_I_BankStatement currentPayment = this.importedPaymentHashMap.get(bankStatementId);
        if (currentPayment != null) {
            if (currentPayment.getC_Payment_ID() != 0) {
                currentPayment.setC_Payment_ID(-1);
            }
            if (currentPayment.getC_BPartner_ID() != 0) {
                currentPayment.setC_BPartner_ID(-1);
            }
            if (currentPayment.getC_Invoice_ID() != 0) {
                currentPayment.setC_Invoice_ID(-1);
            }
            this.matchedPaymentHashMap.put(paymentId, currentPayment);
            return true;
        }
        return false;
    }

    private int findMatch() {
        List<MBankStatementMatcher> matchersList;
        int matched = 0;
        int bankId = 0;
        if (this.account != null) {
            bankId = this.account.getC_Bank_ID();
        }
        if ((matchersList = MBankStatementMatcher.getMatchersList(Env.getCtx(), bankId)) == null) {
            return 0;
        }
        block0: for (Map.Entry<Integer, X_I_BankStatement> entry : this.importedPaymentHashMap.entrySet()) {
            X_I_BankStatement currentBankStatementImport = entry.getValue();
            if (currentBankStatementImport.getC_Payment_ID() != 0 || currentBankStatementImport.getC_BPartner_ID() != 0 || currentBankStatementImport.getC_Invoice_ID() != 0) {
                this.matchedPaymentHashMap.put(entry.getValue().getC_Payment_ID(), currentBankStatementImport);
                ++matched;
                continue;
            }
            for (MBankStatementMatcher matcher : matchersList) {
                BankStatementMatchInfo info;
                if (!matcher.isMatcherValid() || (info = matcher.getMatcher().findMatch(currentBankStatementImport, this.currentPaymentHashMap.keySet().stream().collect(Collectors.toList()), this.matchedPaymentHashMap.keySet().stream().collect(Collectors.toList()))) == null || !info.isMatched() || this.matchedPaymentHashMap.containsKey(info.getC_Payment_ID())) continue;
                if (info.getC_Payment_ID() > 0) {
                    currentBankStatementImport.setC_Payment_ID(info.getC_Payment_ID());
                }
                if (info.getC_Invoice_ID() > 0) {
                    currentBankStatementImport.setC_Invoice_ID(info.getC_Invoice_ID());
                }
                if (info.getC_BPartner_ID() > 0) {
                    currentBankStatementImport.setC_BPartner_ID(info.getC_BPartner_ID());
                }
                this.matchedPaymentHashMap.put(entry.getValue().getC_Payment_ID(), currentBankStatementImport);
                ++matched;
                continue block0;
            }
        }
        return matched;
    }

    public Vector<Vector<Object>> getMatchedPayments() {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        for (Vector<Object> row : this.paymentData) {
            IDColumn key = (IDColumn)row.get(0);
            X_I_BankStatement matched = this.matchedPaymentHashMap.get(key.getRecord_ID());
            if (matched == null || !matched.is_Changed()) continue;
            row.add(matched.getReferenceNo());
            row.add(matched.getMemo());
            data.add(row);
        }
        return data;
    }

    public void clearSelection(IMiniTable table) {
        for (int row = 0; row < table.getRowCount(); ++row) {
            IDColumn id = (IDColumn)table.getValueAt(row, 0);
            id.setSelected(false);
        }
    }

    public String saveData(int m_WindowNo, String trxName) {
        AtomicInteger processed = new AtomicInteger();
        AtomicInteger lineNo = new AtomicInteger(10);
        int defaultChargeId = DB.getSQLValue(null, "SELECT MAX(C_Charge_ID) FROM C_Charge WHERE AD_Client_ID = ?", Env.getAD_Client_ID(Env.getCtx()));
        if (defaultChargeId <= 0) {
            return Msg.parseTranslation(Env.getCtx(), "@C_Charge_ID@ @NotFound@");
        }
        this.importedPaymentHashMap.entrySet().stream().forEach(entry -> {
            X_I_BankStatement currentBankStatementImport = (X_I_BankStatement)entry.getValue();
            currentBankStatementImport.set_TrxName(trxName);
            currentBankStatementImport.saveEx();
            if (this.bankStatement != null && !this.bankStatement.isProcessed()) {
                if (currentBankStatementImport.getC_Payment_ID() <= 0 && currentBankStatementImport.getC_Charge_ID() <= 0) {
                    currentBankStatementImport.setC_Charge_ID(defaultChargeId);
                }
                if (currentBankStatementImport.getC_BankStatementLine_ID() == 0) {
                    this.importMatched(currentBankStatementImport, lineNo.get());
                    lineNo.addAndGet(10);
                } else {
                    MBankStatementLine currentStatementLine = new MBankStatementLine(Env.getCtx(), currentBankStatementImport.getC_BankStatementLine_ID(), trxName);
                    if (currentBankStatementImport.getC_Payment_ID() == 0) {
                        currentStatementLine.setC_Payment_ID(-1);
                    } else {
                        currentStatementLine.setC_Payment_ID(currentBankStatementImport.getC_Payment_ID());
                    }
                    if (currentBankStatementImport.getC_BPartner_ID() == 0) {
                        currentStatementLine.setC_BPartner_ID(-1);
                    } else {
                        currentStatementLine.setC_BPartner_ID(currentBankStatementImport.getC_BPartner_ID());
                    }
                    if (currentBankStatementImport.getC_Invoice_ID() == 0) {
                        currentStatementLine.setC_Invoice_ID(-1);
                    } else {
                        currentStatementLine.setC_Invoice_ID(currentBankStatementImport.getC_Invoice_ID());
                    }
                    currentStatementLine.saveEx();
                }
                currentBankStatementImport.saveEx();
            }
            processed.addAndGet(1);
        });
        return Msg.translate(Env.getCtx(), "BankStatementMatch.MatchedProcessed") + ": " + processed;
    }

    private void importMatched(X_I_BankStatement toBeImport, int lineNo) {
        if (!this.isFromStatement()) {
            return;
        }
        MBankStatementLine lineToImport = new MBankStatementLine(this.bankStatement, toBeImport, lineNo);
        lineToImport.saveEx();
        toBeImport.setC_BankStatement_ID(this.bankStatement.getC_BankStatement_ID());
        toBeImport.setC_BankStatementLine_ID(lineToImport.getC_BankStatementLine_ID());
        toBeImport.setI_IsImported(true);
        toBeImport.setProcessed(true);
        toBeImport.saveEx();
    }

    public void selectFromMatch(IMiniTable currentPaymentTable, IMiniTable importedPaymentTable, int paymentId) {
        for (int row = 0; row < currentPaymentTable.getRowCount(); ++row) {
            IDColumn record = (IDColumn)currentPaymentTable.getValueAt(row, 0);
            if (record == null || record.getRecord_ID() != paymentId) continue;
            currentPaymentTable.setRowChecked(row, true);
        }
        int importedPaymentId = this.getImportedPaymentId(paymentId);
        if (importedPaymentId > 0) {
            for (int row = 0; row < importedPaymentTable.getRowCount(); ++row) {
                IDColumn record = (IDColumn)importedPaymentTable.getValueAt(row, 0);
                if (record == null || record.getRecord_ID() != importedPaymentId) continue;
                importedPaymentTable.setRowChecked(row, true);
            }
        }
    }

    public String validateParameters() {
        StringBuffer message = new StringBuffer();
        if (this.bankAccountId <= 0) {
            message.append("@C_BankAccount_ID@ @NotFound@");
        }
        if (message.length() > 0) {
            return message.toString();
        }
        if (this.matchMode < 0) {
            if (message.length() > 0) {
                message.append(Env.NL);
            }
            message.append("@MatchMode@ @NotFound@");
        }
        return null;
    }

    public MBankAccount getAccount() {
        return this.account;
    }

    public void setAccount(MBankAccount account) {
        this.account = account;
    }

    public BigDecimal getAmtFrom() {
        return this.amtFrom;
    }

    public void setAmtFrom(BigDecimal amtFrom) {
        this.amtFrom = amtFrom;
    }

    public BigDecimal getAmtTo() {
        return this.amtTo;
    }

    public void setAmtTo(BigDecimal amtTo) {
        this.amtTo = amtTo;
    }

    public Timestamp getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Timestamp dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Timestamp getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Timestamp dateTo) {
        this.dateTo = dateTo;
    }

    public int getBpartnerId() {
        return this.bpartnerId;
    }

    public void setBpartnerId(int bpartnerId) {
        this.bpartnerId = bpartnerId;
    }

    public int getMatchedMode() {
        return this.matchMode;
    }

    public void setMatchMode(int matchMode) {
        this.matchMode = matchMode;
    }

    public int getBankAccountId() {
        return this.bankAccountId;
    }

    public boolean isHasSelection() {
        return this.hasSelection;
    }

    public void setHasSelection(boolean hasSelection) {
        this.hasSelection = hasSelection;
    }
}

