/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.eevolution.process.ValuationEffectiveDateAbstract;

public class ValuationEffectiveDate
extends ValuationEffectiveDateAbstract {
    private List<MAcctSchema> acctSchemas = new ArrayList<MAcctSchema>();
    private List<MCostType> costTypes = new ArrayList<MCostType>();
    private List<MCostElement> costElements = new ArrayList<MCostElement>();
    private List<MWarehouse> warehouses = new ArrayList<MWarehouse>();
    private int[] products = new int[0];
    private StringBuffer whereClause1 = null;
    private StringBuffer whereClause2 = null;
    PreparedStatement pstmt = null;
    private int batchSize = 1000;
    private int count = 0;

    @Override
    protected String doIt() throws Exception {
        this.setup();
        for (MAcctSchema acctSchema : this.acctSchemas) {
            for (MWarehouse warehouse : this.warehouses) {
                for (MCostType costType : this.costTypes) {
                    for (MCostElement costElement : this.costElements) {
                        for (int productId : this.products) {
                            this.generateInventoryValue(productId, acctSchema.getC_AcctSchema_ID(), acctSchema.getC_Currency_ID(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), warehouse.getM_Warehouse_ID());
                        }
                    }
                }
            }
        }
        this.pstmt.executeBatch();
        this.commitEx();
        DB.close(this.pstmt);
        this.updatePricePO();
        DB.executeUpdate("UPDATE T_InventoryValue SET Cost = CASE WHEN QtyOnHand <> 0 THEN (CostAmt + CostAmtLL) / QtyOnHand ELSE  0 END  ,  CumulatedAmt = CASE WHEN QtyOnHand <> 0  THEN  CostAmt + CostAmtLL ELSE 0 END ,  DateValue = " + DB.TO_DATE(this.getDateValue()) + " WHERE AD_PInstance_ID=?", this.getAD_PInstance_ID(), this.get_TrxName());
        return "@Ok@ " + this.count;
    }

    private void updatePricePO() {
        StringBuffer update = new StringBuffer("UPDATE T_InventoryValue iv SET PricePO = (SELECT MAX(currencyConvert (po.PricePO,po.C_Currency_ID,iv.C_Currency_ID,iv.DateValue,null, po.AD_Client_ID,po.AD_Org_ID)) FROM M_Product_PO po WHERE po.M_Product_ID=iv.M_Product_ID AND po.IsCurrentVendor='Y') ");
        if (this.getPriceListVersionId() != 0) {
            update.append(", PriceList = (SELECT currencyConvert(pp.PriceList,pl.C_Currency_ID,iv.C_Currency_ID,iv.DateValue,null, pl.AD_Client_ID,pl.AD_Org_ID) FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pp.M_Product_ID=iv.M_Product_ID AND pp.M_PriceList_Version_ID=iv.M_PriceList_Version_ID AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID AND plv.M_PriceList_ID=pl.M_PriceList_ID), PriceStd = (SELECT currencyConvert(pp.PriceStd,pl.C_Currency_ID,iv.C_Currency_ID,iv.DateValue,null, pl.AD_Client_ID,pl.AD_Org_ID) FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pp.M_Product_ID=iv.M_Product_ID AND pp.M_PriceList_Version_ID=iv.M_PriceList_Version_ID AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID AND plv.M_PriceList_ID=pl.M_PriceList_ID), PriceLimit = (SELECT currencyConvert(pp.PriceLimit,pl.C_Currency_ID,iv.C_Currency_ID,iv.DateValue,null, pl.AD_Client_ID,pl.AD_Org_ID) FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pp.M_Product_ID=iv.M_Product_ID AND pp.M_PriceList_Version_ID=iv.M_PriceList_Version_ID AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID AND plv.M_PriceList_ID=pl.M_PriceList_ID)");
        }
        update.append(" WHERE iv.AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        DB.executeUpdateEx(update.toString(), this.get_TrxName());
    }

    private void setup() {
        if (this.getAcctSchemaId() > 0) {
            this.acctSchemas.add(MAcctSchema.get(this.getCtx(), this.getAcctSchemaId(), this.get_TrxName()));
        } else {
            this.acctSchemas = Arrays.asList(MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getCostTypeId() > 0) {
            this.costTypes.add(new MCostType(this.getCtx(), this.getCostTypeId(), this.get_TrxName()));
        } else {
            this.costTypes = MCostType.get(this.getCtx(), this.get_TrxName());
        }
        if (this.getCostElementId() > 0) {
            this.costElements.add(MCostElement.get(this.getCtx(), this.getCostElementId()));
        } else {
            this.costElements = MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
        }
        if (this.getWarehouseId() > 0) {
            this.warehouses.add(MWarehouse.get(this.getCtx(), this.getWarehouseId(), this.get_TrxName()));
        } else {
            this.warehouses = new Query(this.getCtx(), "M_Warehouse", "", this.get_TrxName()).setClient_ID().list();
        }
        this.products = this.getProductId() == 0 ? new Query(this.getCtx(), "M_Product", "", this.get_TrxName()).setClient_ID().getIDs() : new int[]{this.getProductId()};
        this.setWhere();
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO T_InventoryValue ").append("(AD_PInstance_ID,DateValue,AD_Client_ID,AD_Org_ID,C_AcctSchema_ID,M_CostElement_ID,M_CostType_ID,M_Warehouse_ID,").append("M_Product_ID,M_Product_Category_ID,M_AttributeSetInstance_ID,Group1,Group2,QtyOnHand,CostAmt,CostAmtLL, M_PriceList_Version_ID, C_Currency_ID) ").append("SELECT ").append(this.getAD_PInstance_ID()).append(",").append("tc.DateAcct").append(",").append("p.AD_Client_ID,p.AD_Org_ID, tc.C_AcctSchema_ID ,tc.M_CostElement_ID,tc.M_CostType_ID, tc.M_Warehouse_ID,p.M_Product_ID,").append("p.M_Product_Category_ID,tc.M_AttributeSetInstance_ID,p.Group1,p.Group2,  tc.qty + tc.cumulatedqty AS QtyOnHand,").append(" CASE WHEN tc.Qty < 0 OR (tc.qty = 0 AND tc.cumulatedqty < 0) THEN ((tc.costAmt + tc.costadjustment) * -1) + tc.CumulatedAmt ELSE ((tc.costAmt + tc.costadjustment) * 1) + tc.CumulatedAmt END  AS CostAmt,").append(" CASE WHEN tc.Qty < 0 OR (tc.qty = 0 AND tc.cumulatedqty < 0) THEN ((tc.costAmtLL + tc.costadjustmentLL) * -1)  + tc.CumulatedAmtLL ELSE ((tc.costAmtLL + tc.costadjustmentLL) * 1) + tc.CumulatedAmtLL END AS CostAmtLL, ").append(this.getPriceListVersionId() != 0 ? Integer.valueOf(this.getPriceListVersionId()) : "null").append(", ? ").append(" FROM M_Product p ").append(" INNER JOIN M_CostDetail tc ON (p.M_Product_ID=tc.M_Product_ID) ");
        insert.append(this.whereClause1).append(this.whereClause2);
        this.pstmt = DB.prepareStatement(insert.toString(), 1004, 1008, this.get_TrxName());
    }

    public void setWhere() {
        this.whereClause1 = new StringBuffer("WHERE tc.IsReversal='N' ");
        this.whereClause2 = new StringBuffer(" AND tc.SeqNo = (SELECT MAX(SeqNo) FROM M_CostDetail tc1").append(" WHERE tc1.IsReversal='N' AND tc1.M_Product_ID=tc.M_Product_ID AND tc1.M_Warehouse_ID = tc.M_Warehouse_ID ");
        this.whereClause1.append("AND tc.DateAcct<= ").append(DB.TO_DATE(this.getDateValue()));
        this.whereClause2.append("AND tc1.DateAcct<= ").append(DB.TO_DATE(this.getDateValue()));
        this.whereClause1.append(" AND p.M_Product_ID=? ");
        if (this.getProductCategoryId() > 0) {
            this.whereClause1.append(" AND p.M_Product_Category_ID =? ");
        }
        this.whereClause1.append(" AND tc.C_AcctSchema_ID=? ");
        this.whereClause2.append(" AND tc1.C_AcctSchema_ID = tc.C_AcctSchema_ID");
        this.whereClause1.append(" AND tc.M_CostType_ID =?  ");
        this.whereClause2.append(" AND tc1.M_CostType_ID=tc.M_CostType_ID ");
        this.whereClause1.append(" AND tc.M_CostElement_ID=? ");
        this.whereClause2.append(" AND tc1.M_CostElement_ID = tc.M_CostElement_ID");
        this.whereClause1.append(" AND tc.M_Warehouse_ID=? ");
        this.whereClause2.append(")");
    }

    private void generateInventoryValue(int productId, int accountSchemaId, int currencyId, int costTypeId, int costElementId, int warehouseId) throws SQLException {
        this.pstmt.setInt(1, currencyId);
        this.pstmt.setInt(2, productId);
        this.pstmt.setInt(3, accountSchemaId);
        this.pstmt.setInt(4, costTypeId);
        this.pstmt.setInt(5, costElementId);
        this.pstmt.setInt(6, warehouseId);
        if (this.getProductCategoryId() > 0) {
            this.pstmt.setInt(6, this.getProductCategoryId());
        }
        this.pstmt.addBatch();
        if (++this.count % this.batchSize == 0) {
            this.pstmt.executeBatch();
            this.commitEx();
        }
    }
}

