/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.Timestamp;
import java.util.Optional;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MTransaction;
import org.compiere.util.Env;

class TransactionsToProcess {
    private MTransaction transaction;
    private IDocumentLine model;
    private Timestamp dateAcct;
    private int transactionId = 0;
    private int productId = 0;
    private boolean process = false;
    private boolean isInventory = false;
    private String movementType = "";
    private int inOutLineId = 0;
    private String trxName = null;

    public TransactionsToProcess(MTransaction transaction, IDocumentLine model, String trxName) {
        this.transaction = transaction;
        this.model = model;
        this.dateAcct = model.getDateAcct();
        this.trxName = trxName;
        Optional.ofNullable(this.transaction).ifPresent(trx -> this.setProductId(trx.getM_Product_ID()));
        this.isInventory = false;
    }

    public TransactionsToProcess(int transactionId, int productId, Timestamp dateAcct, String movementType, int inOutLineId, String trxName) {
        this.transactionId = transactionId;
        this.productId = productId;
        this.dateAcct = dateAcct;
        this.movementType = movementType;
        this.inOutLineId = inOutLineId;
        this.trxName = trxName;
        this.isInventory = true;
    }

    public MTransaction getTransaction() {
        this.transaction = Optional.ofNullable(this.transaction).orElseGet(() -> new MTransaction(Env.getCtx(), this.transactionId, this.trxName));
        return this.transaction;
    }

    public void setTransaction(MTransaction transaction) {
        this.transaction = transaction;
        Optional.ofNullable(this.transaction).ifPresent(trx -> this.setTransactionId(trx.getM_Transaction_ID()));
    }

    public IDocumentLine getModel() {
        return this.model;
    }

    public void setModel(IDocumentLine model) {
        this.model = model;
    }

    public Timestamp getDateAcct() {
        return this.dateAcct;
    }

    public void setDateAcct(Timestamp dateAcct) {
        this.dateAcct = dateAcct;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public int getProductId() {
        return this.productId;
    }

    public void setProductId(int productId) {
        this.productId = productId;
    }

    public boolean isProcess() {
        return this.process;
    }

    public void setProcess(boolean process) {
        this.process = process;
    }

    public boolean isInventory() {
        return this.isInventory;
    }

    public String getMovementType() {
        return this.movementType;
    }

    public void setMovementType(String movementType) {
        this.movementType = movementType;
    }

    public int getInOutLineId() {
        return this.inOutLineId;
    }

    public void setInOutLineId(int inOutLineId) {
        this.inOutLineId = inOutLineId;
    }

    public String getTrxName() {
        return this.trxName;
    }

    public void setTrxName(String trxName) {
        this.trxName = trxName;
    }

    public String toString() {
        return this.getDateAcct().toString().concat(Integer.toString(this.getTransactionId())).concat(this.model == null ? "" : this.model.getClass().getCanonicalName());
    }
}

