/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MPayment;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_C_BP_BankAccount;
import org.compiere.process.ProcessInfo;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.process.SendPayrollReceiptByEmailAbstract;
import org.eevolution.service.dsl.ProcessBuilder;

public class SendPayrollReceiptByEmail
extends SendPayrollReceiptByEmailAbstract {
    private int counter = 0;
    private int errors = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("R_MailText_ID=" + this.getMailTextId());
        MMailText mMailText = new MMailText(this.getCtx(), this.getMailTextId(), this.get_TrxName());
        if (mMailText.getR_MailText_ID() == 0) {
            throw new Exception("@R_MailText_ID@=" + this.getMailTextId() + " @NotFound@ ");
        }
        MClient mClient = MClient.get(this.getCtx());
        if (mClient.getAD_Client_ID() == 0) {
            throw new Exception(" @AD_Client_ID@  @NotFound@ ");
        }
        if (mClient.getSMTPHost() == null || mClient.getSMTPHost().length() == 0) {
            throw new Exception("@SMTPHost@  @NotFound@ ");
        }
        long l = System.currentTimeMillis();
        this.sendEMail(mMailText);
        return "@Created@=" + this.counter + ", @Errors@=" + this.errors + " - " + (System.currentTimeMillis() - l) + "ms";
    }

    private void sendEMail(MMailText mMailText) {
        int[] nArray = this.getPaymentIds();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray[i];
            Boolean bl = this.sendIndividualMail(mMailText, n2, null);
            if (bl == null) continue;
            if (bl.booleanValue()) {
                ++this.counter;
                continue;
            }
            ++this.errors;
        }
    }

    private Boolean sendIndividualMail(MMailText mMailText, int n, String string) {
        try {
            MUser mUser2;
            Object object;
            MPayment mPayment = new MPayment(this.getCtx(), n, this.get_TrxName());
            MBPartner mBPartner = (MBPartner)mPayment.getC_BPartner();
            String string2 = mMailText.getMailText(true);
            if (string != null) {
                string2 = string2 + string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("C_BPartner_ID").append(" = ? AND ").append("ContactType").append("=?");
            MBPartnerLocation mBPartnerLocation = (MBPartnerLocation)new Query(this.getCtx(), "C_BPartner_Location", stringBuffer.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(mBPartner.getC_BPartner_ID(), "Primary").first();
            String string3 = null;
            if (mBPartnerLocation != null) {
                string3 = mBPartnerLocation.getEMail();
            }
            if (Util.isEmpty(string3) && (object = this.getBPAccountInfo(mPayment, true)) != null && Util.isEmpty(string3 = ((X_C_BP_BankAccount)object).getA_EMail()) && ((X_C_BP_BankAccount)object).getAD_User_ID() != 0) {
                mUser2 = MUser.get(this.getCtx(), ((X_C_BP_BankAccount)object).getAD_User_ID());
                string3 = mUser2.getEMail();
            }
            if (Util.isEmpty(string3) && ((Optional)(object = Arrays.asList(MUser.getOfBPartner(this.getCtx(), mBPartner.getC_BPartner_ID(), this.get_TrxName())).stream().filter(mUser -> !Util.isEmpty(mUser.getNotificationType()) && (mUser.getNotificationType().equals("E") || mUser.getNotificationType().equals("B"))).filter(mUser -> !Util.isEmpty(mUser.getEMail())).findFirst())).isPresent()) {
                string3 = ((MUser)((Optional)object).get()).getEMail();
            }
            if (Util.isEmpty(string3)) {
                this.addLog(0, null, null, mBPartner.getName() + " @Email@ @NotFound@");
                return false;
            }
            object = MClient.get(this.getCtx());
            mUser2 = MUser.get(this.getCtx(), Env.getAD_User_ID(this.getCtx()));
            EMail eMail = ((MClient)object).createEMail(mUser2, string3, mMailText.getMailHeader(), string2);
            if (mMailText.isHtml()) {
                eMail.setMessageHTML(mMailText.getMailHeader(), string2);
            } else {
                eMail.setSubject(mMailText.getMailHeader());
                eMail.setMessageText(string2);
            }
            File file = this.getPDF(n);
            if (file != null) {
                eMail.addAttachment(file);
            }
            if (!eMail.isValid() && !eMail.isValid(true)) {
                this.addLog(0, null, null, mBPartner.getName() + " @Email@ @NotValid@ " + eMail);
                this.log.warning("NOT VALID - " + eMail);
                return Boolean.FALSE;
            }
            boolean bl = "OK".equals(eMail.send());
            if (bl) {
                this.addLog(0, null, null, mBPartner.getName() + " @Email@ @OK@");
                this.log.fine(mBPartner.getURL());
            } else {
                this.log.warning("FAILURE - " + mBPartner.getURL());
            }
            this.addLog(0, null, null, (bl ? "@OK@" : "@ERROR@") + " - " + eMail.getFrom().getAddress());
            return bl;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    public MBPBankAccount getBPAccountInfo(MPayment mPayment, boolean bl) {
        if (mPayment.getC_BP_BankAccount_ID() != 0) {
            return (MBPBankAccount)mPayment.getC_BP_BankAccount();
        }
        if (bl) {
            List<MBPBankAccount> list = MBPBankAccount.getByPartner(Env.getCtx(), mPayment.getC_BPartner_ID());
            if (list == null || list.size() == 0) {
                return null;
            }
            Optional<MBPBankAccount> optional = list.stream().filter(mBPBankAccount -> mBPBankAccount.isACH()).findFirst();
            if (optional.isPresent()) {
                return optional.get();
            }
            list.get(0);
        }
        return null;
    }

    private int[] getPaymentIds() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EXISTS (SELECT 1 FROM C_PaySelectionCheck psc ").append("INNER JOIN C_PaySelectionLine psl ON(psc.C_PaySelection_ID = psl.C_PaySelection_ID AND psl.C_BPartner_ID = psc.C_BPartner_ID) ").append("INNER JOIN HR_Movement m ON (psl.HR_Movement_ID = m.HR_Movement_ID) ").append("WHERE C_Payment.C_Payment_ID = psc.C_Payment_ID ").append("AND m.HR_Process_ID = ? ");
        arrayList.add(this.getHRProcessId());
        if (this.getBPartnerId() > 0) {
            stringBuffer.append("AND psc.C_BPartner_ID=? ");
            arrayList.add(this.getBPartnerId());
        }
        if (this.getDepartmentId() > 0) {
            stringBuffer.append("AND m.HR_Department_ID=? ");
            arrayList.add(this.getDepartmentId());
        }
        if (this.getJobId() > 0) {
            stringBuffer.append("AND m.HR_Job_ID=? ");
            arrayList.add(this.getJobId());
        }
        if (this.getActivityId() > 0) {
            stringBuffer.append("AND m.C_Activity_ID=? ");
            arrayList.add(this.getActivityId());
        }
        if (this.getBPGroupId() > 0) {
            stringBuffer.append("AND EXISTS (SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = psc.C_BPartner_ID AND bp.IsEmployee=? AND bp.C_BP_Group_ID = ?)");
            arrayList.add(true);
            arrayList.add(this.getBPGroupId());
        }
        stringBuffer.append(")");
        return new Query(this.getCtx(), "C_Payment", stringBuffer.toString(), this.get_TrxName()).setClient_ID().setParameters(arrayList).getIDs();
    }

    private File getPDF(Integer n) {
        if (n <= 0) {
            return null;
        }
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(this.getADProcessId()).withTitle(SendPayrollReceiptByEmail.getProcessName()).withRecordId(MPayment.Table_ID, n).execute();
        return processInfo.getPDFReport();
    }
}

