/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.NoVendorForProductException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MQuery;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWorkflow;
import org.eevolution.engine.warehouse.WMRuleEngine;
import org.eevolution.exceptions.NoBPartnerLinkedforOrgException;
import org.eevolution.exceptions.NoPlantForWarehouseException;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.model.X_DD_OrderLine;
import org.eevolution.process.ReleaseInOutBoundAbstract;

public class ReleaseInOutBound
extends ReleaseInOutBoundAbstract {
    private Timestamp today = new Timestamp(System.currentTimeMillis());
    private MDDOrder orderDistribution;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MLocator mLocator = Optional.ofNullable(new MLocator(this.getCtx(), this.getLocatorId(), this.get_TrxName())).orElseThrow(() -> new AdempiereException("@M_Locator_ID@ @NotFound@"));
        List<?> list = this.getInstancesForSelection(this.get_TrxName());
        Hashtable<Integer, MWMInOutBound> hashtable = new Hashtable<Integer, MWMInOutBound>();
        list.forEach(mWMInOutBoundLine -> {
            mWMInOutBoundLine.setM_LocatorTo_ID(mLocator.getM_Locator_ID());
            mWMInOutBoundLine.saveEx();
            MWMInOutBound mWMInOutBound = mWMInOutBoundLine.getParent();
            if (!hashtable.contains(mWMInOutBound.get_ID())) {
                hashtable.put(mWMInOutBound.get_ID(), mWMInOutBound);
            }
        });
        hashtable.forEach((n, mWMInOutBound) -> {
            if ("DR".equals(mWMInOutBound.getDocStatus()) || "IP".equals(mWMInOutBound.getDocStatus())) {
                mWMInOutBound.setDocAction("CO");
                mWMInOutBound.processIt("CO");
                mWMInOutBound.saveEx();
            }
        });
        list.forEach(mWMInOutBoundLine -> {
            Serializable serializable;
            if (mWMInOutBoundLine.getDD_OrderLine_ID() > 0) {
                serializable = (MDDOrderLine)mWMInOutBoundLine.getDD_OrderLine();
                if (((X_DD_OrderLine)serializable).getWM_InOutBoundLine_ID() <= 0) {
                    ((X_DD_OrderLine)serializable).setWM_InOutBoundLine_ID(((X_DD_OrderLine)serializable).getWM_InOutBoundLine_ID());
                    ((PO)serializable).saveEx();
                }
                if (((X_DD_OrderLine)serializable).getM_LocatorTo_ID() == mWMInOutBoundLine.getM_LocatorTo_ID()) {
                    return;
                }
            }
            serializable = this.createDistributionOrder((MWMInOutBoundLine)mWMInOutBoundLine);
            if (this.isCreateSupply() && ((BigDecimal)serializable).signum() > 0) {
                Env.setContext(mWMInOutBoundLine.getCtx(), "IsCreateSupply", "Y");
                this.createSupply((MWMInOutBoundLine)mWMInOutBoundLine, (BigDecimal)serializable);
            }
        });
        Optional.ofNullable(this.getDocAction()).flatMap(string -> Optional.ofNullable(this.orderDistribution)).ifPresent(mDDOrder -> {
            mDDOrder.setDocAction(this.getDocAction());
            mDDOrder.processIt("CO");
            mDDOrder.saveEx();
        });
        Optional.ofNullable(this.orderDistribution).ifPresent(mDDOrder -> {
            if (this.isPrintPickList()) {
                ReportEngine reportEngine = this.getReportEngine("DistributionOrder_Header  ** TEMPLATE **", "DD_Order_Header_v", this.orderDistribution.getDD_Order_ID());
                if (reportEngine == null) {
                    throw new AdempiereException("@NotFound@ @AD_PrintFormat_ID@");
                }
                ReportCtl.preview(reportEngine);
                reportEngine.print();
            }
        });
        Optional<String> optional = Optional.ofNullable(this.orderDistribution).map(mDDOrder -> "@Created@ " + mDDOrder.getDocumentInfo());
        return optional.orElse("");
    }

    private BigDecimal createDistributionOrder(MWMInOutBoundLine mWMInOutBoundLine) {
        int n = 0;
        WMRuleEngine wMRuleEngine = WMRuleEngine.get();
        List<MStorage> list = wMRuleEngine.getStorage(mWMInOutBoundLine, this.getAreaTypeId(), this.getSectionTypeId());
        AtomicReference<BigDecimal> atomicReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (list.size() > 0) {
            MLocator mLocator = MLocator.get(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getM_LocatorTo_ID());
            List<MWarehouse> list2 = Arrays.asList(MWarehouse.getInTransitForOrg(this.getCtx(), mLocator.getAD_Org_ID()));
            if (list2.isEmpty()) {
                throw new AdempiereException("@M_Warehouse_ID@ @IsInTransit@ @NotFound@");
            }
            MOrg mOrg = MOrg.get(this.getCtx(), mLocator.getAD_Org_ID());
            int n2 = mOrg.getLinkedC_BPartner_ID(this.get_TrxName());
            if (n2 <= 0) {
                throw new NoBPartnerLinkedforOrgException(mOrg);
            }
            MBPartner mBPartner = MBPartner.get(this.getCtx(), n2);
            if (this.orderDistribution == null) {
                this.orderDistribution = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
                this.orderDistribution.setAD_Org_ID(mLocator.getAD_Org_ID());
                this.orderDistribution.setC_BPartner_ID(n2);
                this.orderDistribution.setDescription(Msg.parseTranslation(this.getCtx(), "@Generate@ @From@ " + mWMInOutBoundLine.getParent().getDocumentInfo()));
                if (this.getDocTypeId() > 0) {
                    this.orderDistribution.setC_DocType_ID(this.getDocTypeId());
                } else {
                    this.orderDistribution.setC_DocType_ID(MDocType.getDocType("DOO"));
                }
                this.orderDistribution.setM_Warehouse_ID(((MWarehouse)list2.stream().findFirst().get()).get_ID());
                this.orderDistribution.setDocAction(Optional.ofNullable(this.getDocAction()).orElseGet(() -> "PR"));
                List<MUser> list3 = Arrays.asList(MUser.getOfBPartner(this.getCtx(), mBPartner.getC_BPartner_ID(), this.get_TrxName()));
                if (list3.isEmpty()) {
                    throw new AdempiereException("@AD_User_ID@ @NotFound@ @Value@ - @C_BPartner_ID@ : " + mBPartner.getValue() + " - " + mBPartner.getName());
                }
                this.orderDistribution.setAD_User_ID(((MUser)list3.stream().findFirst().get()).getAD_User_ID());
                this.orderDistribution.setDateOrdered(this.getToday());
                this.orderDistribution.setDatePromised(this.getToday());
                this.orderDistribution.setM_Shipper_ID(n);
                this.orderDistribution.setM_FreightCategory_ID(mWMInOutBoundLine.getParent().getM_FreightCategory_ID());
                this.orderDistribution.setFreightCostRule(mWMInOutBoundLine.getParent().getFreightCostRule());
                this.orderDistribution.setFreightAmt(mWMInOutBoundLine.getParent().getFreightAmt());
                this.orderDistribution.setIsInDispute(false);
                this.orderDistribution.setIsInTransit(false);
                this.orderDistribution.setSalesRep_ID(this.getAD_User_ID());
                this.orderDistribution.setDocStatus("DR");
                this.orderDistribution.saveEx();
            }
            list.stream().filter(mStorage -> mStorage.getQtyOnHand().signum() > 0).forEach(mStorage -> {
                BigDecimal bigDecimal3 = mWMInOutBoundLine.getQtyToPick().subtract((BigDecimal)atomicReference.get());
                if (bigDecimal3.signum() > 0) {
                    MDDOrderLine mDDOrderLine = new MDDOrderLine(this.orderDistribution);
                    mDDOrderLine.setM_Locator_ID(mStorage.getM_Locator_ID());
                    mDDOrderLine.setM_LocatorTo_ID(mWMInOutBoundLine.getM_LocatorTo_ID());
                    mDDOrderLine.setC_UOM_ID(mWMInOutBoundLine.getC_UOM_ID());
                    mDDOrderLine.setM_Product_ID(mWMInOutBoundLine.getM_Product_ID());
                    mDDOrderLine.setDateOrdered(this.getToday());
                    mDDOrderLine.setDatePromised(mWMInOutBoundLine.getPickDate());
                    mDDOrderLine.setWM_InOutBoundLine_ID(mWMInOutBoundLine.getWM_InOutBoundLine_ID());
                    mDDOrderLine.setIsInvoiced(false);
                    if (bigDecimal3.compareTo(mStorage.getQtyOnHand()) < 0) {
                        mDDOrderLine.setConfirmedQty(mWMInOutBoundLine.getQtyToPick());
                        mDDOrderLine.setQtyEntered(mWMInOutBoundLine.getQtyToPick());
                        mDDOrderLine.setQtyOrdered(mWMInOutBoundLine.getQtyToPick());
                        mDDOrderLine.setTargetQty(mWMInOutBoundLine.getQtyToPick());
                        mDDOrderLine.setM_AttributeSetInstance_ID(mStorage.getM_AttributeSetInstance_ID());
                        mDDOrderLine.setM_AttributeSetInstanceTo_ID(mStorage.getM_AttributeSetInstance_ID());
                        atomicReference.updateAndGet(bigDecimal2 -> bigDecimal2.add(bigDecimal3));
                    } else {
                        mDDOrderLine.setConfirmedQty(mStorage.getQtyOnHand());
                        mDDOrderLine.setQtyEntered(mStorage.getQtyOnHand());
                        mDDOrderLine.setQtyOrdered(mStorage.getQtyOnHand());
                        mDDOrderLine.setTargetQty(mStorage.getQtyOnHand());
                        mDDOrderLine.setM_AttributeSetInstance_ID(mStorage.getM_AttributeSetInstance_ID());
                        mDDOrderLine.setM_AttributeSetInstanceTo_ID(mStorage.getM_AttributeSetInstance_ID());
                        atomicReference.updateAndGet(bigDecimal -> bigDecimal.add(mStorage.getQtyOnHand()));
                    }
                    if (((BigDecimal)atomicReference.get()).signum() > 0) {
                        mWMInOutBoundLine.setM_Locator_ID(mStorage.getM_Locator_ID());
                        mWMInOutBoundLine.saveEx();
                    }
                    mDDOrderLine.setFreightAmt(mWMInOutBoundLine.getFreightAmt());
                    mDDOrderLine.setM_FreightCategory_ID(mWMInOutBoundLine.getM_FreightCategory_ID());
                    mDDOrderLine.setM_Shipper_ID(mWMInOutBoundLine.getM_Shipper_ID());
                    mDDOrderLine.saveEx();
                }
            });
        }
        return mWMInOutBoundLine.getQtyToPick().subtract(atomicReference.get());
    }

    private void createSupply(MWMInOutBoundLine mWMInOutBoundLine, BigDecimal bigDecimal) {
        Optional<MProduct> optional = Optional.ofNullable(MProduct.get(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getM_Product_ID()));
        optional.ifPresent(mProduct -> {
            if (mProduct.isBOM()) {
                this.createManufacturingOrder(mWMInOutBoundLine, (MProduct)mProduct, bigDecimal);
            } else if (mProduct.isPurchased()) {
                this.createRequisition(mWMInOutBoundLine, (MProduct)mProduct, bigDecimal);
            }
        });
    }

    private MRequisition createRequisition(MWMInOutBoundLine mWMInOutBoundLine, MProduct mProduct, BigDecimal bigDecimal) {
        List<MProductPO> list = Arrays.asList(MProductPO.getOfProduct(this.getCtx(), mProduct.getM_Product_ID(), this.get_TrxName()));
        Optional<MProductPO> optional = list.stream().filter(mProductPO -> mProductPO.isCurrentVendor() && mProductPO.getC_BPartner_ID() > 0).findFirst();
        return optional.map(mProductPO -> {
            String string = "SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?";
            int n = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?", mProductPO.getC_BPartner_ID());
            MLocator mLocator = MLocator.get(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getM_LocatorTo_ID());
            MRequisition mRequisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
            mRequisition.setAD_Org_ID(mLocator.getAD_Org_ID());
            mRequisition.setAD_User_ID(this.getAD_User_ID());
            mRequisition.setDateRequired(mWMInOutBoundLine.getPickDate());
            mRequisition.setDescription(Msg.parseTranslation(this.getCtx(), "@Generated@ @From@ @WM_InOutBound_ID@" + mWMInOutBoundLine.getParent().getDocumentInfo()));
            mRequisition.setM_Warehouse_ID(mLocator.getM_Warehouse_ID());
            mRequisition.setC_DocType_ID(MDocType.getDocType("POR"));
            if (n > 0) {
                mRequisition.setM_PriceList_ID(n);
            }
            mRequisition.saveEx();
            MRequisitionLine mRequisitionLine = new MRequisitionLine(mRequisition);
            mRequisitionLine.setLine(10);
            mRequisitionLine.setAD_Org_ID(mLocator.getAD_Org_ID());
            mRequisitionLine.setC_BPartner_ID(mProductPO.getC_BPartner_ID());
            mRequisitionLine.setM_Product_ID(mProduct.getM_Product_ID());
            mRequisitionLine.setPrice();
            mRequisitionLine.setPriceActual(Env.ZERO);
            mRequisitionLine.setQty(bigDecimal);
            mRequisitionLine.saveEx();
            Optional<MOrderLine> optional = Optional.ofNullable(new MOrderLine(this.getCtx(), mWMInOutBoundLine.getC_OrderLine_ID(), this.get_TrxName()));
            optional.ifPresent(mOrderLine -> {
                StringBuilder stringBuilder = new StringBuilder(Optional.ofNullable(mOrderLine.getDescription()).orElse(""));
                stringBuilder.append(" ").append(Msg.translate(this.getCtx(), "M_Requisition_ID")).append(" : ").append(mRequisition.getDocumentNo());
                mOrderLine.setDescription(stringBuilder.toString());
                mOrderLine.saveEx();
                StringBuilder stringBuilder2 = new StringBuilder(Optional.ofNullable(mWMInOutBoundLine.getDescription()).orElse(""));
                stringBuilder2.append(" ").append(Msg.translate(mWMInOutBoundLine.getCtx(), "M_Requisition_ID")).append(" : ").append(mRequisition.getDocumentNo());
                mWMInOutBoundLine.setDescription(stringBuilder2.toString());
                mWMInOutBoundLine.saveEx();
            });
            return mRequisition;
        }).orElseThrow(() -> new NoVendorForProductException(""));
    }

    private MPPOrder createManufacturingOrder(MWMInOutBoundLine mWMInOutBoundLine, MProduct mProduct, BigDecimal bigDecimal) {
        Optional<MPPOrder> optional = Optional.ofNullable(MPPOrder.forC_OrderLine_ID(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getC_OrderLine_ID(), mProduct.get_ID(), mWMInOutBoundLine.get_TrxName()));
        return optional.map(mPPOrder -> {
            mPPOrder.setM_Shipper_ID(mWMInOutBoundLine.getParent().getM_Shipper_ID());
            mPPOrder.setM_FreightCategory_ID(mWMInOutBoundLine.getParent().getM_FreightCategory_ID());
            mPPOrder.setFreightCostRule(mWMInOutBoundLine.getParent().getFreightCostRule());
            return mPPOrder;
        }).orElseGet(() -> {
            Optional<MPPProductPlanning> optional = Optional.ofNullable(MPPProductPlanning.find(this.getCtx(), mWMInOutBoundLine.getAD_Org_ID(), mWMInOutBoundLine.getM_Warehouse_ID(), 0, mProduct.getM_Product_ID(), this.get_TrxName()));
            MPPProductBOM mPPProductBOM = optional.map(MPPProductPlanning::getPP_Product_BOM).orElseGet(() -> {
                Optional<MPPProductBOM> optional = Optional.ofNullable(MPPProductBOM.getDefault(mProduct, this.get_TrxName()));
                return optional.orElseThrow(() -> new AdempiereException("@PP_Product_BOM_ID@ @NotFound@"));
            });
            MWorkflow mWorkflow = optional.map(MPPProductPlanning::getAD_Workflow).orElseGet(() -> {
                int n = MWorkflow.getWorkflowSearchKey(mProduct);
                Optional<Object> optional = Optional.ofNullable(n > 0 ? MWorkflow.get(this.getCtx(), MWorkflow.getWorkflowSearchKey(mProduct)) : null);
                return optional.orElseThrow(() -> new AdempiereException("@AD_Workflow_ID@ @NotFound@ @To@ @M_Product_ID@  @Value@ : " + mProduct.getValue() + " @Name@: " + mProduct.getName()));
            });
            int n = MPPProductPlanning.getPlantForWarehouse(mWMInOutBoundLine.getM_Warehouse_ID());
            if (n <= 0) {
                throw new NoPlantForWarehouseException(mWMInOutBoundLine.getM_Warehouse_ID());
            }
            StringBuilder stringBuilder = new StringBuilder(Msg.parseTranslation(this.getCtx(), "@Generated@ @From@ @WM_InOutBound_ID@"));
            stringBuilder.append("  ").append(mWMInOutBoundLine.getParent().getDocumentInfo());
            MPPProductPlanning mPPProductPlanning = new MPPProductPlanning(this.getCtx(), 0, this.get_TrxName());
            mPPProductPlanning.setAD_Org_ID(mWMInOutBoundLine.getAD_Org_ID());
            mPPProductPlanning.setM_Product_ID(mProduct.getM_Product_ID());
            mPPProductPlanning.setPlanner_ID(mWMInOutBoundLine.getParent().getSalesRep_ID());
            mPPProductPlanning.setPP_Product_BOM_ID(mPPProductBOM.getPP_Product_BOM_ID());
            mPPProductPlanning.setAD_Workflow_ID(mWorkflow.getAD_Workflow_ID());
            mPPProductPlanning.setM_Warehouse_ID(mWMInOutBoundLine.getM_Warehouse_ID());
            mPPProductPlanning.setS_Resource_ID(n);
            MPPOrder mPPOrder = MPPMRP.createMO(mPPProductPlanning, mWMInOutBoundLine.getC_OrderLine_ID(), mWMInOutBoundLine.getM_AttributeSetInstance_ID(), bigDecimal, mWMInOutBoundLine.getPickDate(), mWMInOutBoundLine.getShipDate(), stringBuilder.toString());
            Optional<MOrderLine> optional2 = Optional.ofNullable(new MOrderLine(this.getCtx(), mWMInOutBoundLine.getC_OrderLine_ID(), this.get_TrxName()));
            optional2.ifPresent(mOrderLine -> {
                Optional.ofNullable(mOrderLine.getDescription()).ifPresent(string -> stringBuilder.append((String)string));
                StringBuilder stringBuilder2 = new StringBuilder(Msg.translate(mOrderLine.getCtx(), "PP_Order_ID"));
                stringBuilder2.append(" : ").append(Optional.ofNullable(mPPOrder.getDocumentNo()).orElse(""));
                mOrderLine.setDescription(stringBuilder2.toString());
                mOrderLine.saveEx();
            });
            StringBuilder stringBuilder2 = new StringBuilder(Optional.ofNullable(mWMInOutBoundLine.getDescription()).orElse(""));
            stringBuilder2.append(Msg.translate(this.getCtx(), "PP_Order_ID")).append(" : ").append(Optional.ofNullable(mPPOrder.getDocumentNo()).orElse(""));
            mWMInOutBoundLine.setDescription(stringBuilder2.toString());
            mWMInOutBoundLine.saveEx();
            return mPPOrder;
        });
    }

    private ReportEngine getReportEngine(String string, String string2, int n) {
        int n2 = MPrintFormat.getPrintFormat_ID(string, MTable.getTable_ID(string2), this.getAD_Client_ID());
        Optional<MPrintFormat> optional = Optional.ofNullable(MPrintFormat.get(this.getCtx(), n2, true));
        return optional.map(mPrintFormat -> {
            MQuery mQuery = new MQuery(string2);
            mQuery.addRestriction("DD_Order_ID", "=", n);
            PrintInfo printInfo = new PrintInfo(string2, MTable.getTable_ID(string2), n);
            ReportEngine reportEngine = new ReportEngine(this.getCtx(), (MPrintFormat)mPrintFormat, mQuery, printInfo, this.get_TrxName());
            return reportEngine;
        }).orElseGet(() -> {
            this.addLog("@NotFound@ @AD_PrintFormat_ID@");
            return null;
        });
    }

    protected Timestamp getToday() {
        return this.today;
    }
}

